<?php
header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, X-Requested-With");
 
use Slim\App;
use Slim\Exception\NotFoundException;
use Slim\Http\Request;
use Slim\Http\Response;
use \Firebase\JWT\JWT;
require_once('../jwt/autoload.php');
require '../vendor/autoload.php';
require '../src/config/db.php';

$configuration = [
    'settings' => [
        'displayErrorDetails' => true,
        'determineRouteBeforeAppMiddleware' => true
    ],
];
$c = new \Slim\Container($configuration);
$c['logger'] = function($c) {
  return new Silalahi\Slim\Logger();
};
$app = new \Slim\App($c);

// date_default_timezone_set('America/New_York');


$app->add(function (Request $request, Response $response, callable $next) {
    
    $authorized = false;
    $route = $request->getAttribute('route');
    $path = $route->getPattern(); 
    if (empty($route)) {
        throw new NotFoundException($request, $response);
    } 
   	$authRoutes= array ( 
// 	   	'/admin/listallorders',
// 		'/admin/getAllPartnerCompanies',
// 		'/admin/getActivePartnerCompanies',
// 		'/admin/getPartnerCompanyDetails',
// 		'/admin/getPartners',
// 		'/admin/getAdminPatients',
// 		'/admin/getAdminGroups',
// 		'/admin/listpatientorders',
// 		'/admin/getPartnerGroups',
// 		'/admin/getActivePartnerGroups',
// 		'/admin/getGroupDetails',
// 		'/admin/updateGroupDetails',
// 		'/admin/listPartnerGroupPatients',
// 		'/admin/makenewOrder',
// 		'/patient/listpatientorders',
// 		'/patient/getorderdetails',
// 		'/patient/updateOrderStatus',
// 		'/patient/getorderdetails',
// 		'/user/updateOrderEditStatus',
// 		'/user/updateOrderDetails'
  	);
  
    $Authorization = $request->getHeader('Authorization');
    $token=$Authorization[0];
    $token=str_replace('Bearer','',$token);
    $token=trim(str_replace('"','',$token)); 
    $inputControl = $request->getParsedBody();
    
	if(isset($inputControl['user_id'])){
		$id	=	$inputControl['user_id'];
	}
//	else{
//		$id	=	1;
//	}
	
	$db = new db();
	$db = $db->connect(); 
	$checkUser = $db->prepare('SELECT id,username FROM rx_users WHERE id=:param1');
	$checkUser->bindParam("param1", $id);
	$checkUser->execute();
	$result = $checkUser->fetch();
	$authorized=false;
   	if (!empty($result)) { 
		$currentUser['id'] = $result['id'];
		$currentUser['email'] = $result['username'];  
		$jtoken= JWT::encode( array($currentUser['id'], $currentUser['email'] ), $db->getTokenJWT); 
		if($jtoken==$token){
			$authorized=true;
		}
		else{
		    //echo 'jtoken:'.$jtoken.'</br>';
		    //echo 'jtoken:'.$token.'</br>';
		}
   } 
	
	
  // $this->logger->write($path, Silalahi\Slim\Logger::INFO);
    if ($authorized||!in_array($path,$authRoutes)) {
        // authorized, call next middleware
        return $next($request, $response);
    } 
    $response->getBody()->write('You are not authorized to access this API');
    return $response
        ->withHeader('Access-Control-Allow-Headers', 'X-Requested-With, Content-Type, Accept, Origin, Authorization,authorization')
        ->withHeader('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS')
        ->withStatus(403);
});



$app->add(function ($req, $res, $next) {
    $response = $next($req, $res);
    return $response
            //->withHeader('Access-Control-Allow-Origin', '*')
            ->withHeader('Access-Control-Allow-Headers', 'X-Requested-With, Content-Type, Accept, Origin, Authorization')
            ->withHeader('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, PATCH, OPTIONS');
});

$app->options('/{routes:.+}', function ($request, $response, $args) {
    return $response;
});

// Customer Routes
  
require '../src/routes/auth/auth.php';

require '../src/routes/admin/admin.php';
require '../src/routes/admin/admin-partners.php';
require '../src/routes/admin/admin-order.php';

require '../src/routes/common/common-user.php';
require '../src/routes/public/common.php';


require '../src/routes/partners/partners.php';
require '../src/routes/partners/partner-patients.php';

require '../src/routes/patients/patient-orders.php';

$app->run();

