<?php

use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use \Firebase\JWT\JWT;


$app->post('/admin/addPartnerCompany', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$name = $inputControl['name'];
	$slug = preg_replace("/-$/","",preg_replace('/[^a-z0-9]+/i', "-", strtolower($name)));
	$status = 1;
	$response = array();
	if(!checkCompanyExist($slug)){
		try {

			$db = new db();
			$db = $db->connect();

			$db->query("SET  CHARACTER SET utf8;");

			$row_1 = [
				'name' 		=> 	$name,
				'slug'		=>	$slug,
				'status'	=>	$status
			];
			$sql_1 = "INSERT INTO rx_partner_companies SET name=:name,slug=:slug,status=:status";

			/** @var PDO $pdo */
			$success_1 		= 	$db->prepare($sql_1)->execute($row_1);
			$company_id 	= 	$db->lastInsertId();
			
			if($company_id){
				
				$permitted_chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
				$sub_chars	= substr(str_shuffle($permitted_chars), 0, 3);

				$license_id	=	sprintf('%08d', $company_id);
				$license_no	=	'RTY-'.$sub_chars.'-'.$license_id;

				
				$row = [
					'license_no' 	=> 	$license_no,
					'id'			=>	$company_id
				];
		
				$sql = "UPDATE rx_partner_companies SET license_no=:license_no WHERE id=:id ";
				/** @var PDO $pdo */
				$success 	= 	$db->prepare($sql)->execute($row);
				if($success){
					$response['status']		=	1;
					$response['message']	=	'New partner company has been successfully added with license number : '.$license_no;
				}
				else{
					$response['status']		=	0;
					$response['message']	=	'Partner company has been successfully added but failed to generate license number. Please contact support team.';
				}
			}
			else{
				$response['status']		=	0;
				$response['message']	=	'An error occured while adding partner company. Please contact support team.';
			}
		}
		catch (PDOException $e) {
			$response['status']		=	0;
			$response['message']	=	$e;
		}
	}
	else{
		$response['status']		=	0;
		$response['message']	=	'Company name already exist.';
	}
	return $this->response->withJson(array(
		'data' => $response
	));
});

$app->post('/admin/addPartner', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	
	$name		=	$inputControl['name'];
   	$company_id	=	$inputControl['company_id'];
	$license_no	=	$inputControl['license_no'];
	$email		=	$inputControl['email'];
	$phone		=	$inputControl['phone'];
	
	$status		=	1;
	$flag		=	'';
	$rx_response	=	array();
	
	if(!checkUserExist($email)){
		try {

			$db = new db();
			$db = $db->connect();

			$db->query("SET  CHARACTER SET utf8;");

			$permitted_chars = 'abcdefghijklmnopqrstuvwxyz';
			$sub_chars	= substr(str_shuffle($permitted_chars), 0, 10);
			
			$password = $sub_chars;
			
			
			$row_1 = [
				'username' 		=> 	$email,
				'password' 		=> 	md5($password),
				'role'			=>	'partner',
				'status'		=>	$status
			];
			$sql_1 = "INSERT INTO rx_users SET username=:username,password=:password,role=:role,status=:status";

			/** @var PDO $pdo */
			$success_1 	= 	$db->prepare($sql_1)->execute($row_1);
			$user_id 	= 	$db->lastInsertId();

			if($user_id){
				$status_2	=	2;
				$row = [
					'user_id' 		=> 	$user_id,
					'name' 			=> 	$name,
					'company_id' 	=> 	$company_id,
					'email'			=>	$email,
					'phone'         =>  $phone,
					'status'		=>	$status_2
				];

				$sql = "INSERT INTO rx_partners SET user_id=:user_id,first_name=:name,company_id=:company_id,email=:email,phone=:phone,status=:status";

				/** @var PDO $pdo */
				$success 		= 	$db->prepare($sql)->execute($row);
				$partner_id 	= 	$db->lastInsertId();

				if($partner_id){

					/*.............Active campign Start..................*/

					$url = 'https://rxtoyou.api-us1.com';
					$key='d23525f33c29a6eddfe6e38ef4bf1c0bd82fe710de0d40d96115afafe3923f0fc3175c54';

					$params = array(  
						'api_key'      => $key, 
						'api_action'   => 'contact_sync',
						'api_output'   => 'serialize',
					);

					// here we define the data we are posting in order to perform an update
					$post = array(
						'email'                    	=> $email,
						'first_name'               	=> $name,
						//'phone'						=> $phone,
						// 'form'          => $formid, // Subscription Form ID, to inherit those redirection settings
						'field[%COMPANY_NAME%,0]' 	=> 	$company_name,
						'field[%LICENSE_NUMBER%,0]' =>	$license_no,
						'field[%SITE_PASSWORD%,0]' 	=>	$password,

						'p[3]'                   => 3, // example list ID (REPLACE '123' WITH ACTUAL LIST ID, IE: p[5] = 5)
						'status[3]'              => 1, // 1: active, 2: unsubscribed (REPLACE '123' WITH ACTUAL LIST 
					);


					$query = "";

					foreach( $params as $key => $value ) $query .= urlencode($key) . '=' . urlencode($value) . '&';
					$query = rtrim($query, '& ');

					$data = "";

					foreach( $post as $key => $value ) $data .= urlencode($key) . '=' . urlencode($value) . '&';
					$data = rtrim($data, '& ');



					// clean up the url
					$url = rtrim($url, '/ ');


					if ( !function_exists('curl_init') ) die('CURL not supported. (introduced in PHP 4.0.2)');


					if ( $params['api_output'] == 'json' && !function_exists('json_decode') ) {
						die('JSON not supported. (introduced in PHP 5.2.0)');
					}

					$api = $url . '/admin/api.php?' . $query;


					$request = curl_init($api); // initiate curl object

					curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response

					curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)

					curl_setopt($request, CURLOPT_POSTFIELDS, $data); // use HTTP POST to send form data

					//curl_setopt($request, CURLOPT_SSL_VERIFYPEER, FALSE); // uncomment if you get no gateway response and are using HTTPS

					curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);



					$response = (string)curl_exec($request); // execute curl post and store results in $response



					// additional options may be required depending upon your server configuration

					// you can find documentation on curl options at http://www.php.net/curl_setopt

					curl_close($request); // close curl object



					if ( !$response ) {

						die('Nothing was returned. Do you have a connection to Email Marketing server?');

					}



					// This line takes the response and breaks it into an array using:

					// JSON decoder

					//$result = json_decode($response);

					// unserializer

					$result = unserialize($response);


				   /*.............Active campign end..................*/

					$rx_response['status']	=	1;
					$rx_response['msg']	=	'New partner user has been successfully added.';

				}
				else{
					$rx_response['status']	=	0;
					$rx_response['msg']	=	'An error occured. Try again later.';
				}
			}
			else{
				$rx_response['status']	=	0;
				$rx_response['msg']	=	'An error occured. Try again later.';
			}

		} catch (PDOException $e) {
			$rx_response['status']	=	0;
			$rx_response['msg']	=	$e;
		}
	}
	else{
		$rx_response['status']	=	0;
		$rx_response['msg']	=	'Email already exist.';
	}
	return $this->response->withJson(array(
		'data' 	=> 	$rx_response
	));
});


$app->post('/admin/getAllPartnerCompanies', function(Request $request, Response $response) {
	$status = 3;
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson('Invalid Request');
	}
	
	$response = array();
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT id,
		name,
		slug,
		license_no,
		status
		from rx_partner_companies
		WHERE status!=:status ORDER BY id DESC ');
		$stmt->bindParam('status', $status);
		$stmt->execute();
		$partners = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($partners) > 0){
			$response['status']		=	1;
			$response['message']	=	'Success.';
			$response['result']		=	$partners;
			
		}
		else{
			$response['status']		=	0;
			$response['message']	=	'No partner companies found.';
		}
		
    } catch (PDOException $e) {
		$response['status'] = 0;
		$response['message'] = $e;
    }
	
	return $this->response->withJson(array(
		'data'	=>	$response
	));
});


$app->post('/admin/getActivePartnerCompanies', function(Request $request, Response $response) {
	$status = 1;
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson('Invalid Request');
	}
	
	$response = array();
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		$stmt = $db->prepare('SELECT id,
		name,
		slug,
		license_no,
		status
		from rx_partner_companies
		WHERE status=:status ORDER BY id DESC ');
		$stmt->bindParam('status', $status);
		$stmt->execute();
		$partners = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($partners) > 0){
			$response['status']		=	1;
			$response['message']	=	'Success.';
			$response['result']		=	$partners;
		}
		else{
			$response['status']		=	0;
			$response['message']	=	'No partner companies found.';
		}
		
    } catch (PDOException $e) {
		$response['status'] = 0;
		$response['message'] = $e;
    }
	
	return $this->response->withJson(array(
		'data'	=>	$response
	));
});


$app->post('/admin/getPartnerCompanyDetails', function(Request $request, Response $response) {
	
	$inputControl	= 	$request->getParsedBody();
	$slug		=	$inputControl['slug'];
	$response 	= array();
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson('Invalid Request');
	}
	
	$status		=	1;
	$status_2	=	2;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT id as company_id,
		name,
		license_no
		FROM rx_partner_companies 
		WHERE id = (SELECT id from rx_partner_companies WHERE slug=:slug)');
		$stmt->bindParam('slug', $slug);
		$stmt->execute();
		$details = $stmt->fetchAll(PDO::FETCH_OBJ);
		$db = null;
		 
		if(count($details) > 0){
			$response['status']		=	1;
			$response['result']	=	$details;
			$response['msg']		=	'Success.';
		}
		else{
			$response['status']		=	0;
			$response['msg']		=	'No company details found.';
		}
		
    } catch (PDOException $e) {
		$response['status'] = 	0;
		$response['msg']	=	$e;
    }
	
	return $this->response->withJson(array(
		'data' => $response
	));
});


$app->post('/admin/updatePartnerCompany', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$id				=	$inputControl['id'];
	$action			=	$inputControl['status'];
	$status		=	1;
	$message	='';
	switch($action){
		case 2 	: 	$status = 2;
							$message	=	'Partner company have successfully suspended.';
							break;
		case 1	:	$status	=	1;
							$message	=	'Partner company have successfully activated.';
							break;
		default			:	$status		=	1;
	}
	
	$response = array();
	
    try {
		$db = new db();
		$db = $db->connect();
		$db->query("SET  CHARACTER SET utf8;");
		
		$row = [
			'status'		=>	$status,
			'id'			=>	$id
		];
		$sql = "UPDATE rx_partner_companies SET status=:status WHERE id=:id ";
		/** @var PDO $pdo */
		$success 	= 	$db->prepare($sql)->execute($row);
		
		$db	=	null;	
	
		if($success){
			$response['status'] = 1;
			$response['msg'] = $message;
				
		}
		else{
			$response['status'] = 0;
			$response['msg']	=	'An error occured. Try again later.' ;
		}
		
    } catch (PDOException $e) {
		$response['status'] = 0;
		$response['msg']	=	$e ;
    }
	return $this->response->withJson(array(
		'data' 	=> 	$response
	));
});


$app->post('/admin/getPartners', function(Request $request, Response $response) {
	
	$inputControl	= 	$request->getParsedBody();
	$role		=	$inputControl['role'];
	$slug		=	$inputControl['slug'];
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson('Invalid Request');
	}
	
	if($role != 'admin'){
		$result['msg']	=	'You have no permission to view this details.';
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$result
		));
	}
	
	
	$status		=	1;
	$status_2	=	2;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT user_id,
		first_name,
		rx_pc.name as company_name,
		rx_pc.slug,
		rx_partners.email,
		rx_partners.phone,
		rx_pc.license_no,
		rx_users.status from rx_partners 
		LEFT JOIN rx_users ON (rx_partners.user_id=rx_users.id)
		LEFT JOIN rx_partner_companies rx_pc ON (rx_partners.company_id=rx_pc.id)
		WHERE (rx_users.status=:status or rx_users.status=:status2) AND rx_partners.company_id = (SELECT id from rx_partner_companies WHERE slug=:slug) ORDER BY rx_users.id DESC ');
		$stmt->bindParam('status', $status);
		$stmt->bindParam('status2', $status_2);
		$stmt->bindParam('slug', $slug);
		$stmt->execute();
		$partners = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($partners) > 0){
			$flag	=	'success';
			$result['details']	=	$partners;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No partners found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});



$app->get('/admin/getActivePartners', function(Request $request, Response $response) {

	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson('Invalid Request');
	}
	
	$status		=	1;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT user_id,
		first_name,
		company_name,
		rx_partners.email,
		license_no,
		rx_users.status from rx_partners 
		LEFT JOIN rx_users ON (rx_partners.user_id=rx_users.id) WHERE rx_users.status=:status ORDER BY rx_users.id DESC ');
		$stmt->bindParam('status', $status);
		$stmt->execute();
		$partners = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($partners) > 0){
			$flag	=	'success';
			$result['details']	=	$partners;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No partners found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


$app->post('/admin/getPartnerDetails', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$user_id			=	$inputControl['user_id'];
	$status		=	1;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT rx_partners.user_id,
		first_name,
		company_name,
		rx_partners.email,
		license_no from rx_partners 
		LEFT JOIN rx_users ON (rx_partners.user_id=rx_users.id) WHERE rx_users.status=:status AND rx_partners.user_id=:id ');
		$stmt->bindParam('status', $status);
		$stmt->bindParam('id', $user_id);
		$stmt->execute();
		$partners = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($partners) > 0){
			$flag	=	'success';
			$result['details']	=	$partners;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No partners found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});

$app->post('/admin/updatePartnerDetails', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$id				=	$inputControl['user_id'];
	$name			=	$inputControl['name'];
	$email			=	$inputControl['email'];
	$phone			=	$inputControl['phone'];
	$company_name		=	$inputControl['company_name'];
	$license_no			=	$inputControl['license_no'];
	
	
	$status		=	1;
	$res = array();
	$success1 = $success2 = $success3 ='';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		
		$stmt = $db->prepare('SELECT * from rx_users WHERE username=:username');
		$stmt->bindParam('username',$email);
		$stmt->execute();
		$users = $stmt->fetch(PDO::FETCH_OBJ);
		
		if(isset($users) && !empty($users)){
			if($id == $users->id){
				$row1 = [
					'name' 	=> 	$name,
					'phone' =>  $phone,
					'id'	=>	$id
				];
				$sql1 = "UPDATE rx_partners SET first_name=:name,phone=:phone WHERE user_id=:id ";
				$success1 	= 	$db->prepare($sql1)->execute($row1);
			}
			else{
				$res['status']	=	0;
				$res['msg']	=	'New email already exist.' ;
				return $this->response->withJson(array(
					'data' 	=> 	$res
				));
			}
		}
		else{
			$permitted_chars = 'abcdefghijklmnopqrstuvwxyz';
			$sub_chars	= substr(str_shuffle($permitted_chars), 0, 10);
			$password = $sub_chars;
			
			
			//get current user email
			$email_query = $db->prepare('SELECT username from rx_users WHERE id=:id');
			$email_query->bindParam('id',$id);
			$email_query->execute();
			$email_array = $email_query->fetch(PDO::FETCH_OBJ);
			$current_email = $email_array->username;
			
			$row2 = [
				'username' => 	$email,
				'password' => md5($password),
				'id'	=>	$id
			];
			$sql2 = "UPDATE rx_users SET username=:username,password=:password WHERE id=:id ";
			$success2 	= 	$db->prepare($sql2)->execute($row2);
			
			$status_2 = 2;
			$row3 = [
				'name' 	=> 	$name,
				'id'	=>	$id,
				'email' => 	$email,
				'phone' =>  $phone,
				'status' => $status_2
			];
			$sql3 = "UPDATE rx_partners SET first_name=:name,email=:email,phone=:phone,status=:status WHERE user_id=:id ";
			$success3 	= 	$db->prepare($sql3)->execute($row3);
			
			updatePartnerContactAC($current_email,'','','','',2);
			updatePartnerContactAC($email,$password,$name,$company_name,$license_no,1);
		}
		
		 
		if($success1 || ($success2 && $success3)){
			$res['status']	=	1;
			$res['msg']	=	'Partner User has been successfully updated.';
		}
		else{
			$res['status']	=	0;
			$res['msg']	=	'An error occured. Try again later.' ;
		}
		
    } catch (PDOException $e) {
		$res['status']	=	0;
		$res['msg']	=	$e;
    }
	return $this->response->withJson(array(
		'data' 	=> 	$res
	));
});

$app->post('/admin/updatePartner', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$id				=	$inputControl['user_id'];
	$action			=	$inputControl['action'];
	$status		=	1;
	$message	='';
	switch($action){
		case 2 	: 	$status = 2;
							$message	=	'Partner have successfully suspended.';
							break;
		case 1	:	$status	=	1;
							$message	=	'Partner have successfully activated.';
							break;
		default			:	$status		=	1;
	}
	
	$flag		=	'';
    try {
		$db = new db();
		$db = $db->connect();
		$db->query("SET  CHARACTER SET utf8;");
		

		$row = [
			'status'		=>	$status,
			'id'			=>	$id
		];
		$sql = "UPDATE rx_users SET status=:status WHERE id=:id ";
		/** @var PDO $pdo */
		$success 	= 	$db->prepare($sql)->execute($row);
		
		
		
		$email_query = $db->prepare('SELECT username from rx_users WHERE id=:id');
		$email_query->bindParam('id',$id);
		$email_query->execute();
		$email_array = $email_query->fetch(PDO::FETCH_OBJ);
		
		
		$db	=	null;	
	
		if($success){
			$flag	=	'success';
			$result['msg']	=	$message;

			/*.............Active campign Start..................*/

			$url = 'https://rxtoyou.api-us1.com';
			$key='d23525f33c29a6eddfe6e38ef4bf1c0bd82fe710de0d40d96115afafe3923f0fc3175c54';

			$params = array(  
				'api_key'      => $key, 
				'api_action'   => 'contact_sync',
				'api_output'   => 'serialize',
			);

			// here we define the data we are posting in order to perform an update
			$post = array(
				'email'                    => $email_array->username,

				'p[3]'                   => 3, // example list ID (REPLACE '123' WITH ACTUAL LIST ID, IE: p[5] = 5)
				'status[3]'              => $action, // 1: active, 2: unsubscribed (REPLACE '123' WITH ACTUAL LIST 
			);


			$query = "";

			foreach( $params as $key => $value ) $query .= urlencode($key) . '=' . urlencode($value) . '&';
			$query = rtrim($query, '& ');

			$data = "";

			foreach( $post as $key => $value ) $data .= urlencode($key) . '=' . urlencode($value) . '&';
			$data = rtrim($data, '& ');



			// clean up the url
			$url = rtrim($url, '/ ');


			if ( !function_exists('curl_init') ) die('CURL not supported. (introduced in PHP 4.0.2)');


			if ( $params['api_output'] == 'json' && !function_exists('json_decode') ) {
				die('JSON not supported. (introduced in PHP 5.2.0)');
			}

			$api = $url . '/admin/api.php?' . $query;


			$request = curl_init($api); // initiate curl object

			curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response

			curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)

			curl_setopt($request, CURLOPT_POSTFIELDS, $data); // use HTTP POST to send form data

			//curl_setopt($request, CURLOPT_SSL_VERIFYPEER, FALSE); // uncomment if you get no gateway response and are using HTTPS

			curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);



			$response = (string)curl_exec($request); // execute curl post and store results in $response



			// additional options may be required depending upon your server configuration

			// you can find documentation on curl options at http://www.php.net/curl_setopt

			curl_close($request); // close curl object



			if ( !$response ) {

				die('Nothing was returned. Do you have a connection to Email Marketing server?');

			}



			// This line takes the response and breaks it into an array using:

			// JSON decoder

			//$result = json_decode($response);

			// unserializer

			$result = unserialize($response);


		   /*.............Active campign end..................*/
				
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'An error occured. Try again later.' ;
		}
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
}); 

$app->post('/admin/reassignPartnerforPlan', function(Request $request, Response $response) {
	$inputControl 	= 	$request->getParsedBody();
	$company_id		=	$inputControl['company_id'];
	$id				=	$inputControl['group_id'];
	$status			=	1;
	
	try {
		$db = new db();
		$db = $db->connect();
		$db->query("SET  CHARACTER SET utf8;");
		$row = [
			'company_id'	=>	$company_id,
			'id'			=>	$id,
			'status'		=>	$status	
		];
		$sql = "UPDATE rx_groups SET company_id=:company_id,status=:status WHERE id=:id ";
		/** @var PDO $pdo */
		$success 	= 	$db->prepare($sql)->execute($row);
		$db	=	null;	
	
		if($success){
			$flag	=	'success';
			$result['msg']	=	'Partner successfully re-assigned.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'An error occured. Try again later.' ;
		}
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


$app->post('/admin/reassignPlanforPatient', function(Request $request, Response $response) {
	$inputControl 	= 	$request->getParsedBody();
	$plan_id		=	$inputControl['plan_id'];
	$patient_id		=	$inputControl['patient_id'];
	$status			=	1;
	
	try {
		$db = new db();
		$db = $db->connect();
		$db->query("SET  CHARACTER SET utf8;");
		$row = [
			'user_id'		=>	$patient_id,
			'group_id'		=>	$plan_id,
			'status'		=>	$status	
		];
		$sql = "UPDATE rx_patients SET group_id=:group_id,status=:status WHERE user_id=:user_id ";
		/** @var PDO $pdo */
		$success 	= 	$db->prepare($sql)->execute($row);
		$db	=	null;	
	
		if($success){
			$flag	=	'success';
			$result['msg']	=	'Plan successfully re-assigned for the patient.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'An error occured. Try again later.' ;
		}
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});



//from admin
$app->post('/admin/listPartnerGroupPatients', function(Request $request, Response $response) {

	$inputControl 	= 	$request->getParsedBody();
	$group_id		=	$inputControl['group_id'];
	$status			=	0;

	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT rx_patients.user_id,
		rx_patients.first_name,
		rx_groups.name,
		rx_groups.company_id,
		rx_groups.status as plan_status,
		rx_users.username,
		rx_partner_companies.name as partner,
		rx_users.status 
		FROM rx_patients 
		LEFT JOIN rx_users ON (rx_patients.user_id=rx_users.id) 
		LEFT JOIN rx_groups ON (rx_patients.group_id=rx_groups.id) 
		LEFT JOIN rx_partner_companies ON (rx_groups.company_id=rx_partner_companies.id) 
		WHERE rx_groups.id=:group_id AND (rx_users.status!=:status)ORDER BY rx_patients.id DESC');
		$stmt->bindParam('group_id', $group_id);
		$stmt->bindParam('status', $status);
		$stmt->execute();
		$orders = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($orders) > 0){
			$flag	=	'success';
			$result['details']	=	$orders;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No Patients found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


//update patient status (suspend/activate)
$app->post('/admin/updatePatient', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$id				=	$inputControl['patient_user_id'];
	$action			=	$inputControl['action'];
	$status		=	1;
	$message	='';
	switch($action){
		case 2 	: 	$status = 2;
							$message	=	'Partient have successfully suspended.';
							break;
		case 1	:	$status	=	1;
							$message	=	'Patient have successfully activated.';
							break;
		default			:	$status		=	1;
	}
	
	$flag		=	'';
    try {
		$db = new db();
		$db = $db->connect();
		$db->query("SET  CHARACTER SET utf8;");
		

		$row = [
			'status'		=>	$status,
			'id'			=>	$id
		];
		$sql = "UPDATE rx_users SET status=:status WHERE id=:id ";
		/** @var PDO $pdo */
		$success 	= 	$db->prepare($sql)->execute($row);
		
		
		
		$email_query = $db->prepare('SELECT username from rx_users WHERE id=:id');
		$email_query->bindParam('id',$id);
		$email_query->execute();
		$email_array = $email_query->fetch(PDO::FETCH_OBJ);
		
		
		$db	=	null;	
	
		if($success){
			$flag	=	'success';
			$result['msg']	=	$message;
				
			/*.............Active campign Start..................*/

			$url = 'https://rxtoyou.api-us1.com';
			$key='d23525f33c29a6eddfe6e38ef4bf1c0bd82fe710de0d40d96115afafe3923f0fc3175c54';

			$params = array(  
				'api_key'      => $key, 
				'api_action'   => 'contact_sync',
				'api_output'   => 'serialize',
			);

			// here we define the data we are posting in order to perform an update
			$post = array(
				'email'                    => $email_array->username,

				'p[3]'                   => 4, // example list ID (REPLACE '123' WITH ACTUAL LIST ID, IE: p[5] = 5)
				'status[3]'              => $action, // 1: active, 2: unsubscribed (REPLACE '123' WITH ACTUAL LIST 
			);


			$query = "";

			foreach( $params as $key => $value ) $query .= urlencode($key) . '=' . urlencode($value) . '&';
			$query = rtrim($query, '& ');

			$data = "";

			foreach( $post as $key => $value ) $data .= urlencode($key) . '=' . urlencode($value) . '&';
			$data = rtrim($data, '& ');



			// clean up the url
			$url = rtrim($url, '/ ');


			if ( !function_exists('curl_init') ) die('CURL not supported. (introduced in PHP 4.0.2)');


			if ( $params['api_output'] == 'json' && !function_exists('json_decode') ) {
				die('JSON not supported. (introduced in PHP 5.2.0)');
			}

			$api = $url . '/admin/api.php?' . $query;


			$request = curl_init($api); // initiate curl object

			curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response

			curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)

			curl_setopt($request, CURLOPT_POSTFIELDS, $data); // use HTTP POST to send form data

			//curl_setopt($request, CURLOPT_SSL_VERIFYPEER, FALSE); // uncomment if you get no gateway response and are using HTTPS

			curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);



			$response = (string)curl_exec($request); // execute curl post and store results in $response



			// additional options may be required depending upon your server configuration

			// you can find documentation on curl options at http://www.php.net/curl_setopt

			curl_close($request); // close curl object



			if ( !$response ) {

				die('Nothing was returned. Do you have a connection to Email Marketing server?');

			}



			// This line takes the response and breaks it into an array using:

			// JSON decoder

			//$result = json_decode($response);

			// unserializer

			$result = unserialize($response);


		   /*.............Active campign end..................*/
			
			
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'An error occured. Try again later.' ;
		}
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
}); 


function checkUserExist($email){
	$status	= 3;
   	try {
		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT * from rx_users WHERE username=:username AND status!=:status');
		$stmt->bindParam('username',$email);
	   	$stmt->bindParam('status',$status);
		$stmt->execute();
		$users = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($users) > 0){
			return true;
		}
		else{
			return false;
		}	
		
    } catch (PDOException $e) {
        return true;
    }
}

function checkCompanyExist($slug){
	$status	= 3;
   	try {
		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT slug from rx_partner_companies WHERE slug=:slug');
		$stmt->bindParam('slug',$slug);
		$stmt->execute();
		$companies = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($companies) > 0){
			return true;
		}
		else{
			return false;
		}	
		
    } catch (PDOException $e) {
        return true;
    }
}


function updatePartnerContactAC($email,$password,$name,$company_name,$license_no,$status){
	/*.............Active campign Start..................*/
	$url = 'https://rxtoyou.api-us1.com';
	$key='d23525f33c29a6eddfe6e38ef4bf1c0bd82fe710de0d40d96115afafe3923f0fc3175c54';

	$params = array(  
		'api_key'      => $key, 
		'api_action'   => 'contact_sync',
		'api_output'   => 'serialize',
	);

	// here we define the data we are posting in order to perform an update
	$post = array(
		'email'                    	=> $email,
		'first_name'               	=> $name,
		//'phone'						=> $phone,
		// 'form'          => $formid, // Subscription Form ID, to inherit those redirection settings
		'field[%COMPANY_NAME%,0]' 	=> 	$company_name,
		'field[%LICENSE_NUMBER%,0]' =>	$license_no,
		'field[%SITE_PASSWORD%,0]' 	=>	$password,

		'p[3]'                   => 3, // example list ID (REPLACE '123' WITH ACTUAL LIST ID, IE: p[5] = 5)
		'status[3]'              => $status, // 1: active, 2: unsubscribed (REPLACE '123' WITH ACTUAL LIST 
	);


	$query = "";

	foreach( $params as $key => $value ) $query .= urlencode($key) . '=' . urlencode($value) . '&';
	$query = rtrim($query, '& ');

	$data = "";

	foreach( $post as $key => $value ) $data .= urlencode($key) . '=' . urlencode($value) . '&';
	$data = rtrim($data, '& ');



	// clean up the url
	$url = rtrim($url, '/ ');


	if ( !function_exists('curl_init') ) die('CURL not supported. (introduced in PHP 4.0.2)');


	if ( $params['api_output'] == 'json' && !function_exists('json_decode') ) {
		die('JSON not supported. (introduced in PHP 5.2.0)');
	}

	$api = $url . '/admin/api.php?' . $query;


	$request = curl_init($api); // initiate curl object

	curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response

	curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)

	curl_setopt($request, CURLOPT_POSTFIELDS, $data); // use HTTP POST to send form data

	//curl_setopt($request, CURLOPT_SSL_VERIFYPEER, FALSE); // uncomment if you get no gateway response and are using HTTPS

	curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);



	$response = (string)curl_exec($request); // execute curl post and store results in $response



	// additional options may be required depending upon your server configuration

	// you can find documentation on curl options at http://www.php.net/curl_setopt

	curl_close($request); // close curl object



	if ( !$response ) {

		die('Nothing was returned. Do you have a connection to Email Marketing server?');

	}



	// This line takes the response and breaks it into an array using:

	// JSON decoder

	//$result = json_decode($response);

	// unserializer

	$result = unserialize($response);

   /*.............Active campign end..................*/
}

?>