<?php

use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use \Firebase\JWT\JWT;


$app->post('/admin/changePassword', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	
	$username	=	$inputControl['username'];
	
   	$password	=	$inputControl['password'];
	$npassword	=	$inputControl['npassword'];
	
	$status		=	1;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT * from rx_users WHERE username=:username AND status=:status');
		$stmt->bindParam('username',$username);
		$stmt->bindParam('status', $status);
		$stmt->execute();
		$users = $stmt->fetchAll(PDO::FETCH_OBJ);
		 
		if(count($users) > 0){
			if($users[0]->password != md5($password)){
				$flag	=	'error';
				$result['msg']	=	'Current password is incorrect';
			}
			else{
				if($password == $npassword){
					$flag	=	'error';
					$result['msg']	=	'Old Password and New Password cannot be same';
				}
				else{
					$newpassword	=	md5($npassword);
					$query = "UPDATE rx_users SET password=:password WHERE id=:id";
					$stmt = $db->prepare($query);
					$stmt->bindParam("password", $newpassword);
					$stmt->bindParam("id", $users[0]->id);
					$stmt->execute();

					$db = null;

					$flag	=	'success';
					$result['msg']	=	'Your password successfully changed. You need to login again.';
				}
			}
		}
		else{
			$flag	=	'login';
			$result['msg']	=	'Error! You need to login first.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
        return $this->response->withJson($e);
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


$app->post('/admin/getAdminPatients', function(Request $request, Response $response) {
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson(array(
			'status' 	=>  'error',
			'message'	=>	'Invalid Request'
		));
	}
	
	$inputControl 	= 	$request->getParsedBody();
	$user_id		=	$inputControl['user_id'];
	$company_id = 0;
	$status			=	0;

	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT rx_patients.user_id,
		rx_patients.first_name,
		rx_groups.name,
		rx_groups.status as plan_status,
		rx_users.username,
		rx_users.status 
		FROM rx_patients 
		LEFT JOIN rx_users ON (rx_patients.user_id=rx_users.id) 
		LEFT JOIN rx_groups ON (rx_patients.group_id=rx_groups.id) 
		WHERE rx_groups.company_id=:company_id AND (rx_users.status!=:status)ORDER BY rx_patients.id DESC');
		$stmt->bindParam('company_id', $company_id);
		$stmt->bindParam('status', $status);
		$stmt->execute();
		$orders = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($orders) > 0){
			$flag	=	'success';
			$result['details']	=	$orders;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No Patients found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
	
});


//get all existing patients (authenticate)
$app->post('/admin/listAllPatients', function(Request $request, Response $response) {
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson(array(
			'status' 	=>  'error',
			'message'	=>	'Invalid Request'
		));
	}
	
	$inputControl 	= 	$request->getParsedBody();
	$status			=	0;

	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT rx_patients.user_id,
		rx_patients.first_name,
		rx_groups.name,
		rx_groups.company_id,
		rx_groups.status as plan_status,
		rx_users.username,
		rx_users.status,
		rxpc.name as partner
		FROM rx_patients 
		LEFT JOIN rx_users ON (rx_patients.user_id=rx_users.id) 
		LEFT JOIN rx_groups ON (rx_patients.group_id=rx_groups.id) 
		LEFT JOIN rx_partner_companies rxpc ON (rxpc.id=rx_groups.company_id) 
		WHERE rx_users.status!=:status ORDER BY rx_patients.id DESC');
		$stmt->bindParam('status', $status);
		$stmt->execute();
		$patients = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($patients) > 0){
			$flag	=	'success';
			$result['details']	=	$patients;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No Patients found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
	
});

//get all existing plans (authenticate)
$app->post('/admin/getAllPlans', function(Request $request, Response $response) {
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson(array(
			'status' 	=>  'error',
			'message'	=>	'Invalid Request'
		));
	}
	$inputControl	= 	$request->getParsedBody();
	
	$status1		=	1;
	$status2		=	2;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT rxgp.id,
		rxgp.name as name,
		rxpc.name as partner_name,
		rxpc.status as partner_status,
		rxgp.company_id,
		rxgp.status
		from rx_groups rxgp LEFT JOIN rx_partner_companies rxpc ON rxgp.company_id=rxpc.id
		WHERE rxgp.status=:status1 OR rxgp.status=:status2');
		$stmt->bindParam('status1', $status1);
		$stmt->bindParam('status2', $status2);
		$stmt->execute();
		$plans = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($plans) > 0){
			$flag	=	'success';
			$result['details']	=	$plans;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No plans found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});



//get admin groups (not under any company)
$app->post('/admin/getAdminGroups', function(Request $request, Response $response) {
	
	$inputControl	= 	$request->getParsedBody();
	$company_id		=	0;
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson('Invalid Request');
	}
	
	$status			=	1;
	$status_2		=	2;
	$flag		=	'';
	try {

		$db = new db();
		$db = $db->connect();

		$db->query("SET  CHARACTER SET utf8;");

		$stmt = $db->prepare('SELECT rx_groups.id,
		rx_groups.name,
		rx_groups.group_address,
		rx_groups.recipient_name,
		rx_groups.recipient_email,
		rx_groups.third_admin_email,
		rx_groups.status
		FROM rx_groups 
		LEFT JOIN rx_users ON (rx_groups.user_id = rx_users.id)
		WHERE rx_groups.company_id=:company_id AND (rx_groups.status=:status OR rx_groups.status=:status_2) ORDER BY rx_groups.id DESC ');
		$stmt->bindParam('company_id', $company_id);
		$stmt->bindParam('status', $status);
		$stmt->bindParam('status_2', $status_2);
		$stmt->execute();
		$groups = $stmt->fetchAll(PDO::FETCH_OBJ); 

		$db = null; 

		if(count($groups) > 0){
			$flag	=	'success';
			$result['details']	=	$groups;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No groups found.';
		}

		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));


	} catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
	}
}); 

//get active admin groups (not under any company)
$app->post('/admin/getActiveAdminGroups', function(Request $request, Response $response) {
	
	$inputControl	= 	$request->getParsedBody();
	$company_id		=	0;
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson('Invalid Request');
	}
	
	$status			=	1;
	$flag		=	'';
	try {

		$db = new db();
		$db = $db->connect();

		$db->query("SET  CHARACTER SET utf8;");

		$stmt = $db->prepare('SELECT rx_groups.id,
		rx_groups.name,
		rx_groups.group_address,
		rx_groups.recipient_name,
		rx_groups.recipient_email,
		rx_groups.third_admin_email,
		rx_groups.status
		FROM rx_groups 
		LEFT JOIN rx_users ON (rx_groups.user_id = rx_users.id)
		WHERE rx_groups.company_id=:company_id AND rx_groups.status=:status ORDER BY rx_groups.id DESC ');
		$stmt->bindParam('company_id', $company_id);
		$stmt->bindParam('status', $status);
		$stmt->execute();
		$groups = $stmt->fetchAll(PDO::FETCH_OBJ); 

		$db = null; 

		if(count($groups) > 0){
			$flag	=	'success';
			$result['details']	=	$groups;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No groups found.';
		}

		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));


	} catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
	}
});


//get active admin groups (not under any company)
$app->post('/admin/getAllActivePlans', function(Request $request, Response $response) {
	
	$inputControl	= 	$request->getParsedBody();
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson('Invalid Request');
	}
	
	$status			=	1;
	$flag		=	'';
	try {

		$db = new db();
		$db = $db->connect();

		$db->query("SET  CHARACTER SET utf8;");

		$stmt = $db->prepare('SELECT rx_groups.id,
		rx_groups.company_id,
		rx_groups.name,
		rxpc.name as company,
		rx_groups.group_address,
		rx_groups.recipient_name,
		rx_groups.recipient_email,
		rx_groups.third_admin_email,
		rx_groups.status
		FROM rx_groups 
		LEFT JOIN rx_users ON (rx_groups.user_id = rx_users.id)
		LEFT JOIN rx_partner_companies rxpc ON (rx_groups.company_id = rxpc.id)
		WHERE rx_groups.status=:status ORDER BY rx_groups.id DESC ');
		$stmt->bindParam('status', $status);
		$stmt->execute();
		$groups = $stmt->fetchAll(PDO::FETCH_OBJ); 

		$db = null; 

		if(count($groups) > 0){
			$flag	=	'success';
			$result['details']	=	$groups;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No groups found.';
		}

		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));


	} catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
	}
});

//adding groups under partners and admin
$app->post('/admin/addGroup', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$company_slug = $inputControl['company_slug'];
	
	//get company_id by company_slug
	$company_id	=	getCompnayIdBySlug($company_slug);
	
	
	$name			=	$inputControl['name'];
	$group_address	=	$inputControl['group_address'];
	$group_city		=	$inputControl['group_city'];
	$group_state	=	$inputControl['group_state'];
	$group_zip		=	$inputControl['group_zip'];
	$client_phone	=	$inputControl['client_phone'];
	$no_of_emp		=	$inputControl['no_of_emp'];
	$benefits_manager	=	$inputControl['benefits_manager'];
	$manager_email	=	$inputControl['manager_email'];
	$manager_phone	=	$inputControl['manager_phone'];
	$recipient_name	=	$inputControl['recipient_name'];
	$recipient_email	=	$inputControl['recipient_email'];
	$recipient_phone	=	$inputControl['recipient_phone'];
	$eligible_confirm	=	$inputControl['eligible_confirm'];
	$confirm_email	=	$inputControl['confirm_email'];
	$confirm_phone	=	$inputControl['confirm_phone'];
	$third_admin_name	=	$inputControl['third_admin_name'];
	$third_admin_email	=	$inputControl['third_admin_email'];
	$third_admin_phone	=	$inputControl['third_admin_phone'];
	$status		=	1;
	$flag		=	'';

	try {

		$db = new db();
		$db = $db->connect();

		$db->query("SET  CHARACTER SET utf8;");

		$row_1 = [
			'name' 		=> 	$name,
			'company_id' 	=> 	$company_id,
			'group_address'	=>	$group_address,
			'group_city'	=>	$group_city,
			'group_state'	=>	$group_state,
			'group_zip'		=>	$group_zip,
			'client_phone'	=>	$client_phone,
			'no_of_emp'		=>	$no_of_emp,
			'benefits_manager'	=>	$benefits_manager,
			'manager_email'	=>	$manager_email,
			'manager_phone'	=>	$manager_phone,
			'recipient_name'	=>	$recipient_name,
			'recipient_email'	=>	$recipient_email,
			'recipient_phone'	=>	$recipient_phone,
			'eligible_confirm'	=>	$eligible_confirm,
			'confirm_email'	=>	$confirm_email,
			'confirm_phone'	=>	$confirm_phone,
			'third_admin_name'	=>	$third_admin_name,
			'third_admin_email'	=>	$third_admin_email,
			'third_admin_phone'	=>	$third_admin_phone,
			'status'	=>	$status
		];
		$sql_1 = "INSERT INTO rx_groups SET name=:name,company_id=:company_id,group_address=:group_address,group_city=:group_city,group_state=:group_state,group_zip=:group_zip,client_phone=:client_phone,no_of_emp=:no_of_emp,benefits_manager=:benefits_manager,manager_email=:manager_email,manager_phone=:manager_phone,recipient_name=:recipient_name,recipient_email=:recipient_email,recipient_phone=:recipient_phone,eligible_confirm=:eligible_confirm,confirm_email=:confirm_email,confirm_phone=:confirm_phone,third_admin_name=:third_admin_name,third_admin_email=:third_admin_email,third_admin_phone=:third_admin_phone,status=:status";

		/** @var PDO $pdo */
		$success_1 	= 	$db->prepare($sql_1)->execute($row_1);
		$group_id 	= 	$db->lastInsertId();

		if($group_id){
			$flag	=	'success';
			$result['msg']	=	'Plan has been successfully added.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'An error occured. Try again later.' ;
		}

		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));


	} catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
	}

	
});


$app->post('/admin/updateGroup', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$id				=	$inputControl['group_id'];
	$action			=	$inputControl['action'];
	$status		=	1;
	$message	='';
	switch($action){
		case 2 	: 	$status = 2;
							$message	=	'Plan have successfully suspended.';
							break;
		case 1	:	$status	=	1;
							$message	=	'Plan have successfully activated.';
							break;
		case 3	:	$status	=	3;
							$message	=	'Plan have successfully removed.';
							break;
		default			:	$status		=	1;
	}
	
	$flag		=	'';
	$success	=	false;
    try {
		$db = new db();
		$db = $db->connect();
		$db->query("SET  CHARACTER SET utf8;");
		
		if($action == 1 || $action ==2 || $action == 3){
			$row = [
				'status'		=>	$status,
				'id'			=>	$id
			];
			$sql = "UPDATE rx_groups SET status=:status WHERE id=:id ";
			/** @var PDO $pdo */
			$success 	= 	$db->prepare($sql)->execute($row);
		}
//		else if($action == 3){
//			$stmt = $db->prepare('DELETE from rx_groups 
//			WHERE id=:id');
//			$stmt->bindParam('id', $id);
//			$stmt->execute();
//			if( $stmt->rowCount() > 0){
//				$success = true;
//			}
//		}
		$db	=	null;	
	
		if($success){
			$flag	=	'success';
			$result['msg']	=	$message;
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'An error occured. Try again later.' ;
		}
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


$app->post('/admin/getGroupDetails', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$group_id	=	$inputControl['group_id'];
	$status		=	1;
	$status2		=	2;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT id,name,group_address,group_city,group_state,group_zip,client_phone,no_of_emp,benefits_manager,manager_email,manager_phone,recipient_name,recipient_email,recipient_phone,eligible_confirm,confirm_email,confirm_phone,third_admin_name,third_admin_email,third_admin_phone from rx_groups WHERE (status=:status OR status=:status2) AND id=:id ');
		$stmt->bindParam('status', $status);
		$stmt->bindParam('status2', $status2);
		$stmt->bindParam('id', $group_id);
		$stmt->execute();
		$groups = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($groups) > 0){
			$flag	=	'success';
			$result['details']	=	$groups;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No groups/plans found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


$app->post('/admin/updateGroupDetails', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$id				=	$inputControl['id'];
	$name			=	$inputControl['name'];
	$group_address	=	$inputControl['group_address'];
	$group_city		=	$inputControl['group_city'];
	$group_state	=	$inputControl['group_state'];
	$group_zip		=	$inputControl['group_zip'];
	$client_phone	=	$inputControl['client_phone'];
	$no_of_emp		=	$inputControl['no_of_emp'];
	$benefits_manager	=	$inputControl['benefits_manager'];
	$manager_email	=	$inputControl['manager_email'];
	$manager_phone	=	$inputControl['manager_phone'];
	$recipient_name	=	$inputControl['recipient_name'];
	$recipient_email	=	$inputControl['recipient_email'];
	$recipient_phone	=	$inputControl['recipient_phone'];
	$eligible_confirm	=	$inputControl['eligible_confirm'];
	$confirm_email	=	$inputControl['confirm_email'];
	$confirm_phone	=	$inputControl['confirm_phone'];
	$third_admin_name	=	$inputControl['third_admin_name'];
	$third_admin_email	=	$inputControl['third_admin_email'];
	$third_admin_phone	=	$inputControl['third_admin_phone'];
	
	$status		=	1;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		$row = [
			'name' 	=> 	$name,
			'id'			=>	$id,
			'group_address'	=>	$group_address,
			'group_city'	=>	$group_city,
			'group_state'	=>	$group_state,
			'group_zip'		=>	$group_zip,
			'client_phone'	=>	$client_phone,
			'no_of_emp'		=>	$no_of_emp,
			'benefits_manager'	=>	$benefits_manager,
			'manager_email'	=>	$manager_email,
			'manager_phone'	=>	$manager_phone,
			'recipient_name'	=>	$recipient_name,
			'recipient_email'	=>	$recipient_email,
			'recipient_phone'	=>	$recipient_phone,
			'eligible_confirm'	=>	$eligible_confirm,
			'confirm_email'	=>	$confirm_email,
			'confirm_phone'	=>	$confirm_phone,
			'third_admin_name'	=>	$third_admin_name,
			'third_admin_email'	=>	$third_admin_email,
			'third_admin_phone'	=>	$third_admin_phone,
		];
		
		$sql = "UPDATE rx_groups SET name=:name,group_address=:group_address,group_city=:group_city,group_state=:group_state,group_zip=:group_zip,client_phone=:client_phone,no_of_emp=:no_of_emp,benefits_manager=:benefits_manager,manager_email=:manager_email,manager_phone=:manager_phone,recipient_name=:recipient_name,recipient_email=:recipient_email,recipient_phone=:recipient_phone,eligible_confirm=:eligible_confirm,confirm_email=:confirm_email,confirm_phone=:confirm_phone,third_admin_name=:third_admin_name,third_admin_email=:third_admin_email,third_admin_phone=:third_admin_phone WHERE id=:id ";

		/** @var PDO $pdo */
		$success 	= 	$db->prepare($sql)->execute($row);
		 
		if($success){
			$flag	=	'success';
			$result['msg']	=	'Plan has been successfully updated.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'An error occured. Try again later.' ;
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});



$app->post('/admin/invitePatient', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	
	$name			=	$inputControl['name'];
   	$user_group		=	$inputControl['user_group'];
	$email			=	$inputControl['email'];
	$admin_user_id	=	$inputControl['user_id'];
	
	
	$status		=	1;
	$flag		=	'';
	
	if(!checkUserExist($email)){
		try {

			$db = new db();
			$db = $db->connect();

			$db->query("SET  CHARACTER SET utf8;");

			
			$permitted_chars = 'abcdefghijklmnopqrstuvwxyz';
			$sub_chars	= substr(str_shuffle($permitted_chars), 0, 10);
			
			$password = $sub_chars;
			
			$row_1 = [
				'username' 		=> 	$email,
				'password' 		=> 	md5($password ),
				'role'			=>	'patient',
				'status'		=>	$status
			];
			$sql_1 = "INSERT INTO rx_users SET username=:username,password=:password,role=:role,status=:status";

			/** @var PDO $pdo */
			$success_1 	= 	$db->prepare($sql_1)->execute($row_1);
			$user_id 	= 	$db->lastInsertId();

			if($user_id){
				$status_2	=	2;
				$row = [
					'user_id' 		=> 	$user_id,
					'group_id' 		=> 	$user_group,
					'first_name' 	=> 	$name,
					'email'			=>	$email,
					'invited_by'	=>	$admin_user_id,
					'status'		=>	$status_2
				];

				$sql = "INSERT INTO rx_patients SET user_id=:user_id,group_id=:group_id,first_name=:first_name,email=:email,invited_by=:invited_by,status=:status";

				/** @var PDO $pdo */ 
				$success 		= 	$db->prepare($sql)->execute($row);
				$patient_id 	= 	$db->lastInsertId();

				if($patient_id){

					/*.............Active campign Start..................*/

					$url = 'https://rxtoyou.api-us1.com';
					$key='d23525f33c29a6eddfe6e38ef4bf1c0bd82fe710de0d40d96115afafe3923f0fc3175c54';

					$params = array(  
						'api_key'      => $key, 
						'api_action'   => 'contact_sync',
						'api_output'   => 'serialize',
					);

					// here we define the data we are posting in order to perform an update
					$post = array(
						'email'                    => $email,
						'first_name'               => $name,
						// 'form'          => $formid, // Subscription Form ID, to inherit those redirection settings
						'field[%SITE_PASSWORD%,0]' 	=>	$password,
						'field[%USER_GROUP_ID%,0]' 	=>	$user_group,
						
						'p[3]'                   => 4, // example list ID (REPLACE '123' WITH ACTUAL LIST ID, IE: p[5] = 5)
						'status[3]'              => 1, // 1: active, 2: unsubscribed (REPLACE '123' WITH ACTUAL LIST 
					);


					$query = "";

					foreach( $params as $key => $value ) $query .= urlencode($key) . '=' . urlencode($value) . '&';
					$query = rtrim($query, '& ');

					$data = "";

					foreach( $post as $key => $value ) $data .= urlencode($key) . '=' . urlencode($value) . '&';
					$data = rtrim($data, '& ');



					// clean up the url
					$url = rtrim($url, '/ ');


					if ( !function_exists('curl_init') ) die('CURL not supported. (introduced in PHP 4.0.2)');


					if ( $params['api_output'] == 'json' && !function_exists('json_decode') ) {
						die('JSON not supported. (introduced in PHP 5.2.0)');
					}

					$api = $url . '/admin/api.php?' . $query;


					$request = curl_init($api); // initiate curl object

					curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response

					curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)

					curl_setopt($request, CURLOPT_POSTFIELDS, $data); // use HTTP POST to send form data

					//curl_setopt($request, CURLOPT_SSL_VERIFYPEER, FALSE); // uncomment if you get no gateway response and are using HTTPS

					curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);



					$response = (string)curl_exec($request); // execute curl post and store results in $response



					// additional options may be required depending upon your server configuration

					// you can find documentation on curl options at http://www.php.net/curl_setopt

					curl_close($request); // close curl object



					if ( !$response ) {

						die('Nothing was returned. Do you have a connection to Email Marketing server?');

					}



					// This line takes the response and breaks it into an array using:

					// JSON decoder

					//$result = json_decode($response);

					// unserializer

					$result = unserialize($response);


				   /*.............Active campign end..................*/


					$flag	=	'success';
					$result['msg']	=	'Patient has been successfully invited to your plan.';



				}
				else{
					$flag	=	'error';
					$result['msg']	=	'An error occured. Try again later.';
				}
			}
			else{
				$flag	=	'error';
				$result['msg']	=	'An error occured. Try again later.';
			}

			return $this->response->withJson(array(
				'status' 	=> 	$flag,
				'message'	=>	$result 
			));


		} catch (PDOException $e) {
			return $this->response->withJson(array(
				'status' 	=> 	'error',
				'message'	=>	$e
			));
		}
	}
	else{
		$result['msg']	=	'Email already exists.';
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$result 
		));
	}
});


$app->post('/admin/getActivePatientsList', function(Request $request, Response $response) {
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson(array(
			'status' 	=>  'error',
			'message'	=>	'Invalid Request'
		));
	}
	
	$inputControl 	= 	$request->getParsedBody();
	$user_id		=	$inputControl['user_id'];
	$status			=	1;

	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT rx_patients.user_id,
		rx_patients.first_name,
		rx_users.username,
		rx_users.status 
		FROM rx_patients 
		LEFT JOIN rx_users ON (rx_patients.user_id=rx_users.id)  
		WHERE (rx_users.status=:status) ORDER BY rx_patients.id DESC');
		$stmt->bindParam('status', $status);
		$stmt->execute();
		$patients = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($patients) > 0){
			$flag	=	'success';
			$result['patients']	=	$patients;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No Patients found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
	
});


//get patient details for order
$app->post('/admin/getPatientDetailsforOrder', function(Request $request, Response $response) {
	
	$inputControl 	= $request->getParsedBody();
	$user_id		=	$inputControl['patient_user_id'];
	
	$order_items	=	$medication_items = array();
	$status		=	1;
	$flag		=	'';
	$partner_id	=	$license_no	=	0;
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT rxus.username as email,rxgp.name from rx_users rxus
		LEFT JOIN rx_patients rxps ON (rxus.id = rxps.user_id)
		LEFT JOIN rx_groups rxgp ON (rxgp.id = rxps.group_id)
		WHERE rxus.id=:user_id ');
		$stmt->bindParam('user_id', $user_id);
		$stmt->execute();
		$details = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		if(count($details) > 0){
			$flag	=	'success';
			$result['msg']	=	'Success.';
			$result['details']	=	array(
				'email'		=>	$details[0]->email,
				'group_name'		=>	$details[0]->name,
			);
			
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No details found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {

		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});



//get details of all partnercompanies
$app->post('/admin/exportAllPartnerCompanies', function(Request $request, Response $response) {
	
	$inputControl 	= $request->getParsedBody();
	$data_array	=	array();
	
    try {
		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
	
		$stmt = $db->prepare('SELECT * from rx_partner_companies ORDER BY id DESC');
		$stmt->execute();
		$companies = $stmt->fetchAll(PDO::FETCH_OBJ);
		$db = null;
		
		if(count($companies) > 0){
			$i= 0;
			foreach($companies as $company){
				$companystatus = array(
					'1' => 'Active',
					'2' => 'Suspended', 
				);
				$data_array[$i]	=	array(
					//'ID'	=> $order->id,
					'No'				=>	$i+1,
					'Partner Company ID'=>	$company->id,
					'Company Name'		=>	$company->name,
					'License Number'	=>	$company->license_no,
					'Status'			=>	$companystatus[$company->status]
				);
				
				$i++;
			}

			$flag	=	'success';
			$result['details']	=	$data_array;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No partner companies found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


//get details of all partnercompanyusers
$app->post('/admin/exportPartnerUsersbyCompany', function(Request $request, Response $response) {
	
	$inputControl 	= $request->getParsedBody();
	$company_slug = $inputControl['company_slug'];
	$data_array	=	array();
	
    try {
		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
	
		$stmt = $db->prepare('SELECT rxpu.first_name,rxpu.email,rxu.status,rxpc.name,rxpc.license_no FROM rx_partners rxpu 
		INNER JOIN rx_users rxu ON rxu.id = rxpu.user_id 
		INNER JOIN rx_partner_companies rxpc ON rxpc.id = rxpu.company_id WHERE rxpc.slug=:slug ORDER BY rxpu.id ASC');
		$stmt->bindParam('slug',$company_slug);
		$stmt->execute();
		$company_users = $stmt->fetchAll(PDO::FETCH_OBJ);
		$db = null;
		
		if(count($company_users) > 0){
			$i= 0;
			foreach($company_users as $company_user){
				$userstatus = array(
					'1' => 'Active',
					'2' => 'Suspended', 
				);
				$data_array[$i]	=	array(
					//'ID'	=> $order->id,
					'No'				=>	$i+1,
					'Name'				=>	$company_user->first_name,
					'Email'				=>	$company_user->email,
					'Company Name'		=>	$company_user->name,
					'License Number'	=>	$company_user->license_no,
					'Status'			=>	$userstatus[$company_user->status]
				);
				
				$i++;
			}

			$flag	=	'success';
			$result['details']	=	$data_array;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No partner users found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


//get plans list to export
$app->post('/admin/exportPlans', function(Request $request, Response $response) {
	
	$inputControl 	= $request->getParsedBody();
	$action 	=	$inputControl['action'];
	$status_1			=	1;
	$status_2		=	2;
	$condition	=	'WHERE (rx_groups.status=:status_1 OR rx_groups.status=:status_2)';
	if($action == 'company'){
		$company_slug = $inputControl['company_slug'];
		$condition .= ' AND rxpc.slug=:slug';
	}
	$data_array	=	array();
	
    try {
		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
	
		$stmt = $db->prepare('SELECT rx_groups.*,rxpc.name  as company_name,rxpc.status as company_status from rx_groups
		LEFT JOIN rx_partner_companies rxpc ON rx_groups.company_id = rxpc.id
		'.$condition.'
		ORDER BY rxpc.name ASC');
		$stmt->bindParam('status_1', $status_1);
		$stmt->bindParam('status_2', $status_2);
		if($action == 'company'){
			$stmt->bindParam('slug',$company_slug);
		}
		$stmt->execute();
		$plans = $stmt->fetchAll(PDO::FETCH_OBJ);
		$db = null;
		
		if(count($plans) > 0){
			$i= 0;
			foreach($plans as $plan){
				$planstatus = array(
					'1' => 'Active',
					'2' => 'Suspended',
					'3' => 'Deleted',
				);
				$data_array[$i]	=	array(
					//'ID'	=> $order->id,
					'No'				=>	$i+1,
					'Plan ID'			=>	$plan->id,
					'Company Name'		=>	($plan->company_id == 0)?'Admin':$plan->company_name,
					'Company Status'	=>	($plan->company_id == 0)?'':$planstatus[$plan->company_status],
					'Plan Name'			=>	$plan->name,
					'Address'			=>	$plan->group_address,
					'City'				=>	$plan->group_city,
					'State'				=>	$plan->group_state,
					'Zip'				=>	$plan->group_zip,
					'Phone'				=>	$plan->client_phone,
					'No. of Employees'	=>	$plan->no_of_emp,
					'Benefits Manager'	=>	$plan->benefits_manager,
					'Benefits Manager Email Address'	=>	$plan->manager_email,
					'Benefits Manager Phone Number'		=>	$plan->manager_phone,
					'Invoice Recipient'	=>	$plan->recipient_name,
					'Invoice Recipient Email Address'	=>	$plan->recipient_email,
					'Invoice Recipient Phone Number'	=>	$plan->recipient_phone,
					'Eligibility Confirmation Contact'	=>	$plan->eligible_confirm,
					'Eligibility Contact Email'			=>	$plan->confirm_email,
					'Eligibility Contact Phone'			=>	$plan->confirm_phone,
					'Third Party Administrator Name'	=>	$plan->third_admin_name,
					'Third Party Administrator Email'	=>	$plan->third_admin_email,
					'Third Party Administrator Phone'	=>	$plan->third_admin_phone,
					'Plan Status'			=>	$planstatus[$plan->status]
				);
				
				$i++;
			}

			$flag	=	'success';
			$result['details']	=	$data_array;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No plans found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});



//get details of plan
$app->post('/admin/exportThisPlan', function(Request $request, Response $response) {
	
	$inputControl 	= $request->getParsedBody();
	$plan_id 	=	$inputControl['plan_id'];
	$data_array	=	array();
	
    try {
		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
	
		$stmt = $db->prepare('SELECT rx_groups.*,rxpc.name  as company_name,rxpc.status as company_status from rx_groups
		LEFT JOIN rx_partner_companies rxpc ON rx_groups.company_id = rxpc.id
		WHERE rx_groups.id=:plan_id
		ORDER BY rxpc.name ASC');
		$stmt->bindParam('plan_id',$plan_id);
		$stmt->execute();
		$plan = $stmt->fetch(PDO::FETCH_OBJ);
		$db = null;
		
		if(isset($plan)){
			$planstatus = array(
				'1' => 'Active',
				'2' => 'Suspended',
				'3' => 'Deleted'
			);
			$data_array[0]	=	array(
				'Plan ID'			=>	$plan->id,
				'Company Name'		=>	($plan->company_id == 0)?'Admin':$plan->company_name,
				'Company Status'	=>	($plan->company_id == 0)?'':$planstatus[$plan->company_status],
				'Plan Name'			=>	$plan->name,
				'Address'			=>	$plan->group_address,
				'City'				=>	$plan->group_city,
				'State'				=>	$plan->group_state,
				'Zip'				=>	$plan->group_zip,
				'Phone'				=>	$plan->client_phone,
				'No. of Employees'	=>	$plan->no_of_emp,
				'Benefits Manager'	=>	$plan->benefits_manager,
				'Benefits Manager Email Address'	=>	$plan->manager_email,
				'Benefits Manager Phone Number'		=>	$plan->manager_phone,
				'Invoice Recipient'	=>	$plan->recipient_name,
				'Invoice Recipient Email Address'	=>	$plan->recipient_email,
				'Invoice Recipient Phone Number'	=>	$plan->recipient_phone,
				'Eligibility Confirmation Contact'	=>	$plan->eligible_confirm,
				'Eligibility Contact Email'			=>	$plan->confirm_email,
				'Eligibility Contact Phone'			=>	$plan->confirm_phone,
				'Third Party Administrator Name'	=>	$plan->third_admin_name,
				'Third Party Administrator Email'	=>	$plan->third_admin_email,
				'Third Party Administrator Phone'	=>	$plan->third_admin_phone,
				'Plan Status'			=>	$planstatus[$plan->status]
			);
				

			$flag	=	'success';
			$result['details']	=	$data_array;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No details found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


//get details of patients
$app->post('/admin/exportPatients', function(Request $request, Response $response) {
	
	$inputControl 	= $request->getParsedBody();
	$action 	=	$inputControl['action'];
	$condition	=	'';
	if($action == 'plan'){
		$plan_id = $inputControl['plan_id'];
		$condition = ' WHERE rxg.id=:plan_id';
	}
	else if($action == 'admin'){
		$company_id = 0;
		$condition = ' WHERE rxg.company_id=:company_id';
	}
	else{
		$condition = '';
	}
	$data_array	=	array();
	
    try {
		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
	
		$stmt = $db->prepare('SELECT rxpa.*,rxu.status as patient_status,rxg.name as plan_name,rxg.status as plan_status,rxg.company_id,rxpc.name  as company_name,rxpc.status as company_status from rx_patients rxpa
		LEFT JOIN rx_users rxu ON rxu.id = rxpa.user_id
		LEFT JOIN rx_groups rxg ON rxg.id = rxpa.group_id
		LEFT JOIN rx_partner_companies rxpc ON rxg.company_id = rxpc.id
		'.$condition.'
		ORDER BY rxpc.name ASC');
		if($action == 'plan'){
			$stmt->bindParam('plan_id',$plan_id);
		}
		else if($action == 'admin'){
			$stmt->bindParam('company_id',$company_id);
		}
		$stmt->execute();
		$patients = $stmt->fetchAll(PDO::FETCH_OBJ);
		$db = null;
		
		if(count($patients) > 0){
			$i= 0;
			foreach($patients as $patient){
				$patientstatus = array(
					'1' => 'Active',
					'2' => 'Suspended', 
				);
				$data_array[$i]	=	array(
					//'ID'	=> $order->id,
					'No'				=>	$i+1,
					'Patient User ID'	=>	$patient->user_id,
					'Company Name'		=>	($patient->company_id == 0)?'Admin':$patient->company_name,
					'Company Status'	=>	($patient->company_id == 0)?'':$patientstatus[$patient->company_status],
					'Plan Name'			=>	$patient->plan_name,
					'Plan Status'		=>	$patientstatus[$patient->plan_status],
					'First Name'		=>	$patient->first_name,
					'Last Name'			=>	$patient->last_name,
					'Home Phone No.'	=>	$patient->home_phone_no,
					'Mobile Phone No.'	=>	$patient->mobile_phone_no,
					'Email'				=>	$patient->email,
					'Shipping Address 1'	=>	$patient->shipping_address_1,
					'Shipping Address 1'	=>	$patient->shipping_address_2,
					'Shipping City'			=>	$patient->shipping_city,
					'Shipping State'		=>	$patient->shipping_state,
					'Shipping ZIP'			=>	$patient->shipping_zip,
					'Height'				=>	$patient->height_12,
					'Weight'				=>	$patient->weight_12,
					'Date of Birth'			=>	$patient->birth_month.'-'.$patient->birth_day.'-'.$patient->birth_year,
					'Are You a Smoker?'			=>	$patient->are_smoker,
					'Are You Breastfeeding?'		=>	$patient->are_breastfeeding,
					'Are You Pregnant?'			=>	$patient->are_pregnant,
					'Due Date'				=>	$patient->due_month.'-'.$patient->due_day.'-'.$patient->due_year,
					'Sex'					=>	$patient->sex,
					'Drug Allergies Listed'	=>	$patient->have_drug_allergies,
					'Medical History'		=>	$patient->medical_history,
					'Division'				=>	$patient->division,
					'Relationship to employer'	=>	$patient->emp_relation,
					'Refill Reminder Preference'	=>	$patient->rem_notification,
					'Patient Status'		=>	$patientstatus[$patient->patient_status]
				);
				
				$i++;
			}

			$flag	=	'success';
			$result['details']	=	$data_array;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No patients found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


//get details of patient
$app->post('/admin/exportThisPatient', function(Request $request, Response $response) {
	
	$inputControl 	= $request->getParsedBody();
	$patient_user_id 	=	$inputControl['patient_user_id'];
	$condition	=	'';
	$data_array	=	array();
	
    try {
		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
	
		$stmt = $db->prepare('SELECT rxpa.*,rxu.status as patient_status,rxg.name as plan_name,rxg.status as plan_status,rxg.company_id,rxpc.name  as company_name,rxpc.status as company_status from rx_patients rxpa
		LEFT JOIN rx_users rxu ON rxu.id = rxpa.user_id
		LEFT JOIN rx_groups rxg ON rxg.id = rxpa.group_id
		LEFT JOIN rx_partner_companies rxpc ON rxg.company_id = rxpc.id
		WHERE rxpa.user_id=:user_id
		ORDER BY rxpc.name ASC');
		$stmt->bindParam('user_id',$patient_user_id);
		$stmt->execute();
		$patient = $stmt->fetch(PDO::FETCH_OBJ);
		$db = null;
		
		if(isset($patient)){
			$patientstatus = array(
				'1' => 'Active',
				'2' => 'Suspended', 
			);
			$data_array[0]	=	array(
				'Patient User ID'	=>	$patient->user_id,
				'Company Name'		=>	($patient->company_id == 0)?'Admin':$patient->company_name,
				'Company Status'	=>	($patient->company_id == 0)?'':$patientstatus[$patient->company_status],
				'Plan Name'			=>	$patient->plan_name,
				'Plan Status'		=>	$patientstatus[$patient->plan_status],
				'First Name'		=>	$patient->first_name,
				'Last Name'			=>	$patient->last_name,
				'Home Phone No.'	=>	$patient->home_phone_no,
				'Mobile Phone No.'	=>	$patient->mobile_phone_no,
				'Email'				=>	$patient->email,
				'Shipping Address 1'	=>	$patient->shipping_address_1,
				'Shipping Address 1'	=>	$patient->shipping_address_2,
				'Shipping City'			=>	$patient->shipping_city,
				'Shipping State'		=>	$patient->shipping_state,
				'Shipping ZIP'			=>	$patient->shipping_zip,
				'Height'				=>	$patient->height_12,
				'Weight'				=>	$patient->weight_12,
				'Date of Birth'			=>	$patient->birth_month.'-'.$patient->birth_day.'-'.$patient->birth_year,
				'Are You a Smoker?'			=>	$patient->are_smoker,
				'Are You Breastfeeding?'		=>	$patient->are_breastfeeding,
				'Are You Pregnant?'			=>	$patient->are_pregnant,
				'Due Date'				=>	$patient->due_month.'-'.$patient->due_day.'-'.$patient->due_year,
				'Sex'					=>	$patient->sex,
				'Drug Allergies Listed'	=>	$patient->have_drug_allergies,
				'Medical History'		=>	$patient->medical_history,
				'Division'				=>	$patient->division,
				'Relationship to employer'	=>	$patient->emp_relation,
				'Refill Reminder Preference'	=>	$patient->rem_notification,
				'Patient Status'		=>	$patientstatus[$patient->patient_status]
			);
				
			$flag	=	'success';
			$result['details']	=	$data_array;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No details found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});

function checkOrderstatusEditablebyIDforAdmin($order_id){
   try {
		$db = new db();
		$db = $db->connect();
		
		$order_query = $db->prepare('SELECT status from rx_medical_orders WHERE id=:id');
		$order_query->bindParam('id',$order_id);
		$order_query->execute();
		$order_array = $order_query->fetch(PDO::FETCH_OBJ);
      
		   
		$db = null;
		 
		if(isset($order_array)){
			if($order_array->status != 7){
				return true;
			}
			else{
				return false;
			}
		}
		else{
			return false;
		}	
		
    } catch (PDOException $e) {
        return false;
    }
}

?>
