<?php

use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use \Firebase\JWT\JWT;


$app->post('/admin/login', function(Request $request, Response $response) {

    $inputControl = $request->getParsedBody();
   	$username	=	$inputControl['username'];
	$password	=	$inputControl['password'];
	$role		=	$inputControl['role'];
	$status		=	1;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT * from rx_users WHERE username=:username AND status=:status');
		$stmt->bindParam('username',$username);
		$stmt->bindParam('status', $status);
		$stmt->execute();
		$users = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		//$db = null;
		 
		if(count($users) > 0){
			if($users[0]->password != md5($password)){
				$flag	=	'error';
				$result['msg']	=	'Incorrect Password';
			}
			else{
				if($users[0]->role == $role){
					$flag	=	'success';
					$result['credentials']	=	array(
						'username'	=> $users[0]->username,
						'role'		=> $users[0]->role,
						'status'	=> $users[0]->status,
						'user_id'	=> $users[0]->id
					);
					$result['msg']	=	'Success.';
					$result['token'] = JWT::encode( array($users[0]->id, $users[0]->username ), $db->getTokenJWT);
				}
				else{
					$flag	=	'error';
					$result['msg']	=	'You have no permission to access this.';
				}
			}
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'Incorrect username or password.';
		}
		
		$db = null;
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
        return $this->response->withJson($e);
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


$app->post('/panel/login', function(Request $request, Response $response) {

    $inputControl = $request->getParsedBody();
   	$username	=	$inputControl['username'];
	$password	=	$inputControl['password'];
	$status		=	3;
	$flag		=	'';
	$password_status	=	1;
	$name = '';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT * from rx_users WHERE username=:username AND status!=:status');
		$stmt->bindParam('username',$username);
		$stmt->bindParam('status', $status);
		$stmt->execute();
		$users = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		 
		if(count($users) > 0){
			
			$table_name	=	'rx_'.$users[0]->role.'s';
		
			$user_query = $db->prepare('SELECT first_name,status from '.$table_name.' WHERE user_id=:user_id');
			$user_query->bindParam('user_id',$users[0]->id);
			$user_query->execute();
			$user_detail_array = $user_query->fetch(PDO::FETCH_OBJ);
			if($user_detail_array){
				$password_status = $user_detail_array->status;
				$name = $user_detail_array->first_name;
			}
			
			
			
			if($users[0]->password != md5($password)){
				$flag	=	'error';
				$result['msg']	=	'Incorrect Password';
			}
			else{
				if($users[0]->role == 'patient' || ($users[0]->role == 'partner' && chackPartnerCompanyActivebyUserId($users[0]->id))){	
					if($users[0]->status == 1){
						
						$flag	=	'success';
						$result['credentials']	=	array(
							'username'	=> $users[0]->username,
							'role'		=> $users[0]->role,
							'status'	=> $users[0]->status,
							'user_id'	=> $users[0]->id,
							'name'		=> $name,
							'password_status'	=> $password_status
						);
						$result['msg']	=	'Success.';
						$result['token'] = JWT::encode( array($users[0]->id, $users[0]->username ), $db->getTokenJWT);
					}
					else{
						$flag	=	'error';
						$result['msg']	=	'You have no permission to access this right now. Please contact administrator.';
					}
				}
				else{
					$flag	=	'error';
					$result['msg']	=	'You have no permission to access this right now.';
				}
			}
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'Incorrect username or password.';
		}
		
		$db = null;
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
        return $this->response->withJson($e);
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


$app->post('/panel/changePassword', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	
	$username	=	$inputControl['username'];
	
   	$password	=	$inputControl['password'];
	$npassword	=	$inputControl['npassword'];
	
	$status		=	1;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT * from rx_users WHERE username=:username AND status=:status');
		$stmt->bindParam('username',$username);
		$stmt->bindParam('status', $status);
		$stmt->execute();
		$users = $stmt->fetchAll(PDO::FETCH_OBJ);
		 
		if(count($users) > 0){
			if($users[0]->password != md5($password)){
				$flag	=	'error';
				$result['msg']	=	'Current password is incorrect';
			}
			else{
				if($password == $npassword){
					$flag	=	'error';
					$result['msg']	=	'Old Password and New Password cannot be same';
				}
				else{
					$newpassword	=	md5($npassword);
					$query = "UPDATE rx_users SET password=:password WHERE id=:id";
					$stmt = $db->prepare($query);
					$stmt->bindParam("password", $newpassword);
					$stmt->bindParam("id", $users[0]->id);
					$stmt->execute();

					$db = null;

					$flag	=	'success';
					$result['msg']	=	'Your password successfully changed. You need to login again.';
				}
			}
		}
		else{
			$flag	=	'login';
			$result['msg']	=	'Error! You need to login first.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
        return $this->response->withJson($e);
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


$app->post('/user/forgotPassword', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$email	=	$inputControl['email'];
	
	$permitted_chars = 'abcdefghijklmnopqrstuvwxyz';
	$sub_chars	= substr(str_shuffle($permitted_chars), 0, 6);
	
	$reset_link = md5($email.$sub_chars);
	
	
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$status_1	=	1;
		$status_2	=	2;
		
		$dataQuerry = $db->prepare('SELECT status from rx_users WHERE username=:email AND (status=:status_1 OR status=:status_2)'); 
		$dataQuerry->bindParam('email',$email);
		$dataQuerry->bindParam('status_1',$status_1);
		$dataQuerry->bindParam('status_2',$status_2);
		$dataQuerry->execute();
		$data_result = $dataQuerry->fetch(PDO::FETCH_OBJ);
		
		if(isset($data_result) && !empty($data_result)){
			
			if($data_result->status == 2){
				$result['msg']	=	'Your account is suspended. Please contact administrator.'; 
				return $this->response->withJson(array(
					'status' 	=> 	'error',
					'message'	=>	$result 
				));
			}
			else{

				$row = [
					'reset_link' 		=> 	$reset_link,
					'username'			=>	$email
				];

				$sql		=	"UPDATE rx_users SET reset_link=:reset_link WHERE username=:username";
				$success	= 	$db->prepare($sql)->execute($row);
				if($success){
					$curl = curl_init();

					curl_setopt_array($curl, array(
					  CURLOPT_URL => "https://api.sendgrid.com/v3/mail/send",
					  CURLOPT_RETURNTRANSFER => true,
					  CURLOPT_ENCODING => "",
					  CURLOPT_MAXREDIRS => 10,
					  CURLOPT_TIMEOUT => 30,
					  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
					  CURLOPT_CUSTOMREQUEST => "POST",
					  CURLOPT_POSTFIELDS => "{\n  \"personalizations\": [\n    {\n      \"to\": [\n        {\n          \"email\": \"$email\"\n        }\n      ],\n      \"subject\": \"Reset Password\"\n    }\n  ],\n  \"from\": {\n    \"email\": \"info@rxtoyou.com\"\n  },\n  \"content\": [\n    {\n      \"type\": \"text/html\",\n      \"value\": \"<p>You have requested a password reset for the following account:</p><p>Site Name: RxToYou</p><p>Username: $email</p><p>If this was a mistake, just ignore this email and nothing will happen.</p><p>To reset your password, visit the following address:</p><a href='https://rxtoyou.webeteerprojects.com/login/reset-password/$reset_link'>Click here to reset password</a>\"\n    }\n  ]\n}",
					  CURLOPT_HTTPHEADER => array(
						"authorization: Bearer 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",
						"cache-control: no-cache",
						"content-type: application/json"
					  ),
					));

					$response = curl_exec($curl);
					$err = curl_error($curl);

					curl_close($curl);
					//header('Location: thanks.html');

					if ($err) {
					  echo "cURL Error #:" . $err;
					} else {
					  //echo $response;
					}


					$result['msg']	=	'An email has been sent to the supplied email address. Follow the instruction in the email to reset your password.'; 
					return $this->response->withJson(array(
						'status' 	=> 	'success',
						'message'	=>	$result 
					));
				}
				else{
					$result['msg']	=	'An error occured. Try again later.'; 
					return $this->response->withJson(array(
						'status' 	=> 	'error',
						'message'	=>	$result 
					));
				}
			}
		}
		else{
			$result['msg']	=	'No account found for this email.'; 
			return $this->response->withJson(array(
				'status' 	=> 	'error',
				'message'	=>	$result 
			));
		}
		
	}
	catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
	}
});


$app->post('/user/checkResetLink', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$reset_link	=	$inputControl['reset_link'];
	$status_1 	=	1;
	$status_2 	=	2;
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT id,status from rx_users WHERE reset_link=:reset_link AND (status=:status_1 OR status=:status_2)');
		$stmt->bindParam('reset_link',$reset_link);
		$stmt->bindParam('status_1',$status_1);
		$stmt->bindParam('status_2',$status_2);
		$stmt->execute();
		$users = $stmt->fetchAll(PDO::FETCH_OBJ);
		
		if(count($users)>0){
			if($users[0]->status == 1){
				$result['msg']	=	'valid link'; 
				return $this->response->withJson(array(
					'status' 	=> 	'success',
					'message'	=>	$result 
				));
			}
			else{
				$result['msg']	=	'Your account is suspended. Please contact administrator.'; 
				return $this->response->withJson(array(
					'status' 	=> 	'error',
					'message'	=>	$result 
				));
			}
		}
		else{
			$result['msg']	=	'This link is invalid or expired.'; 
			return $this->response->withJson(array(
				'status' 	=> 	'error',
				'message'	=>	$result 
			));
		}
	}
	catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
	}
});


$app->post('/user/resetPassword', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$password	=	$inputControl['npassword'];
	$reset_link	=	$inputControl['reset_link'];
	$status_1 = 1;
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		
		$dataQuerry = $db->prepare('SELECT id from rx_users WHERE reset_link=:reset_link AND status=:status_1'); 
		$dataQuerry->bindParam('reset_link',$reset_link);
		$dataQuerry->bindParam('status_1',$status_1);
		$dataQuerry->execute();
		$data_result = $dataQuerry->fetch(PDO::FETCH_OBJ);
		
		if(isset($data_result) && !empty($data_result)){
			$user_id	=		$data_result->id;
		}
		
		$row = [
			'password' 		=> 	md5($password),
			'reset_link'	=>	$reset_link
		];

		$sql		=	"UPDATE rx_users SET password=:password WHERE reset_link=:reset_link";
		$success	= 	$db->prepare($sql)->execute($row);
		if($success){
			
			$row1 = [
				'id' 			=> 	$user_id,
				'reset_link' 	=> 	''
			];

			$sql1		=	"UPDATE rx_users SET reset_link=:reset_link WHERE id=:id";
			$success1	= 	$db->prepare($sql1)->execute($row1);
			
			
			$result['msg']	=	'Your password has been updated successfully.'; 
			return $this->response->withJson(array(
				'status' 	=> 	'success',
				'message'	=>	$result 
			));
		}
		else{
			$result['msg']	=	'An error occured. Try again later.'; 
			return $this->response->withJson(array(
				'status' 	=> 	'error',
				'message'	=>	$result 
			));
		}
	}
	catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
	}
});


?>