<?php

use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use \Firebase\JWT\JWT;

//Common function for partner and patient
$app->post('/user/changePassword', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	
	$username	=	$inputControl['username'];
	
   	$password	=	$inputControl['password'];
	$npassword	=	$inputControl['npassword'];
	
	$status		=	1;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT * from rx_users WHERE username=:username AND status=:status');
		$stmt->bindParam('username',$username);
		$stmt->bindParam('status', $status);
		$stmt->execute();
		$users = $stmt->fetchAll(PDO::FETCH_OBJ);
		 
		if(count($users) > 0){
			if($users[0]->password != md5($password)){
				$flag	=	'error';
				$result['msg']	=	'Current password is incorrect';
			}
			else{
				if($password == $npassword){
					$flag	=	'error';
					$result['msg']	=	'Old Password and New Password cannot be same';
				}
				else{
					$newpassword	=	md5($npassword);
					$query = "UPDATE rx_users SET password=:password,status=:status WHERE id=:id";
					$stmt = $db->prepare($query);
					$stmt->bindParam("password", $newpassword);
					$stmt->bindParam("status", $status);
					$stmt->bindParam("id", $users[0]->id);
					$stmt->execute();

					
					
					$table_name	=	'rx_'.$users[0]->role.'s';
					$stmt1 = $db->prepare('UPDATE '.$table_name.' SET status=:status WHERE user_id=:id');
					$stmt1->bindParam("status", $status);
					$stmt1->bindParam("id", $users[0]->id);
					$stmt1->execute();
					
					
					$db = null;

					$flag	=	'success';
					$result['msg']	=	'Your password successfully changed. You need to login again.';
					
					if($users[0]->role == 'partner' || $users[0]->role == 'patient'){
					
						/*.............Active campign Start..................*/

						$url = 'https://rxtoyou.api-us1.com';
						$key='d23525f33c29a6eddfe6e38ef4bf1c0bd82fe710de0d40d96115afafe3923f0fc3175c54';

						$params = array(  
							'api_key'      => $key, 
							'api_action'   => 'contact_sync',
							'api_output'   => 'serialize',
						);
						
						
						$list_id	=	($users[0]->role == 'partner')?3:4;

						// here we define the data we are posting in order to perform an update
						$post = array(
							'email'                    	=> 	$username,
							'field[%SITE_PASSWORD%,0]' 	=>	$npassword,

							'p[3]'                   => $list_id, // example list ID (REPLACE '123' WITH ACTUAL LIST ID, IE: p[5] = 5)
							'status[3]'              => 1, // 1: active, 2: unsubscribed (REPLACE '123' WITH ACTUAL LIST 
						);


						$query = "";

						foreach( $params as $key => $value ) $query .= urlencode($key) . '=' . urlencode($value) . '&';
						$query = rtrim($query, '& ');

						$data = "";

						foreach( $post as $key => $value ) $data .= urlencode($key) . '=' . urlencode($value) . '&';
						$data = rtrim($data, '& ');



						// clean up the url
						$url = rtrim($url, '/ ');


						if ( !function_exists('curl_init') ) die('CURL not supported. (introduced in PHP 4.0.2)');


						if ( $params['api_output'] == 'json' && !function_exists('json_decode') ) {
							die('JSON not supported. (introduced in PHP 5.2.0)');
						}

						$api = $url . '/admin/api.php?' . $query;


						$request = curl_init($api); // initiate curl object

						curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response

						curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)

						curl_setopt($request, CURLOPT_POSTFIELDS, $data); // use HTTP POST to send form data

						//curl_setopt($request, CURLOPT_SSL_VERIFYPEER, FALSE); // uncomment if you get no gateway response and are using HTTPS

						curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);



						$response = (string)curl_exec($request); // execute curl post and store results in $response



						// additional options may be required depending upon your server configuration

						// you can find documentation on curl options at http://www.php.net/curl_setopt

						curl_close($request); // close curl object



						if ( !$response ) {

							die('Nothing was returned. Do you have a connection to Email Marketing server?');

						}



						// This line takes the response and breaks it into an array using:

						// JSON decoder

						//$result = json_decode($response);

						// unserializer

						$ac_result = unserialize($response);


					   /*.............Active campign end..................*/
					}
				}
			}
		}
		else{
			$flag	=	'login';
			$result['msg']	=	'Error! You need to login first.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
        return $this->response->withJson($e);
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


//list order statuses
$app->get('/user/getOrderStatuses', function(Request $request, Response $response) {
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson(array(
			'status' 	=>  'error',
			'message'	=>	'Invalid Request'
		));
	}
	
	$status		=	1;
	$status_2		=	2;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT id,status_text from rx_order_statuses ORDER BY id ASC');
		$stmt->execute();
		$order_statuses = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($order_statuses) > 0){
			$flag	=	'success';
			$result['details']	=	$order_statuses;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No statuses found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});



$app->post('/user/getPatientProfileDetails', function(Request $request, Response $response){
	$inputControl = $request->getParsedBody();
	$patient_user_id = $inputControl['patient_user_id'];
	try {
		$db = new db();
		$db = $db->connect();
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT pt.first_name,pt.last_name,pt.home_phone_no,pt.mobile_phone_no,pt.email,pt.shipping_address_1,	pt.shipping_address_2,pt.shipping_city,pt.shipping_state,pt.shipping_zip,pt.height_12,pt.weight_12,pt.birth_day,pt.birth_month,pt.birth_year,pt.are_smoker,pt.are_breastfeeding,pt.are_pregnant,pt.due_day,pt.due_month,pt.due_year,pt.sex,pt.have_drug_allergies,pt.medical_history,pt.division,pt.emp_relation,pt.rem_notification,gp.name as employer_name from rx_patients pt LEFT JOIN rx_groups gp ON (gp.id = pt.group_id) WHERE pt.user_id=:patient_user_id');
		$stmt->bindParam("patient_user_id", $patient_user_id);
		$stmt->execute();
		$patient_details = $stmt->fetch(PDO::FETCH_OBJ);
      	$db = null;
		
		
		if(count($patient_details) > 0){
			$flag	=	'success';
			$result['details']	=	$patient_details;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No details found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
		
	}
	catch (PDOException $e) {
        return $this->response->withJson($e);
    }
});



$app->post('/user/updatePatientProfileDetails', function(Request $request, Response $response) {
    $inputControl = $request->getParsedBody();
	$patient_user_id	=	$inputControl['patient_user_id'];
	try {
		$db = new db();
		$db = $db->connect();

		$row = [
			'first_name' 	=> $inputControl['first_name'],
			'last_name' 	=> $inputControl['last_name'],
			'home_phone_no' => $inputControl['home_phone_no'],
			'mobile_phone_no'	=>			$inputControl['mobile_phone_no'],
			'email'				=>	$inputControl['email'],
			'shipping_address_1'		=>	$inputControl['shipping_address_1'],
			'shipping_address_2'		=>	$inputControl['shipping_address_2'],
			'shipping_city'		=>	$inputControl['shipping_city'],
			'shipping_state'	=>	$inputControl['shipping_state'],
			'shipping_zip'		=>	$inputControl['shipping_zip'],
			'height_12'		=>	$inputControl['height_12'],
			'weight_12'		=>	$inputControl['weight_12'],
			'birth_day'		=>	$inputControl['birth_day'],
			'birth_month'		=>	$inputControl['birth_month'],
			'birth_year'		=>	$inputControl['birth_year'],
			'are_smoker'		=>	$inputControl['are_smoker'],
			'are_breastfeeding'	=>	$inputControl['are_breastfeeding'],
			'are_pregnant'		=>	$inputControl['are_pregnant'],
			'due_day'		=>	$inputControl['due_day'],
			'due_month'		=>	$inputControl['due_month'],
			'due_year'		=>	$inputControl['due_year'],
			'sex'			=>	$inputControl['sex'],
			'have_drug_allergies'	=>	$inputControl['have_drug_allergies'],
			'medical_history'		=>	$inputControl['medical_history'],
			'employer_name'		=>	$inputControl['employer_name'],
			'division'			=>	$inputControl['division'],
			'emp_relation'		=>	$inputControl['emp_relation'],
			'rem_notification'	=>	$inputControl['rem_notification'],
			'user_id'			=>	$patient_user_id
		];


		$sql = "UPDATE rx_patients SET first_name=:first_name, last_name=:last_name, home_phone_no=:home_phone_no,mobile_phone_no=:mobile_phone_no,email=:email,shipping_address_1=:shipping_address_1,shipping_address_2=:shipping_address_2,shipping_city=:shipping_city,shipping_state=:shipping_state,shipping_zip=:shipping_zip,height_12=:height_12,weight_12=:weight_12,birth_day=:birth_day,birth_month=:birth_month,birth_year=:birth_year,are_smoker=:are_smoker,are_breastfeeding=:are_breastfeeding,are_pregnant=:are_pregnant,due_day=:due_day,due_month=:due_month,due_year=:due_year,sex=:sex,have_drug_allergies=:have_drug_allergies,medical_history=:medical_history,employer_name=:employer_name,division=:division,emp_relation=:emp_relation,rem_notification=:rem_notification WHERE user_id=:user_id";

		/** @var PDO $pdo */
		$success 		= 	$db->prepare($sql)->execute($row);

		if($success){

			$relationship = array(
				'employee' => 'Employee / Self',
				'spouse' => 'Spouse / Partner', 
				'dependant' => 'Dependant'
			);
			$notification = array(
				'home-phone' => 'Home phone',
				'mobile-phone' => 'Mobile phone', 
				'email' => 'Email'
			);
			$prescriptions =	array(
				'attached' => 'Upload the script files',
				'fax' => 'I will arrange for my doctor to fax my prescription(s) to (858) 779-2537.', 
				'request' => 'Please fax my doctor to request a copy of my prescription(s)'
			);
			/*.............Active campign Start..................*/

			$url = 'https://rxtoyou.api-us1.com';
			$key='d23525f33c29a6eddfe6e38ef4bf1c0bd82fe710de0d40d96115afafe3923f0fc3175c54';

			$params = array(  
				'api_key'      => $key, 
				'api_action'   => 'contact_sync',
				'api_output'   => 'serialize',
			);

			// here we define the data we are posting in order to perform an update
			$post = array(

				'email'                    => $inputControl['email'],
				'first_name'               => $inputControl['first_name'],
				'last_name'                => $inputControl['last_name'],
				'phone'                    => $inputControl['home_phone_no'],


				// 'form'          => $formid, // Subscription Form ID, to inherit those redirection settings

				'field[%MOBILE_PHONE%,0]' 	=> 	$inputControl['mobile_phone_no'],
				'field[%SHIPPING_ADDRESS_LINE_1%,0]' 		=>	$inputControl['shipping_address_1'],
				'field[%SHIPPING_ADDRESS_LINE_2%,0]' 		=>	$inputControl['shipping_address_2'],
				'field[%SHIPPING_ADDRESS_CITY%,0]' 		=>	$inputControl['shipping_city'],
				'field[%SHIPPING_ADDRESS_STATE%,0]' 		=>	$inputControl['shipping_state'],
				'field[%SHIPPING_ADDRESS_ZIP%,0]' 		=>	$inputControl['shipping_zip'],
				'field[%HEIGHT%,0]' 		=>	$inputControl['height_12'],
				'field[%WEIGHT%,0]' 		=>	$inputControl['weight_12'],
				'field[%DATE_OF_BIRTH%,0]' 		=>	$inputControl['birth_month'].'/'.$inputControl['birth_day'].'/'.$inputControl['birth_year'],
				'field[%ARE_A_SMOKER%,0]' 		=>	$inputControl['are_smoker'],
				'field[%ARE_BREASTFEEDING%,0]' 		=>	$inputControl['are_breastfeeding'],
				'field[%ARE_PREGNANT%,0]' 		=>	$inputControl['are_pregnant'],
				'field[%DUE_DATE%,0]' 		=>		$inputControl['due_month'].'/'.$inputControl['due_day'].'/'.$inputControl['due_year'],
				'field[%SEX%,0]' 		=>	$inputControl['sex'],
				'field[%DRUG_ALLERGIES%,0]' 		=>	$inputControl['have_drug_allergies'],
				'field[%MEDICAL_HISTORY%,0]' 		=>	$inputControl['medical_history'],
				'field[%NAME_OF_EMPLOYER_GROUP%,0]' 		=>	$inputControl['employer_name'],
				'field[%DIVISION%,0]' 		=>	$inputControl['division'],
				'field[%RELATIONSHIP_TO_EMPLOYER%,0]' 		=>	$relationship[$inputControl['emp_relation']],
				'field[%REFILL_REMINDER_NOTIFICATION_PREFERENCE%,0]' 	=>	$notification[$inputControl['rem_notification']],

				'p[4]'                   => 4, // example list ID (REPLACE '123' WITH ACTUAL LIST ID, IE: p[5] = 5)
				'status[4]'              => 1, // 1: active, 2: unsubscribed (REPLACE '123' WITH ACTUAL LIST ID, IE: status[5] = 1)
			);

			// This section takes the input fields and converts them to the proper format

			$query = "";

			foreach( $params as $key => $value ) $query .= urlencode($key) . '=' . urlencode($value) . '&';

			$query = rtrim($query, '& ');

			$data = "";

			foreach( $post as $key => $value ) $data .= urlencode($key) . '=' . urlencode($value) . '&';

			$data = rtrim($data, '& ');


			$url = rtrim($url, '/ ');

			if ( !function_exists('curl_init') ) die('CURL not supported. (introduced in PHP 4.0.2)');


			if ( $params['api_output'] == 'json' && !function_exists('json_decode') ) {

				die('JSON not supported. (introduced in PHP 5.2.0)');

			}

			$api = $url . '/admin/api.php?' . $query;

			$request = curl_init($api); // initiate curl object

			curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response

			curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)

			curl_setopt($request, CURLOPT_POSTFIELDS, $data); // use HTTP POST to send form data

			curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);


			$response = (string)curl_exec($request); 

			curl_close($request); 


			if ( !$response ) {

				die('Nothing was returned. Do you have a connection to Email Marketing server?');

			}

			$result = unserialize($response);


		   /*.............Active campign end..................*/


			return $this->response->withJson(array(
				'status' 	=> 'success',
				'message'	=>	'Profile details updated successfully.'
			));
		}
		else{
			return $this->response->withJson(array(
				'status' 	=> 'error',
				'message'	=>	'An error occured. Try again later.'
			));
		}
		
    } catch (PDOException $e) {
        return $this->response->withJson($e);
    }
});



$app->post('/user/updateOrderDetails', function(Request $request, Response $response) {

    $inputControl = $request->getParsedBody();
   	
	$order_id	=	$inputControl['id'];
	
	$order_items		=	$inputControl['order_items'];
	$medication_items	=	$inputControl['medication_items'];

	
	try {
		$db = new db();
		$db = $db->connect();
		
		
		if(checkOrderstatusEditablebyID($order_id)){

			$row = [
				'first_name' 	=> $inputControl['first_name'],
				'last_name' 	=> $inputControl['last_name'],
				'home_phone_no' => $inputControl['home_phone_no'],
				'mobile_phone_no'	=>			$inputControl['mobile_phone_no'],
				'email'				=>	$inputControl['email'],
				'shipping_address_1'		=>	$inputControl['shipping_address_1'],
				'shipping_address_2'		=>	$inputControl['shipping_address_2'],
				'shipping_city'		=>	$inputControl['shipping_city'],
				'shipping_state'	=>	$inputControl['shipping_state'],
				'shipping_zip'		=>	$inputControl['shipping_zip'],
				'physician_name'	=>	$inputControl['physician_name'],
				'physician_ph'		=>	$inputControl['physician_ph'],
				'physician_fax'		=>	$inputControl['physician_fax'],
				'physician_address'	=>	$inputControl['physician_address'],
				'height_12'		=>	$inputControl['height_12'],
				'weight_12'		=>	$inputControl['weight_12'],
				'birth_day'		=>	$inputControl['birth_day'],
				'birth_month'		=>	$inputControl['birth_month'],
				'birth_year'		=>	$inputControl['birth_year'],
				'are_smoker'		=>	$inputControl['are_smoker'],
				'are_breastfeeding'	=>	$inputControl['are_breastfeeding'],
				'are_pregnant'		=>	$inputControl['are_pregnant'],
				'due_day'		=>	$inputControl['due_day'],
				'due_month'		=>	$inputControl['due_month'],
				'due_year'		=>	$inputControl['due_year'],
				'sex'			=>	$inputControl['sex'],
				'have_drug_allergies'	=>	$inputControl['have_drug_allergies'],
				'medical_history'		=>	$inputControl['medical_history'],
				'employer_name'		=>	$inputControl['employer_name'],
				'division'			=>	$inputControl['division'],
				'emp_relation'		=>	$inputControl['emp_relation'],
				'rem_notification'	=>	$inputControl['rem_notification'],
				'prescription'		=>	$inputControl['prescription'],
				'signature'			=>	$inputControl['signature'],
				'submit_day'		=>	$inputControl['submit_day'],
				'submit_month'		=>	$inputControl['submit_month'],
				'submit_year'		=>	$inputControl['submit_year'],
				'id'				=>	$order_id,
				'status'			=>	2
			];


			$sql = "UPDATE rx_medical_orders SET first_name=:first_name, last_name=:last_name, home_phone_no=:home_phone_no,mobile_phone_no=:mobile_phone_no,email=:email,shipping_address_1=:shipping_address_1,shipping_address_2=:shipping_address_2,shipping_city=:shipping_city,shipping_state=:shipping_state,shipping_zip=:shipping_zip,physician_name=:physician_name,physician_ph=:physician_ph,physician_fax=:physician_fax,physician_address=:physician_address,height_12=:height_12,weight_12=:weight_12,birth_day=:birth_day,birth_month=:birth_month,birth_year=:birth_year,are_smoker=:are_smoker,are_breastfeeding=:are_breastfeeding,are_pregnant=:are_pregnant,due_day=:due_day,due_month=:due_month,due_year=:due_year,sex=:sex,have_drug_allergies=:have_drug_allergies,medical_history=:medical_history,employer_name=:employer_name,division=:division,emp_relation=:emp_relation,rem_notification=:rem_notification,prescription=:prescription,signature=:signature,submit_day=:submit_day,submit_month=:submit_month,submit_year=:submit_year,status=:status WHERE id=:id";

			/** @var PDO $pdo */
			$success 		= 	$db->prepare($sql)->execute($row);

			if($success){

				
				//delete existing order details
				$stmt = $db->prepare('DELETE from rx_medical_order_items 
				WHERE order_id=:id');
				$stmt->bindParam('id', $order_id);
				$stmt->execute();
				
				$order_count	=	count($order_items);
				if($order_count > 0){
					foreach($order_items as $item){

						$row = [
							'order_id' 	=> 	$order_id,
							'medication_name' 		=> 	$item['medication_name'],
							'medication_strength'	=>	$item['medication_strength'],
							'medication_no'			=>	$item['medication_no'],
							'new_medication'		=>	$item['new_medication'],
							'maintenance_drug'		=>	$item['maintenance_drug'],
							'auto_refil'			=>	$item['auto_refil'],
							'status'				=>	1
						];
						$sql	=	"INSERT INTO rx_medical_order_items SET order_id=:order_id,medication_name=:medication_name,medication_strength=:medication_strength,medication_no=:medication_no,new_medication=:new_medication,maintenance_drug=:maintenance_drug,auto_refil=:auto_refil,status=:status;";

						$success_1	= 	$db->prepare($sql)->execute($row);
						
						
//						if($item['id'] > 0){
//							$row = [
//								'medication_name' 		=> 	$item['medication_name'],
//								'medication_strength'	=>	$item['medication_strength'],
//								'medication_no'			=>	$item['medication_no'],
//								'new_medication'		=>	$item['new_medication'],
//								'maintenance_drug'		=>	$item['maintenance_drug'],
//								'auto_refil'			=>	$item['auto_refil'],
//								'id'					=>	$item['id']
//							];
//							$sql	=	"UPDATE rx_medical_order_items SET medication_name=:medication_name,medication_strength=:medication_strength,medication_no=:medication_no,new_medication=:new_medication,maintenance_drug=:maintenance_drug,auto_refil=:auto_refil WHERE id=:id";
//
//							$success_1		= 	$db->prepare($sql)->execute($row);
//						}
//						else{
//							$row = [
//								'order_id' 	=> 	$order_id,
//								'medication_name' 		=> 	$item['medication_name'],
//								'medication_strength'	=>	$item['medication_strength'],
//								'medication_no'			=>	$item['medication_no'],
//								'new_medication'		=>	$item['new_medication'],
//								'maintenance_drug'		=>	$item['maintenance_drug'],
//								'auto_refil'			=>	$item['auto_refil'],
//								'status'				=>	1
//							];
//							$sql	=	"INSERT INTO rx_medical_order_items SET order_id=:order_id,medication_name=:medication_name,medication_strength=:medication_strength,medication_no=:medication_no,new_medication=:new_medication,maintenance_drug=:maintenance_drug,auto_refil=:auto_refil,status=:status;";
//
//							$success_11		= 	$db->prepare($sql)->execute($row);
//						}
					}
				}
				else{
				    $success_1	=  true;
				}
				
				
				
				//delete existing medications
				$stmt = $db->prepare('DELETE from rx_medication_items 
				WHERE order_id=:id');
				$stmt->bindParam('id', $order_id);
				$stmt->execute();

				$medication_count	=	count($medication_items);
				if($medication_count > 0){
					foreach($medication_items as $medication){
						
						$row = [
							'order_id' 		=> 	$order_id,
							'cur_medication_name' 		=> 	$medication['cur_medication_name'],
							'cur_medication_strength'	=>	$medication['cur_medication_strength'],
							'cur_medication_count'		=>	$medication['cur_medication_count'],
							'cur_medication_long'		=>	$medication['cur_medication_long'],
							'cur_medication_illness'	=>	$medication['cur_medication_illness'],
							'status'					=>	1
						];
						$sql	=	"INSERT INTO rx_medication_items SET order_id=:order_id,cur_medication_name=:cur_medication_name,cur_medication_strength=:cur_medication_strength,cur_medication_count=:cur_medication_count,cur_medication_long=:cur_medication_long,cur_medication_illness=:cur_medication_illness,status=:status;";

						$success_2	= 	$db->prepare($sql)->execute($row);
						
						
//						if($medication['id'] > 0){
//							$row = [
//								'cur_medication_name' 		=> 	$medication['cur_medication_name'],
//								'cur_medication_strength'	=>	$medication['cur_medication_strength'],
//								'cur_medication_count'		=>	$medication['cur_medication_count'],
//								'cur_medication_long'		=>	$medication['cur_medication_long'],
//								'cur_medication_illness'	=>	$medication['cur_medication_illness'],
//								'id'						=>	$medication['id']
//							];
//							$sql	=	"UPDATE rx_medication_items SET cur_medication_name=:cur_medication_name,cur_medication_strength=:cur_medication_strength,cur_medication_count=:cur_medication_count,cur_medication_long=:cur_medication_long,cur_medication_illness=:cur_medication_illness WHERE id=:id";
//
//							$success_2		= 	$db->prepare($sql)->execute($row);
//						}
//						else{
//							$row = [
//								'order_id' 		=> 	$order_id,
//								'cur_medication_name' 		=> 	$medication['cur_medication_name'],
//								'cur_medication_strength'	=>	$medication['cur_medication_strength'],
//								'cur_medication_count'		=>	$medication['cur_medication_count'],
//								'cur_medication_long'		=>	$medication['cur_medication_long'],
//								'cur_medication_illness'	=>	$medication['cur_medication_illness'],
//								'status'					=>	1
//							];
//							$sql	=	"INSERT INTO rx_medication_items SET order_id=:order_id,cur_medication_name=:cur_medication_name,cur_medication_strength=:cur_medication_strength,cur_medication_count=:cur_medication_count,cur_medication_long=:cur_medication_long,cur_medication_illness=:cur_medication_illness,status=:status;";
//
//							$success_22		= 	$db->prepare($sql)->execute($row);
//						}
					}
				}
				else{
				    $success_2	= true;
				}
			}

			if($success && $success_1  && $success_2 ){
				
				$order_items		=	$inputControl['order_items'];
				$medication_items	=	$inputControl['medication_items'];

				$order_med_name	=	$order_med_strength = $order_med_no = $order_new_med = $order_maintenance_drug = $order_auto_refil = 	'';
				$cur_med_name	= $cur_med_strength	= $cur_med_count	= $cur_med_long	= $cur_illness = '';

				$order_count	=	count($order_items);
				if($order_count > 0){
					$order_loop_count	=	0;
					foreach($order_items as $item){
						$delimiter	=	($order_loop_count > 0)?'|':'';
						$order_med_name	.= $delimiter.$item['medication_name'];
						$order_med_strength	.= $delimiter.$item['medication_strength'];
						$order_med_no	.= $delimiter.$item['medication_no'];
						$order_new_med	.= $delimiter.$item['new_medication'];
						$order_maintenance_drug	.= $delimiter.$item['maintenance_drug'];
						$order_auto_refil	.= $delimiter.$item['auto_refil'];
						$order_loop_count++;
					}
				}

				$medication_count	=	count($medication_items);
				if($medication_count > 0){
					$medication_loop_count	=	0;
					foreach($medication_items as $medication){
						$delimiter	=	($medication_loop_count > 0)?'|':'';
						$cur_med_name	.= $delimiter.$medication['cur_medication_name'];
						$cur_med_strength	.= $delimiter.$medication['cur_medication_strength'];
						$cur_med_count	.= $delimiter.$medication['cur_medication_count'];
						$cur_med_long	.= $delimiter.$medication['cur_medication_long'];
						$cur_illness	.= $delimiter.$medication['cur_medication_illness']; 
						$medication_loop_count++;
					}
				}




				$relationship = array(
					'employee' => 'Employee / Self',
					'spouse' => 'Spouse / Partner', 
					'dependant' => 'Dependant'
				);
				$notification = array(
					'home-phone' => 'Home phone',
					'mobile-phone' => 'Mobile phone', 
					'email' => 'Email'
				);
				$prescriptions =	array(
					'attached' => 'Upload the script files',
					'fax' => 'I will arrange for my doctor to fax my prescription(s) to (858) 779-2537.', 
					'request' => 'Please fax my doctor to request a copy of my prescription(s)'
				);
				/*.............Active campign Start..................*/

				$url = 'https://rxtoyou.api-us1.com';
				$key='d23525f33c29a6eddfe6e38ef4bf1c0bd82fe710de0d40d96115afafe3923f0fc3175c54';

				$params = array(  
					'api_key'      => $key, 
					'api_action'   => 'contact_sync',
					'api_output'   => 'serialize',
				);

				// here we define the data we are posting in order to perform an update
				$post = array(

					'email'                    => $inputControl['email'],
					'first_name'               => $inputControl['first_name'],
					'last_name'                => $inputControl['last_name'],
					'phone'                    => $inputControl['home_phone_no'],


					// 'form'          => $formid, // Subscription Form ID, to inherit those redirection settings

					'field[%MOBILE_PHONE%,0]' 	=> 	$inputControl['mobile_phone_no'],
					'field[%SHIPPING_ADDRESS_LINE_1%,0]' 		=>	$inputControl['shipping_address_1'],
					'field[%SHIPPING_ADDRESS_LINE_2%,0]' 		=>	$inputControl['shipping_address_2'],
					'field[%SHIPPING_ADDRESS_CITY%,0]' 		=>	$inputControl['shipping_city'],
					'field[%SHIPPING_ADDRESS_STATE%,0]' 		=>	$inputControl['shipping_state'],
					'field[%SHIPPING_ADDRESS_ZIP%,0]' 		=>	$inputControl['shipping_zip'],
					'field[%PRESCRIBING_PHYSICIAN_NAME%,0]' 		=>	$inputControl['physician_name'],
					'field[%PHYSICIAN_PHONE_NUMBER%,0]' 		=>	$inputControl['physician_ph'],
					'field[%PHYSICIAN_FAX_NUMBER%,0]' 		=>	$inputControl['physician_fax'],
					'field[%PHYSICIAN_ADDRESS%,0]' 		=>	$inputControl['physician_address'],
					'field[%HEIGHT%,0]' 		=>	$inputControl['height_12'],
					'field[%WEIGHT%,0]' 		=>	$inputControl['weight_12'],
					'field[%DATE_OF_BIRTH%,0]' 		=>	$inputControl['birth_month'].'/'.$inputControl['birth_day'].'/'.$inputControl['birth_year'],
					'field[%ARE_A_SMOKER%,0]' 		=>	$inputControl['are_smoker'],
					'field[%ARE_BREASTFEEDING%,0]' 		=>	$inputControl['are_breastfeeding'],
					'field[%ARE_PREGNANT%,0]' 		=>	$inputControl['are_pregnant'],
					'field[%DUE_DATE%,0]' 		=>		$inputControl['due_month'].'/'.$inputControl['due_day'].'/'.$inputControl['due_year'],
					'field[%SEX%,0]' 		=>	$inputControl['sex'],
					'field[%DRUG_ALLERGIES%,0]' 		=>	$inputControl['have_drug_allergies'],
					'field[%MEDICAL_HISTORY%,0]' 		=>	$inputControl['medical_history'],
					'field[%NAME_OF_EMPLOYER_GROUP%,0]' 		=>	$inputControl['employer_name'],
					'field[%DIVISION%,0]' 		=>	$inputControl['division'],
					'field[%RELATIONSHIP_TO_EMPLOYER%,0]' 		=>	$relationship[$inputControl['emp_relation']],
					'field[%REFILL_REMINDER_NOTIFICATION_PREFERENCE%,0]' 	=>	$notification[$inputControl['rem_notification']],
					'field[%ORDER_MEDICATION_NAME%,0]' 		=>	$order_med_name,
					'field[%ORDER_MEDICATION_STRENGTH%,0]' 		=>	$order_med_strength,
					'field[%ORDER_HOW_MANY_PER_DAY%,0]' 		=>	$order_med_no,
					'field[%ORDER_NEW_MEDICATION%,0]' 		=>	$order_new_med,
					'field[%ORDER_MAINTENANCE_DRUG%,0]' 		=>	$order_maintenance_drug,
					'field[%ORDERAUTO_REFILL%,0]' 		=>	$order_auto_refil,
					'field[%CURRENT_MEDICATION_NAME%,0]' 		=>	$cur_med_name,
					'field[%CURRENT_MEDICATION_STRENGTH%,0]' 		=>	$cur_med_strength,
					'field[%CURRENT_MEDICATION_HOW_MANY_PER_DAY%,0]' 		=>	$cur_med_count,
					'field[%CURRENT_MEDICATION_HOW_LONG_TAKEN_FOR%,0]' 		=>	$cur_med_long,
					'field[%ILLNESS_OR_CONDITION%,0]' 		=>	$cur_illness,
					'field[%SIGNATURE%,0]' 		=>	$inputControl['signature'],
					'field[%SIGNATURE_DATE%,0]' 		=>	$inputControl['submit_month'].'/'.$inputControl['submit_day'].'/'.$inputControl['submit_year'],
					'field[%TRACKING_NUMBERS%,0]'	=> $inputControl['tracking_no'],
					'field[%SUBMISSION_NUMBER%,0]'	=>	$order_id, 
					'field[%SCRIPT_RECEIVED%,0]' =>	'No',


					'p[4]'                   => 4, // example list ID (REPLACE '123' WITH ACTUAL LIST ID, IE: p[5] = 5)
					'status[4]'              => 1, // 1: active, 2: unsubscribed (REPLACE '123' WITH ACTUAL LIST ID, IE: status[5] = 1)
				);

				// This section takes the input fields and converts them to the proper format

				$query = "";

				foreach( $params as $key => $value ) $query .= urlencode($key) . '=' . urlencode($value) . '&';

				$query = rtrim($query, '& ');

				$data = "";

				foreach( $post as $key => $value ) $data .= urlencode($key) . '=' . urlencode($value) . '&';

				$data = rtrim($data, '& ');


				$url = rtrim($url, '/ ');

				if ( !function_exists('curl_init') ) die('CURL not supported. (introduced in PHP 4.0.2)');


				if ( $params['api_output'] == 'json' && !function_exists('json_decode') ) {

					die('JSON not supported. (introduced in PHP 5.2.0)');

				}

				$api = $url . '/admin/api.php?' . $query;

				$request = curl_init($api); // initiate curl object

				curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response

				curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)

				curl_setopt($request, CURLOPT_POSTFIELDS, $data); // use HTTP POST to send form data

				curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);


				$response = (string)curl_exec($request); 

				curl_close($request); 


				if ( !$response ) {

					die('Nothing was returned. Do you have a connection to Email Marketing server?');

				}

				$result = unserialize($response);


			   /*.............Active campign end..................*/
				
				
				return $this->response->withJson(array(
					'status' 	=> 'success',
					'message'	=>	'Order details updated successfully.'
				));
			}
			else if($success){
				return $this->response->withJson(array(
					'status' 	=> 'error',
					'message'	=>	'Order details updation could not be completed. Please contact the service provider.'
				));
			}
			else{
				return $this->response->withJson(array(
					'status' 	=> 'error',
					'message'	=>	'An error occured. Try again later.'
				));
			}
		}
		else{
			return $this->response->withJson(array(
				'status' 	=> 'error',
				'message'	=>	'You cannot edit this order.'
			));
		}
		
    } catch (PDOException $e) {
        return $this->response->withJson($e);
    }
});


//updating user edit request on orders
$app->post('/user/updateOrderEditStatus', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$id			=	$inputControl['order_id'];
	$status		=	$inputControl['action'];
	$message	=	'';
	switch($status){
		case 1	:	$message	=	'Order edit request sent to admin.';
					break;
		case 0	:	$message	=	'Order edit request changed.';
					break;
	}
	
	$flag		=	'';
    try {
		$db = new db();
		$db = $db->connect();
		$db->query("SET  CHARACTER SET utf8;");
		$row = [
			'status'		=>	$status,
			'id'			=>	$id
		];
		$sql = "UPDATE rx_medical_orders SET req_status=:status WHERE id=:id ";
		/** @var PDO $pdo */
		$success 	= 	$db->prepare($sql)->execute($row);
		$db	=	null;	
	
		if($success){
			$flag	=	'success';
			$result['msg']	=	$message;
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'An error occured. Try again later.' ;
		}
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


//check unique key existing for fileupload
//admin
//patient
$app->post('/user/checkKey', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
   	$key	=	$inputControl['unique_key'];
	try {
		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$keyQuerry = $db->prepare('SELECT id from rx_medical_orders WHERE unique_key=:unique_key');
		$keyQuerry->bindParam('unique_key',$key);
		$keyQuerry->execute();
		$keyList = $keyQuerry->fetchAll(PDO::FETCH_OBJ);
		
		if(count($keyList) > 0){
			return $this->response->withJson(array(
				'status' 	=> 'success',
				'message'	=>	'Valid Key'
			));
		}
		else{
			return $this->response->withJson(array(
				'status' 	=> 'error',
				'message'	=>	'Sorry, your request cannot be processed due to invalid url.'
			));
		}
		
    } catch (PDOException $e) {
        return $this->response->withJson($e);
    }
    //return $this->response->withJson($ouput);
});


//remove patient orders file
//admin
//patient
$app->post('/user/removeOrderFile', function(Request $request, Response $response) {
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson(array(
			'status' 	=>  'error',
			'message'	=>	'Invalid Request'
		));
	}
	$inputControl	= 	$request->getParsedBody();
	$order_file_id	=	$inputControl['order_file_id'];
	
	$status		=	1;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$file_query = $db->prepare('SELECT file_name from rx_media_files WHERE id=:id');
		$file_query->bindParam('id',$order_file_id);
		$file_query->execute();
		$file_array = $file_query->fetch(PDO::FETCH_OBJ);
		if($file_array){
			unlink('../../hw-uploads/medication-files/'.$file_array->file_name);
		}
		
		
		$stmt = $db->prepare('DELETE from rx_media_files 
		WHERE id=:id');
		$stmt->bindParam('id', $order_file_id);
		$stmt->execute();
      	
		$db = null;
		 
		if($stmt->rowCount() > 0){
			$flag	=	'success';
			$result['msg']	=	'Yoy have successfully removed 1 file.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'An error occured while deleting file.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});



//list patient orders files
//admin
//patient
$app->post('/user/getOrderFiles', function(Request $request, Response $response) {
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson(array(
			'status' 	=>  'error',
			'message'	=>	'Invalid Request'
		));
	}
	$inputControl	= 	$request->getParsedBody();
	$order_id	=	$inputControl['order_id'];
	
	$status		=	1;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT rxmf.id,
		rxmf.file_name
		from rx_media_files rxmf
		WHERE rxmf.relation_id=:order_id AND rxmf.status=:status');
		$stmt->bindParam('order_id', $order_id);
		$stmt->bindParam('status', $status);
		$stmt->execute();
		$orders = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($orders) > 0){
			$flag	=	'success';
			$result['details']	=	$orders;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No files found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


//remove order items
//admin
$app->post('/user/removeOrderItem', function(Request $request, Response $response) {
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson(array(
			'status' 	=>  'error',
			'message'	=>	'Invalid Request'
		));
	}
	$inputControl	= 	$request->getParsedBody();
	$order_item_id	=	$inputControl['order_item_id'];
	
	$status		=	1;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		$stmt = $db->prepare('DELETE from rx_medical_order_items 
		WHERE id=:id');
		$stmt->bindParam('id', $order_item_id);
		$stmt->execute(); 
      	
		$db = null;
		 
		if($stmt->rowCount() > 0){
			$flag	=	'success';
			$result['msg']	=	'Yoy have successfully removed an order item.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'An error occured while deleting order item.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});



//remove current medications
//admin
$app->post('/user/removeCurretMedication', function(Request $request, Response $response) {
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson(array(
			'status' 	=>  'error',
			'message'	=>	'Invalid Request'
		));
	}
	$inputControl	= 	$request->getParsedBody();
	$medication_id	=	$inputControl['medication_id'];
	
	$status		=	1;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		$stmt = $db->prepare('DELETE from rx_medication_items 
		WHERE id=:id');
		$stmt->bindParam('id', $medication_id);
		$stmt->execute();
      	
		$db = null;
		 
		if($stmt->rowCount() > 0){
			$flag	=	'success';
			$result['msg']	=	'Yoy have successfully removed a medication item.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'An error occured while deleting medication item.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


$app->post('/user/checkPatientsUnderPlan', function(Request $request, Response $response) {
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson(array(
			'status' 	=>  'error',
			'message'	=>	'Invalid Request'
		));
	}
	$inputControl	= 	$request->getParsedBody();
	$plan_id	=	$inputControl['group_id'];
	$flag = checkPatientsUnderPlan($plan_id);
	return $this->response->withJson(array(
		'status' 	=> 	$flag
	));
});


function checkPatientsUnderPlan($plan_id){
	$status1 = 1;
	$status2 = 2;
	try {
		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT rx_patients.id from rx_patients INNER JOIN rx_users ON rx_patients.user_id=rx_users.id WHERE (rx_users.status=:status1 OR rx_users.status=:status2) AND rx_patients.group_id=:group_id');
		$stmt->bindParam('status1',$status1);
		$stmt->bindParam('status2',$status2);
		$stmt->bindParam('group_id',$plan_id);
		$stmt->execute();
		$users = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($users) > 0){
			return true;
		}
		else{
			return false;
		}	
		
    } catch (PDOException $e) {
        return true;
    }
}


function checkUserExistbyID($user_id){
	   try {
		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT * from rx_users WHERE id=:user_id');
		$stmt->bindParam('user_id',$user_id);
		$stmt->execute();
		$users = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($users) > 0){
			return true;
		}
		else{
			return false;
		}	
		
    } catch (PDOException $e) {
        return true;
    }
}


function checkOrderstatusEditablebyID($order_id){
   try {
		$db = new db();
		$db = $db->connect();
		
		$order_query = $db->prepare('SELECT status from rx_medical_orders WHERE id=:id');
		$order_query->bindParam('id',$order_id);
		$order_query->execute();
		$order_array = $order_query->fetch(PDO::FETCH_OBJ);
      
		   
		$db = null;
		 
		if(isset($order_array)){
			if($order_array->status == 1){
				return true;
			}
			else{
				return false;
			}
		}
		else{
			return false;
		}	
		
    } catch (PDOException $e) {
        return false;
    }
}


function getCompnayIdBySlug($slug){
	try {
		$db = new db();
		$db = $db->connect();
	
		$company_query = $db->prepare('SELECT id from rx_partner_companies WHERE slug=:slug'); 
		$company_query->bindParam('slug',$slug);
		$company_query->execute();
		$company_array = $company_query->fetch(PDO::FETCH_OBJ);
		if($company_array)
			return $company_array->id;
		else return 0;
	}
	catch (PDOException $e) {
        return false;
    }
}


function getCompanyIdbyPatient($patient_user_id){
	try {
		$db = new db();
		$db = $db->connect();
	
		$company_query = $db->prepare('SELECT company_id from rx_groups LEFT JOIN rx_patients ON rx_groups.id=rx_patients.group_id WHERE rx_patients.user_id=:patient_user_id'); 
		$company_query->bindParam('patient_user_id',$patient_user_id);
		$company_query->execute();
		$company_array = $company_query->fetch(PDO::FETCH_OBJ);
		if($company_array)
			return $company_array->company_id;
		else return 0;
	}
	catch (PDOException $e) {
        return false;
    }
}


function chackPartnerCompanyActivebyUserId($id){
	try {
		$db = new db();
		$db = $db->connect();
		$status = 1;
		
		$query = $db->prepare('SELECT rx_pc.id from rx_partner_companies rx_pc LEFT JOIN rx_partners rx_pr ON rx_pc.id = rx_pr.company_id WHERE rx_pr.user_id=:id AND rx_pc.status=:status');
		$query->bindParam('id',$id);
		$query->bindParam('status',$status);
		$query->execute();
		$active_com = $query->fetchAll(PDO::FETCH_OBJ);

		$db = null;
		if(count($active_com) > 0){
			return true;
		}
		else{
			return false;
		}	
	}
	catch (PDOException $e) {
        return false;
    }
}


?>
