<?php

use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use \Firebase\JWT\JWT;

//Common function
$app->post('/partner/invitePatient', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	
	$name			=	$inputControl['name'];
   	$user_group		=	$inputControl['user_group'];
	$email			=	$inputControl['email'];
	$partner_id		=	$inputControl['partner_id'];
	
	
	$status		=	1;
	$flag		=	'';
	
	if(!checkUserExist($email)){
		try {

			$db = new db();
			$db = $db->connect();

			$db->query("SET  CHARACTER SET utf8;");

			
			$permitted_chars = 'abcdefghijklmnopqrstuvwxyz';
			$sub_chars	= substr(str_shuffle($permitted_chars), 0, 10);
			
			$password = $sub_chars;
			
			$row_1 = [
				'username' 		=> 	$email,
				'password' 		=> 	md5($password ),
				'role'			=>	'patient',
				'status'		=>	$status
			];
			$sql_1 = "INSERT INTO rx_users SET username=:username,password=:password,role=:role,status=:status";

			/** @var PDO $pdo */
			$success_1 	= 	$db->prepare($sql_1)->execute($row_1);
			$user_id 	= 	$db->lastInsertId();

			if($user_id){
				$status_2	=	2;
				$row = [
					'user_id' 		=> 	$user_id,
					'group_id' 		=> 	$user_group,
					'first_name' 	=> 	$name,
					'email' 		=> 	$email,
					'invited_by'	=>	$partner_id,
					'status'		=>	$status_2
				];

				$sql = "INSERT INTO rx_patients SET user_id=:user_id,group_id=:group_id,first_name=:first_name,email=:email,invited_by=:invited_by,status=:status";

				/** @var PDO $pdo */ 
				$success 		= 	$db->prepare($sql)->execute($row);
				$patient_id 	= 	$db->lastInsertId();

				if($patient_id){

					/*.............Active campign Start..................*/

					$url = 'https://rxtoyou.api-us1.com';
					$key='d23525f33c29a6eddfe6e38ef4bf1c0bd82fe710de0d40d96115afafe3923f0fc3175c54';

					$params = array(  
						'api_key'      => $key, 
						'api_action'   => 'contact_sync',
						'api_output'   => 'serialize',
					);

					// here we define the data we are posting in order to perform an update
					$post = array(
						'email'                    => $email,
						'first_name'               => $name,
						// 'form'          => $formid, // Subscription Form ID, to inherit those redirection settings
						'field[%SITE_PASSWORD%,0]' 	=>	$password,
						'field[%USER_GROUP_ID%,0]' 	=>	$user_group,
						
						'p[3]'                   => 4, // example list ID (REPLACE '123' WITH ACTUAL LIST ID, IE: p[5] = 5)
						'status[3]'              => 1, // 1: active, 2: unsubscribed (REPLACE '123' WITH ACTUAL LIST 
					);


					$query = "";

					foreach( $params as $key => $value ) $query .= urlencode($key) . '=' . urlencode($value) . '&';
					$query = rtrim($query, '& ');

					$data = "";

					foreach( $post as $key => $value ) $data .= urlencode($key) . '=' . urlencode($value) . '&';
					$data = rtrim($data, '& ');



					// clean up the url
					$url = rtrim($url, '/ ');


					if ( !function_exists('curl_init') ) die('CURL not supported. (introduced in PHP 4.0.2)');


					if ( $params['api_output'] == 'json' && !function_exists('json_decode') ) {
						die('JSON not supported. (introduced in PHP 5.2.0)');
					}

					$api = $url . '/admin/api.php?' . $query;


					$request = curl_init($api); // initiate curl object

					curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response

					curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)

					curl_setopt($request, CURLOPT_POSTFIELDS, $data); // use HTTP POST to send form data

					//curl_setopt($request, CURLOPT_SSL_VERIFYPEER, FALSE); // uncomment if you get no gateway response and are using HTTPS

					curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);



					$response = (string)curl_exec($request); // execute curl post and store results in $response



					// additional options may be required depending upon your server configuration

					// you can find documentation on curl options at http://www.php.net/curl_setopt

					curl_close($request); // close curl object



					if ( !$response ) {

						die('Nothing was returned. Do you have a connection to Email Marketing server?');

					}



					// This line takes the response and breaks it into an array using:

					// JSON decoder

					//$result = json_decode($response);

					// unserializer

					$result = unserialize($response);


				   /*.............Active campign end..................*/


					$flag	=	'success';
					$result['msg']	=	"Successfully invited patient to the partner's plan.";



				}
				else{
					$flag	=	'error';
					$result['msg']	=	'An error occured. Try again later.';
				}
			}
			else{
				$flag	=	'error';
				$result['msg']	=	'An error occured. Try again later.';
			}

			return $this->response->withJson(array(
				'status' 	=> 	$flag,
				'message'	=>	$result 
			));


		} catch (PDOException $e) {
			return $this->response->withJson(array(
				'status' 	=> 	'error',
				'message'	=>	$e
			));
		}
	}
	else{
		$result['msg']	=	'Email already exist.';
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$result 
		));
	}
});

//from partner - list patients of various groups under logged in partner
$app->post('/partner/listInvitedPatients', function(Request $request, Response $response) {

	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson(array(
			'status' 	=>  'error',
			'message'	=>	'Invalid Request'
		));
	}
	
	$inputControl 	= 	$request->getParsedBody();
	$user_id		=	$inputControl['user_id'];
	
	$response = array();
	if(checkPartnerStatus($user_id) && chackPartnerCompanyActivebyUserId($user_id)){
		$type			=	'partner_patient';
		$status			=	1;

		$flag		=	'';
		try {

			$db = new db();
			$db = $db->connect();

			$db->query("SET  CHARACTER SET utf8;");

			$stmt = $db->prepare('SELECT
			rx_patients.user_id,
			rx_patients.first_name,
			rx_patients.last_name,
			rx_groups.name,
			rx_users.username,
			rx_users.status 
			from rx_patients 
			LEFT JOIN rx_users ON (rx_patients.user_id=rx_users.id) 
			LEFT JOIN rx_groups ON (rx_patients.group_id=rx_groups.id)
			LEFT JOIN rx_partner_companies ON (rx_partner_companies.id=rx_groups.company_id)
			LEFT JOIN rx_partners ON (rx_partners.company_id=rx_partner_companies.id)
			WHERE rx_partners.user_id=:user_id AND (rx_users.status=:status)ORDER BY rx_patients.id DESC');
			$stmt->bindParam('user_id', $user_id);
			$stmt->bindParam('status', $status);
			$stmt->execute();
			$orders = $stmt->fetchAll(PDO::FETCH_OBJ);

			$db = null;
		 
			if(count($orders) > 0){
				$response['status'] = 1;
				$response['msg'] = 'Success.';
				$response['details'] = $orders;
			}
			else{	
				$response['status'] = 0;
				$response['msg'] = 'No Patients found.';
			}
		
    	} catch (PDOException $e) {
			$response['status'] = 0;
			$response['msg'] = $e;
		}
	}
	else{
		$response['status'] = 2;
		$response['msg'] = 'You have no permission to access this right now. Please contact administrator.';
	}
	return $this->response->withJson(array(
		'data' 	=> 	$response
	));
		   
});


//list patient orders using patient's user_id
$app->post('/partner/listpatientorders', function(Request $request, Response $response) {
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson(array(
			'status' 	=>  'error',
			'message'	=>	'Invalid Request'
		));
	}
	$inputControl	= 	$request->getParsedBody();
	$patient_user_id	=	$inputControl['patient_user_id'];
	$partner_user_id	=	$inputControl['partner_user_id'];
	
	
	if(checkPartientPartnerRelation($patient_user_id,$partner_user_id)){
	
		$status		=	0;
		$flag		=	'';
		try {

			$db = new db();
			$db = $db->connect();

			$db->query("SET  CHARACTER SET utf8;");

			$stmt = $db->prepare('SELECT rxmo.id,
			first_name,
			email,
			home_phone_no,
			physician_name,
			type,
			rxmo.order_date,
			rxmo.status,
			rxmo.req_status,
			rxos.status_text,
			GROUP_CONCAT(medication_name) medication_name
			from rx_medical_orders rxmo
			LEFT JOIN rx_order_statuses rxos ON (rxos.id = rxmo.status)
			LEFT JOIN rx_medical_order_items rxmoi ON (rxmo.id = rxmoi.order_id)
			WHERE user_id=:user_id AND rxmo.status!=:status GROUP BY rxmo.id ORDER BY rxmo.id DESC');
			$stmt->bindParam('user_id', $patient_user_id);
			$stmt->bindParam('status', $status);
			$stmt->execute();
			$orders = $stmt->fetchAll(PDO::FETCH_OBJ);

			$db = null;

			if(count($orders) > 0){
				$flag	=	'success';
				$result['details']	=	$orders;
				$result['msg']	=	'Success.';
			}
			else{
				$flag	=	'error';
				$result['msg']	=	'No orders found.';
			}

			return $this->response->withJson(array(
				'status' 	=> 	$flag,
				'message'	=>	$result 
			));


		} catch (PDOException $e) {
			return $this->response->withJson(array(
				'status' 	=> 	'error',
				'message'	=>	$e
			));
		}
	}
	else{
		$result['msg']	=	'This patient is not belongs to you.';
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$result
		));
	}
});


//get order details of invited patients
$app->post('/partner/getorderdetails', function(Request $request, Response $response) {
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson(array(
			'status' 	=>  'error',
			'message'	=>	'Invalid Request'
		));
	}
	
	
	$inputControl 	= $request->getParsedBody();
	$order_id		=	$inputControl['order_id'];
	$partner_user_id		=	$inputControl['partner_user_id'];
	
	$order_items	=	$medication_items = array();
	$status		=	1;
	$flag		=	'';
	$partner_id	=	$license_no	=	0;
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT rxmo.*,rxos.status_text from rx_medical_orders rxmo
		LEFT JOIN rx_order_statuses rxos ON (rxmo.status = rxos.id)
		LEFT JOIN rx_patients rxpt ON (rxpt.user_id = rxmo.user_id)
		LEFT JOIN rx_groups rxgp ON (rxgp.id = rxpt.group_id)
		LEFT JOIN rx_partner_companies rxpc ON (rxpc.id = rxgp.company_id)
		LEFT JOIN rx_partners rxpr ON (rxpr.company_id = rxpc.id)
		WHERE rxmo.id=:id AND rxpr.user_id=:partner_user_id ');
		$stmt->bindParam('id', $order_id);
		$stmt->bindParam('partner_user_id', $partner_user_id);
		$stmt->execute();
		$orders = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		if(count($orders) > 0){
			$flag	=	'success';
			$result['msg']	=	'Success.';
			
			$result['type'] = $orders[0]->type;
	
			$stmt = $db->prepare('SELECT * from rx_medical_order_items WHERE order_id=:id ');
			$stmt->bindParam('id', $order_id);
			$stmt->execute();
			$order_items = $stmt->fetchAll(PDO::FETCH_OBJ);
			
			
			$media_type	=	'medication_files';
			$stmt = $db->prepare('SELECT file_name from rx_media_files WHERE media_type=:media_type AND relation_id=:id ');
			$stmt->bindParam('media_type', $media_type);
			$stmt->bindParam('id', $order_id);
			$stmt->execute();
			$media_items = $stmt->fetchAll(PDO::FETCH_OBJ);
			
			if(count($media_items) > 0){
				$result['media_items']	=	$media_items;
			}
			
			$stmt = $db->prepare('SELECT * from rx_medication_items WHERE order_id=:id ');
			$stmt->bindParam('id', $order_id);
			$stmt->execute();
			$medication_items = $stmt->fetchAll(PDO::FETCH_OBJ);
			 
			$db = null;
			
			$result['details']	=	array(
				'id'			=>	$orders[0]->id,
				'first_name'	=>	$orders[0]->first_name,
				'last_name'		=>	$orders[0]->last_name,
				'home_phone_no'	=>	$orders[0]->home_phone_no,
				'mobile_phone_no'	=>	$orders[0]->mobile_phone_no,
				'email'				=>	$orders[0]->email,
				'shipping_address_1'	=>	$orders[0]->shipping_address_1,
				'shipping_address_2'	=>	$orders[0]->shipping_address_2,
				'shipping_city'			=>	$orders[0]->shipping_city,
				'shipping_state'		=>	$orders[0]->shipping_state,
				'shipping_zip'			=>	$orders[0]->shipping_zip,
				'physician_name'		=>	$orders[0]->physician_name,
				'physician_ph'			=>	$orders[0]->physician_ph,
				'physician_fax'			=>	$orders[0]->physician_fax,
				'physician_address'		=>	$orders[0]->physician_address,
				'height_12'				=>	$orders[0]->height_12,
				'weight_12'				=>	$orders[0]->weight_12,
				'birth_month'			=>	$orders[0]->birth_month,
				'birth_day'				=>	$orders[0]->birth_day,
				'birth_year'			=>	$orders[0]->birth_year,
				'are_smoker'			=>	$orders[0]->are_smoker,
				'are_breastfeeding'		=>	$orders[0]->are_breastfeeding,
				'are_pregnant'			=>	$orders[0]->are_pregnant,
				'due_month'				=>	$orders[0]->due_month,
				'due_day'				=>	$orders[0]->due_day,
				'due_year'				=>	$orders[0]->due_year,
				'sex'					=>	$orders[0]->sex,
				'have_drug_allergies'	=>	$orders[0]->have_drug_allergies,
				'medical_history'		=>	$orders[0]->medical_history,
				'employer_name'			=>	$orders[0]->employer_name,
				'division'				=>	$orders[0]->division,
				'emp_relation'			=>	$orders[0]->emp_relation,
				'rem_notification'		=>	$orders[0]->rem_notification,
				'order_items'			=>	$order_items,
				'prescription'			=> 	$orders[0]->prescription,
				'medication_items'		=>	$medication_items,
				'signature'				=> 	$orders[0]->signature,
				'submit_month'			=> 	$orders[0]->submit_month,
				'submit_day'			=> 	$orders[0]->submit_day,
				'submit_year'			=> 	$orders[0]->submit_year,
				'unique_key'			=> 	$orders[0]->unique_key,
				'tracking_no'			=> 	$orders[0]->tracking_no,
				'status_text'			=> 	$orders[0]->status_text
			);
			$result['order_status']		=	$orders[0]->status;
			
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No details found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {

		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


$app->post('/partner/checkPartientPartnerRelation', function(Request $request, Response $response) {
	$inputControl 	= $request->getParsedBody();
	$patient_user_id		=	$inputControl['patient_user_id'];
	$partner_user_id		=	$inputControl['partner_user_id'];
	$flag =  checkPartientPartnerRelation($patient_user_id,$partner_user_id);
	return $this->response->withJson(array(
		'status' 	=> 	$flag,
	));
});

function checkPartientPartnerRelation($patient_user_id,$partner_user_id){
	
	$status		=	0;
	$flag		=	'';
	try {

		$db = new db();
		$db = $db->connect();

		$db->query("SET  CHARACTER SET utf8;");

		$stmt = $db->prepare('SELECT rxpt.id from rx_patients rxpt
		LEFT JOIN rx_groups rxgp ON (rxpt.group_id = rxgp.id)
		LEFT JOIN rx_partners rxpr ON (rxpr.company_id = rxgp.company_id)
		WHERE rxpt.user_id=:patient_user_id AND rxpr.user_id=:partner_user_id');
		$stmt->bindParam('patient_user_id', $patient_user_id);
		$stmt->bindParam('partner_user_id', $partner_user_id);
		$stmt->execute();
		
		$orders = $stmt->fetchAll(PDO::FETCH_OBJ);
		$db = null;

		if(count($orders) > 0){
			return true;
		}
		else{
			return false;
		}

	} catch (PDOException $e) {
		return false;
	}
}

?>