<?php

use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use \Firebase\JWT\JWT;


//check partner have permission to login
$app->post('/partner/checkPartnerStatus', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$user_id		=	$inputControl['user_id'];
	$res = array();
	if(checkPartnerStatus($user_id) && chackPartnerCompanyActivebyUserId($user_id)){
		$res['status'] = 1;
	}
	else{
		$res['status'] = 0;
		$res['msg'] = 'You have no permission to access this right now. Please contact administrator.';
	}
	return $this->response->withJson(array(
		'data' 	=> 	$res
	));
});



$app->post('/partner/checkLicense', function(Request $request, Response $response) {

    $inputControl = $request->getParsedBody();
   	$license	=	$inputControl['license'];
	$status		=	1;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT * from rx_partners WHERE license_no=:license AND status=:status');
		$stmt->bindParam('license',$license);
		$stmt->bindParam('status', $status);
		$stmt->execute();
		$partners = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($partners) > 0){
			$flag	=	'success';
			$message	=	$partners[0]->id;
		}
		else{
			$flag	=	'error';
			$message	=	'Invalid License Number.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$message 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});

$app->post('/partner/submitOrder', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	
	$order_med_name	=	$order_med_strength = $order_med_no = $order_new_med = $order_maintenance_drug = $order_auto_refil = '';
	$cur_med_name	= $cur_med_strength	= $cur_med_count	= $cur_med_long	= $cur_illness = '';
	
	try {
		$db = new db();
		$db = $db->connect();
		$row = [
			'first_name' 	=> $inputControl['first_name'],
			'last_name' 	=> $inputControl['last_name'],
			'home_phone_no' => $inputControl['home_phone_no'],
			'mobile_phone_no'	=>			$inputControl['mobile_phone_no'],
			'email'				=>	$inputControl['email'],
			'shipping_address_1'		=>	$inputControl['shipping_address_1'],
			'shipping_address_2'		=>	$inputControl['shipping_address_2'],
			'shipping_city'		=>	$inputControl['shipping_city'],
			'shipping_state'	=>	$inputControl['shipping_state'],
			'shipping_zip'		=>	$inputControl['shipping_zip'],
			'physician_name'	=>	$inputControl['prescribing_physician_name'],
			'physician_ph'		=>	$inputControl['physician_ph'],
			'physician_fax'		=>	$inputControl['physician_fax'],
			'physician_address'	=>	$inputControl['physician_address'],
			'height_12'		=>	$inputControl['height_12'],
			'weight_12'		=>	$inputControl['weight_12'],
			'birth_day'		=>	$inputControl['birth_day'],
			'birth_month'		=>	$inputControl['birth_month'],
			'birth_year'		=>	$inputControl['birth_year'],
			'are_smoker'		=>	$inputControl['are_smoker'],
			'are_breastfeeding'	=>	$inputControl['are_breastfeeding'],
			'are_pregnant'		=>	$inputControl['are_pregnant'],
			'due_day'		=>	$inputControl['due_day'],
			'due_month'		=>	$inputControl['due_month'],
			'due_year'		=>	$inputControl['due_year'],
			'sex'			=>	$inputControl['sex'],
			'have_drug_allergies'	=>	$inputControl['have_drug_allergies'],
			'medical_history'		=>	$inputControl['medical_history'],
			'employer_name'		=>	$inputControl['employer_name'],
			'division'			=>	$inputControl['division'],
			'emp_relation'		=>	$inputControl['emp_relation'],
			'rem_notification'	=>	$inputControl['rem_notification'],
			'prescription'		=>	$inputControl['prescription'],
			'signature'			=>	$inputControl['signature'],
			'submit_day'		=>	$inputControl['submit_day'],
			'submit_month'		=>	$inputControl['submit_month'],
			'submit_year'		=>	$inputControl['submit_year'],
			'type'				=>	'partner_patient',
			'partner_id'		=>	$inputControl['partner_id'],
//			'created_at'		=>	date("Y-m-d h:i:sa"),
			'status'			=>	1
		];

		$sql = "INSERT INTO medical_condition SET first_name=:first_name, last_name=:last_name, home_phone_no=:home_phone_no,mobile_phone_no=:mobile_phone_no,email=:email,shipping_address_1=:shipping_address_1,shipping_address_2=:shipping_address_2,shipping_city=:shipping_city,shipping_state=:shipping_state,shipping_zip=:shipping_zip,physician_name=:physician_name,physician_ph=:physician_ph,physician_fax=:physician_fax,physician_address=:physician_address,height_12=:height_12,weight_12=:weight_12,birth_day=:birth_day,birth_month=:birth_month,birth_year=:birth_year,are_smoker=:are_smoker,are_breastfeeding=:are_breastfeeding,are_pregnant=:are_pregnant,due_day=:due_day,due_month=:due_month,due_year=:due_year,sex=:sex,have_drug_allergies=:have_drug_allergies,medical_history=:medical_history,employer_name=:employer_name,division=:division,emp_relation=:emp_relation,rem_notification=:rem_notification,prescription=:prescription,signature=:signature,submit_day=:submit_day,submit_month=:submit_month,submit_year=:submit_year,type=:type,partner_id=:partner_id,created_at=NOW(),status=:status;";

		/** @var PDO $pdo */
		$success 		= 	$db->prepare($sql)->execute($row);
		$medical_condition_id 	= 	$db->lastInsertId();

		
		
		$partnerQuerry = $db->prepare('SELECT license_no,first_name from rx_partners WHERE id=:id');
		$partnerQuerry->bindParam('id',$inputControl['partner_id']);
		$partnerQuerry->execute();
		$partner_details = $partnerQuerry->fetchAll(PDO::FETCH_OBJ);
		
		
		if($medical_condition_id){

			$pass = substr(str_shuffle("0123456789abcdefghijklmnopqrstvwxyz"), 0, 6);
			$unique_key	=	 base64_encode($inputControl['email'].'&'.$medical_condition_id.'&'.$pass);

			$updateQuerry = $db->prepare('UPDATE medical_condition SET unique_key=:unique_key WHERE id=:id');
			$updateQuerry->bindParam('unique_key',$unique_key);
			$updateQuerry->bindParam('id',$medical_condition_id);
			$updateQuerry->execute();


			$order_count	=	count($inputControl['medication_name']);
			if($order_count > 0){
				$order_loop_count	=	0;
				foreach($inputControl['medication_name'] as $key=>$value){
					$delimiter	=	($order_loop_count > 0)?'|':'';
					$order_med_name	.= $delimiter.$inputControl['medication_name'][$key];
					$order_med_strength	.= $delimiter.$inputControl['medication_strength'][$key];
					$order_med_no	.= $delimiter.$inputControl['medication_no'][$key];
					$order_new_med	.= $delimiter.$inputControl['new_medication'][$key];
					$order_maintenance_drug	.= $delimiter.$inputControl['maintenance_drug'][$key];
					$order_auto_refil	.= $delimiter.$inputControl['auto_refil'][$key];
					
					$row = [
						'medical_condition_id' 	=> 	$medical_condition_id,
						'medication_name' 		=> 	$inputControl['medication_name'][$key],
						'medication_strength'	=>	$inputControl['medication_strength'][$key],
						'medication_no'			=>	$inputControl['medication_no'][$key],
						'new_medication'		=>	$inputControl['new_medication'][$key],
						'maintenance_drug'		=>	$inputControl['maintenance_drug'][$key],
						'auto_refil'			=>	$inputControl['auto_refil'][$key],
						'status'				=>	1
					];
					$sql	=	"INSERT INTO medical_order_items SET medical_condition_id=:medical_condition_id,medication_name=:medication_name,medication_strength=:medication_strength,medication_no=:medication_no,new_medication=:new_medication,maintenance_drug=:maintenance_drug,auto_refil=:auto_refil,status=:status;";

					$success_1		= 	$db->prepare($sql)->execute($row);
					$order_loop_count++;
				}
			}
			else{
			    $success_1 = true;
			}
	
			$medication_count	=	count($inputControl['cur_medication_name']);
			if($medication_count > 0){
				$medication_loop_count	=	0;
				foreach($inputControl['cur_medication_name'] as $key=>$value){
					$delimiter	=	($medication_loop_count > 0)?'|':'';
					$cur_med_name	.= $delimiter.$inputControl['cur_medication_name'][$key];
					$cur_med_strength	.= $delimiter.$inputControl['cur_medication_strength'][$key];
					$cur_med_count	.= $delimiter.$inputControl['cur_medication_count'][$key];
					$cur_med_long	.= $delimiter.$inputControl['cur_medication_long'][$key];
					$cur_illness	.= $delimiter.$inputControl['cur_medication_illness'][$key];
					$row = [
						'medical_condition_id' 		=> 	$medical_condition_id,
						'cur_medication_name' 		=> 	$inputControl['cur_medication_name'][$key],
						'cur_medication_strength'	=>	$inputControl['cur_medication_strength'][$key],
						'cur_medication_count'		=>	$inputControl['cur_medication_count'][$key],
						'cur_medication_long'		=>	$inputControl['cur_medication_long'][$key],
						'cur_medication_illness'	=>	$inputControl['cur_medication_illness'][$key],
						'status'					=>	1
					];
					$sql	=	"INSERT INTO medication_items SET medical_condition_id=:medical_condition_id,cur_medication_name=:cur_medication_name,cur_medication_strength=:cur_medication_strength,cur_medication_count=:cur_medication_count,cur_medication_long=:cur_medication_long,cur_medication_illness=:cur_medication_illness,status=:status;";

					$success_2		= 	$db->prepare($sql)->execute($row);
					$medication_loop_count++;
				}
			}
			else{
			    $success_2 = true;
			}
			
			
			
			$relationship = array(
				'employee' => 'Employee / Self',
				'spouse' => 'Spouse / Partner', 
				'dependant' => 'Dependant'
			);
			$notification = array(
			  	'home-phone' => 'Home phone',
				'mobile-phone' => 'Mobile phone', 
				'email' => 'Email'
			);
			$prescriptions =	array(
			  	'attached' => 'Upload the script files',
				'fax' => 'I will arrange for my doctor to fax my prescription(s) to (858) 779-2537.', 
				'request' => 'Please fax my doctor to request a copy of my prescription(s)'
			);
			
			
			
			/*.............Active campign Start..................*/
		
			$url = 'https://rxtoyou.api-us1.com';
			$key='d23525f33c29a6eddfe6e38ef4bf1c0bd82fe710de0d40d96115afafe3923f0fc3175c54';

			$params = array(  
				'api_key'      => $key, 
				'api_action'   => 'contact_sync',
				'api_output'   => 'serialize',
			);

			// here we define the data we are posting in order to perform an update
			$post = array(

				'email'                    => $inputControl['email'],
				'first_name'               => $inputControl['first_name'],
				'last_name'                => $inputControl['last_name'],
				'phone'                    => $inputControl['home_phone_no'],


				// 'form'          => $formid, // Subscription Form ID, to inherit those redirection settings

				'field[%MOBILE_PHONE%,0]' 	=> 	$inputControl['mobile_phone_no'],
				'field[%SHIPPING_ADDRESS_LINE_1%,0]' 		=>	$inputControl['shipping_address_1'],
				'field[%SHIPPING_ADDRESS_LINE_2%,0]' 		=>	$inputControl['shipping_address_2'],
				'field[%SHIPPING_ADDRESS_CITY%,0]' 		=>	$inputControl['shipping_city'],
				'field[%SHIPPING_ADDRESS_STATE%,0]' 		=>	$inputControl['shipping_state'],
				'field[%SHIPPING_ADDRESS_ZIP%,0]' 		=>	$inputControl['shipping_zip'],
				'field[%PRESCRIBING_PHYSICIAN_NAME%,0]' 		=>	$inputControl['prescribing_physician_name'],
				'field[%PHYSICIAN_PHONE_NUMBER%,0]' 		=>	$inputControl['physician_ph'],
				'field[%PHYSICIAN_FAX_NUMBER%,0]' 		=>	$inputControl['physician_fax'],
				'field[%PHYSICIAN_ADDRESS%,0]' 		=>	$inputControl['physician_address'],
				'field[%HEIGHT%,0]' 		=>	$inputControl['height_12'],
				'field[%WEIGHT%,0]' 		=>	$inputControl['weight_12'],
				'field[%DATE_OF_BIRTH%,0]' 		=>	$inputControl['birth_month'].'/'.$inputControl['birth_day'].'/'.$inputControl['birth_year'],
				'field[%ARE_A_SMOKER%,0]' 		=>	$inputControl['are_smoker'],
				'field[%ARE_BREASTFEEDING%,0]' 		=>	$inputControl['are_breastfeeding'],
				'field[%ARE_PREGNANT%,0]' 		=>	$inputControl['are_pregnant'],
				'field[%DUE_DATE%,0]' 		=>		$inputControl['due_month'].'/'.$inputControl['due_day'].'/'.$inputControl['due_year'],
				'field[%SEX%,0]' 		=>	$inputControl['sex'],
				'field[%DRUG_ALLERGIES%,0]' 		=>	$inputControl['have_drug_allergies'],
				'field[%MEDICAL_HISTORY%,0]' 		=>	$inputControl['medical_history'],
				'field[%NAME_OF_EMPLOYER_GROUP%,0]' 		=>	$inputControl['employer_name'],
				'field[%DIVISION%,0]' 		=>	$inputControl['division'],
				'field[%RELATIONSHIP_TO_EMPLOYER%,0]' 		=>	$relationship[$inputControl['emp_relation']],
				'field[%REFILL_REMINDER_NOTIFICATION_PREFERENCE%,0]' 	=>	$notification[$inputControl['rem_notification']],
				'field[%ORDER_MEDICATION_NAME%,0]' 		=>	$order_med_name,
				'field[%ORDER_MEDICATION_STRENGTH%,0]' 		=>	$order_med_strength,
				'field[%ORDER_HOW_MANY_PER_DAY%,0]' 		=>	$order_med_no,
				'field[%ORDER_NEW_MEDICATION%,0]' 		=>	$order_new_med,
				'field[%ORDER_MAINTENANCE_DRUG%,0]' 		=>	$order_maintenance_drug,
				'field[%ORDERAUTO_REFILL%,0]' 		=>	$order_auto_refil,
				'field[%CURRENT_MEDICATION_NAME%,0]' 		=>	$cur_med_name,
				'field[%CURRENT_MEDICATION_STRENGTH%,0]' 		=>	$cur_med_strength,
				'field[%CURRENT_MEDICATION_HOW_MANY_PER_DAY%,0]' 		=>	$cur_med_count,
				'field[%CURRENT_MEDICATION_HOW_LONG_TAKEN_FOR%,0]' 		=>	$cur_med_long,
				'field[%ILLNESS_OR_CONDITION%,0]' 		=>	$cur_illness,
				'field[%SIGNATURE%,0]' 		=>	$inputControl['signature'],
				'field[%SIGNATURE_DATE%,0]' 		=>	$inputControl['submit_month'].'/'.$inputControl['submit_day'].'/'.$inputControl['submit_year'],
				'field[%PARTNER%,0]'	=> $partner_details[0]->first_name,
				'field[%PARTNER_LICENSE_NUMBER%,0]'	=> $partner_details[0]->license_no,
				'field[%ORDER_TYPE%,0]'	=> 'API',
				'field[%SUBMISSION_NUMBER%,0]'	=>	$medical_condition_id,
				'field[%SCRIPT_RECEIVED%,0]' =>	'No',


				'p[4]'                   => 4, // example list ID (REPLACE '123' WITH ACTUAL LIST ID, IE: p[5] = 5)
				'status[4]'              => 1, // 1: active, 2: unsubscribed (REPLACE '123' WITH ACTUAL LIST ID, IE: status[5] = 1)
			);

			// This section takes the input fields and converts them to the proper format

			$query = "";

			foreach( $params as $key => $value ) $query .= urlencode($key) . '=' . urlencode($value) . '&';

			$query = rtrim($query, '& ');

			$data = "";

			foreach( $post as $key => $value ) $data .= urlencode($key) . '=' . urlencode($value) . '&';

			$data = rtrim($data, '& ');


			$url = rtrim($url, '/ ');

			if ( !function_exists('curl_init') ) die('CURL not supported. (introduced in PHP 4.0.2)');


			if ( $params['api_output'] == 'json' && !function_exists('json_decode') ) {

				die('JSON not supported. (introduced in PHP 5.2.0)');

			}

			$api = $url . '/admin/api.php?' . $query;

			$request = curl_init($api); // initiate curl object

			curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response

			curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)

			curl_setopt($request, CURLOPT_POSTFIELDS, $data); // use HTTP POST to send form data

			curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);


			$response = (string)curl_exec($request); 

			curl_close($request); 


			if ( !$response ) {

				die('Nothing was returned. Do you have a connection to Email Marketing server?');

			}

			$result = unserialize($response);


		   /*.............Active campign end..................*/

			
			
			
		}
		if($success && $success_1 && $success_2){
			if($inputControl['prescription'] == 'attached'){
				$message = "We have saved this information and you'll be redirected to upload your files.";
			}
			else{
				$message = "Your order has been submitted.";
			}
			return $this->response->withJson(array(
				'status' 	=> 'success',
				'message'	=>	$message,
				'details'	=>	array(
					'medication_id'	=>	$medical_condition_id,
					'email'			=>	$inputControl['email'],
					'unique_key'	=>	$unique_key
				)
			));
		}
		else if($success){
			return $this->response->withJson(array(
				'status' 	=> 'error',
				'message'	=>	'Your order could not be completed. Please contact the administrator.'
			));
		}
		else{
			return $this->response->withJson(array(
				'status' 	=> 'error',
				'message'	=>	'An error occured. Try again later.'
			));
		}
	}
	catch (PDOException $e) {
        return $this->response->withJson($e);
    }
});

$app->post('/partner/submitOrderFiles', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$medication_id	=	$inputControl['order_id'];
	$upload_flag	=	false;
	$files = $request->getUploadedFiles();
	$patient_files	=	'';
   	$directory	=	'../../hw-uploads/medication-files';
	
	if($files){
		foreach ($files['file'] as $uploadedFile) {
			if ($uploadedFile->getError() === UPLOAD_ERR_OK) {
				$filename = moveUploadedFile1($directory, $uploadedFile,$medication_id);
				if($filename != ''){
					try {
						$db = new db();
						$db = $db->connect();

						$db->query("SET  CHARACTER SET utf8;");

						$row = [
							'media_type' 	=> 	'medication_files',
							'relation_id'	=>	$medication_id,
							'file_name'		=>	$filename,
							'status'		=>	1
						];

						$media_query	=	'INSERT INTO rx_media_files SET media_type=:media_type, relation_id=:relation_id, file_name=:file_name, status=:status';

						$success		= 	$db->prepare($media_query)->execute($row);
						if($success){
							$upload_flag	= true;
						}

					} 
					catch (PDOException $e) {
						return $this->response->withJson($e);
					}
				}
			}
		}
	
		if($upload_flag){
			
			try {
				$db = new db();
				$db = $db->connect();

				$db->query("SET  CHARACTER SET utf8;");

				$dataQuerry = $db->prepare('SELECT email from rx_medical_orders WHERE id=:id'); 
				$dataQuerry->bindParam('id',$medication_id);
				$dataQuerry->execute();
				$email = $dataQuerry->fetch(PDO::FETCH_OBJ);
				
				
				$media_type	=	'medication_files';
				$stmt = $db->prepare('SELECT file_name from rx_media_files WHERE media_type=:media_type AND relation_id=:id ');
				$stmt->bindParam('media_type', $media_type);
				$stmt->bindParam('id', $medication_id);
				$stmt->execute();
				$media_items = $stmt->fetchAll(PDO::FETCH_OBJ);
				foreach($media_items as $media){
					$patient_files .= 'https://www.rxtoyou.com/hw-uploads/medication-files/'.$media->file_name.', ';
				}

			} 
			catch (PDOException $e) {
				//return $this->response->withJson($e);
			}
			
			
			
			/*.............Active campign Start..................*/
		
			$url = 'https://rxtoyou.api-us1.com';
			$key='d23525f33c29a6eddfe6e38ef4bf1c0bd82fe710de0d40d96115afafe3923f0fc3175c54';

			$params = array(  
				'api_key'      => $key, 
				'api_action'   => 'contact_sync',
				'api_output'   => 'serialize',
			);

			// here we define the data we are posting in order to perform an update
			$post = array(

				'email'                    		=> $email->email,
				'field[%SCRIPT_RECEIVED%,0]' 	=>	'Yes',
				'field[%UPLOADED_FILES%,0]' 	=> $patient_files,
				'p[4]'                   => 4, // example list ID (REPLACE '123' WITH ACTUAL LIST ID, IE: p[5] = 5)
				'status[4]'              => 1, // 1: active, 2: unsubscribed (REPLACE '123' WITH ACTUAL LIST ID, IE: status[5] = 1)
			);

			// This section takes the input fields and converts them to the proper format

			$query = "";

			foreach( $params as $key => $value ) $query .= urlencode($key) . '=' . urlencode($value) . '&';

			$query = rtrim($query, '& ');

			$data = "";

			foreach( $post as $key => $value ) $data .= urlencode($key) . '=' . urlencode($value) . '&';

			$data = rtrim($data, '& ');


			$url = rtrim($url, '/ ');

			if ( !function_exists('curl_init') ) die('CURL not supported. (introduced in PHP 4.0.2)');


			if ( $params['api_output'] == 'json' && !function_exists('json_decode') ) {

				die('JSON not supported. (introduced in PHP 5.2.0)');

			}

			$api = $url . '/admin/api.php?' . $query;

			$request = curl_init($api); // initiate curl object

			curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response

			curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)

			curl_setopt($request, CURLOPT_POSTFIELDS, $data); // use HTTP POST to send form data

			curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);


			$response = (string)curl_exec($request); 

			curl_close($request); 


			if ( !$response ) {

				die('Nothing was returned. Do you have a connection to Email Marketing server?');

			}

			$result = unserialize($response);


		   /*.............Active campign end..................*/
			

			return $this->response->withJson(array(
				'status' 	=> 'success',
				'message'	=>	'Your files has been saved.'
			));
		}
		else{
			return $this->response->withJson(array(
				'status' 	=> 'error',
				'message'	=>	'An error occured. Try again later.'
			));
		}
	}
	else{
		return $this->response->withJson(array(
			'status' 	=> 'error',
			'message'	=>	'You need to select atleast one file to upload.'
		));
	}
	
});

//get partner details for profile
$app->post('/partner/getPartnerDetails', function(Request $request, Response $response) {
	
	$inputControl	= 	$request->getParsedBody();
	$partner_user_id		=	$inputControl['partner_user_id'];
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson('Invalid Request');
	}

	if(checkPartnerStatus($partner_user_id)){
		$status		=	1;
		$flag		=	'';
		try {

			$db = new db();
			$db = $db->connect();

			$db->query("SET  CHARACTER SET utf8;");

			$stmt = $db->prepare('SELECT first_name,
			rx_pc.name as company_name,
			email,
			phone
			FROM rx_partners
			LEFT JOIN rx_partner_companies rx_pc ON rx_pc.id = rx_partners.company_id
			WHERE user_id=:user_id');
			$stmt->bindParam('user_id', $partner_user_id);
			$stmt->execute();
			$details = $stmt->fetch(PDO::FETCH_OBJ); 

			$db = null; 

			if(isset($details) && !empty($details)){
				$flag	=	1;
				$result['details']	=	$details;
				$result['msg']	=	'Success.';
			}
			else{
				$flag	=	0;
				$result['msg']	=	'No details found.';
			}
		
			return $this->response->withJson(array(
				'status' 	=> 	$flag,
				'message'	=>	$result 
			));


		} catch (PDOException $e) {
			return $this->response->withJson(array(
				'status' 	=> 	0,
				'message'	=>	$e
			));
		}
	}
	else{
		$result['msg']	=	'Your account has been suspended/deactivated. Please contact administrator ';
		return $this->response->withJson(array(
			'status' 	=> 	2,
			'message'	=>	$result 
		));
	}
}); 


//call from partner
$app->post('/partner/getPartnerGroups', function(Request $request, Response $response) {
	
	$inputControl	= 	$request->getParsedBody();
	$user_id		=	$inputControl['user_id'];
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson('Invalid Request');
	}
	
	if(checkUserExistbyID($user_id)){
	
		$status		=	1;
		$flag		=	'';
		try {

			$db = new db();
			$db = $db->connect();

			$db->query("SET  CHARACTER SET utf8;");

			$stmt = $db->prepare('SELECT rx_groups.id,
			rx_groups.name,
			rx_partner_companies.name as partner_name,
			rx_groups.status 
			FROM rx_groups 
			LEFT JOIN rx_partners ON (rx_partners.company_id = rx_groups.company_id)
			LEFT JOIN rx_partner_companies ON (rx_partner_companies.id = rx_partners.company_id)
			WHERE rx_partners.user_id=:user_id AND rx_groups.status=:status ORDER BY rx_groups.id DESC ');
			$stmt->bindParam('user_id', $user_id);
			$stmt->bindParam('status', $status);
			$stmt->execute();
			$groups = $stmt->fetchAll(PDO::FETCH_OBJ); 

			$db = null; 

			if(count($groups) > 0){
				$flag	=	'success';
				$result['details']	=	$groups;
				$result['msg']	=	'Success.';
			}
			else{
				$flag	=	'error';
				$result['msg']	=	'No groups found.';
			}
		
			return $this->response->withJson(array(
				'status' 	=> 	$flag,
				'message'	=>	$result 
			));


		} catch (PDOException $e) {
			return $this->response->withJson(array(
				'status' 	=> 	'error',
				'message'	=>	$e
			));
		}
	}
	else{
		$result['msg']	=	'Partner does not exist. Please go back to partners list';
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$result 
		));
	}
}); 




function moveUploadedFile1($directory, Slim\Http\UploadedFile $uploadedFile, $medication_id){
	$extension = pathinfo($uploadedFile->getClientFilename(), PATHINFO_EXTENSION);
	$basename = $medication_id.time(); // see http://php.net/manual/en/function.random-bytes.php
	$filename = sprintf('%s.%0.8s', $basename, $extension);
	$uploadedFile->moveTo($directory . DIRECTORY_SEPARATOR . $filename);
	return $filename;
}

function checkPartnerStatus($user_id){
	try {
		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT * from rx_users WHERE id=:user_id');
		$stmt->bindParam('user_id',$user_id);
		$stmt->execute();
		$users = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		//print_r($users);
		 
		if(count($users) > 0){
			if($users[0]->status == 1){
				return true;
			}
			else{
				return false;
			}
		}
		else{
			return false;
		}	
		
    } catch (PDOException $e) {
        return true;
    }
}

?>