<?php

use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use \Firebase\JWT\JWT;

$server_url	=	'https://rxtoyou.com/';

//list orders in admin dashboard
$app->post('/admin/listallorders', function(Request $request, Response $response) {
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson(array(
			'status' 	=>  'error',
			'message'	=>	'Invalid Request'
		));
	}
	
	$status		=	0;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;"); 
		
		
		$stmt = $db->prepare('SELECT CAST(10000 * rxmo.birth_year + 100 * rxmo.birth_month + rxmo.birth_day AS DATETIME) as dob,
		rxmo.id,
		rxmo.user_id as patient_user_id,
		rxmo.order_date,
		rxmo.birth_month,
		rxmo.birth_day,
		rxmo.birth_year,
		rxmo.status,
		rxmo.req_status,
		rxos.status_text,
		rxpr.name as partner,
		rxpr.id as company_id,
		rxgs.name as group_name,
		rxps.first_name as patient,
		GROUP_CONCAT(medication_name) medication_name
		from rx_medical_orders rxmo 
		LEFT JOIN rx_order_statuses rxos ON(rxos.id = rxmo.status)
		LEFT JOIN rx_patients rxps ON(rxps.user_id = rxmo.user_id)
		LEFT JOIN rx_groups rxgs ON(rxgs.id = rxps.group_id)
		LEFT JOIN rx_partner_companies rxpr ON(rxpr.id = rxgs.company_id)
		LEFT JOIN rx_medical_order_items rxmoi ON (rxmo.id = rxmoi.order_id)
		WHERE rxmo.status!=:status GROUP BY rxmo.id,rxps.id,rxgs.id,rxpr.id ORDER BY rxmo.id DESC');
		
		$stmt->bindParam('status', $status);
		$stmt->execute();
		$orders = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($orders) > 0){
			$flag	=	'success';
			$result['details']	=	$orders;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No orders found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});

//list patient orders using patient's user_id
$app->post('/admin/listpatientorders', function(Request $request, Response $response) {
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson(array(
			'status' 	=>  'error',
			'message'	=>	'Invalid Request'
		));
	}
	$inputControl	= 	$request->getParsedBody();
	$patient_user_id	=	$inputControl['patient_user_id'];
	
	$status		=	0;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT CAST(10000 * rxmo.birth_year + 100 * rxmo.birth_month + rxmo.birth_day AS DATETIME) as dob,
		rxmo.id,
		rxmo.order_date,
		rxmo.birth_month,
		rxmo.birth_day,
		rxmo.birth_year,
		rxmo.status,
		rxmo.req_status,
		rxos.status_text,
		GROUP_CONCAT(medication_name) medication_name
		from rx_medical_orders rxmo 
		LEFT JOIN rx_order_statuses rxos ON(rxos.id = rxmo.status)
		LEFT JOIN rx_medical_order_items rxmoi ON (rxmo.id = rxmoi.order_id)
		WHERE rxmo.user_id=:user_id AND rxmo.status!=:status GROUP BY rxmo.id ORDER BY rxmo.id DESC');
		$stmt->bindParam('user_id', $patient_user_id);
		$stmt->bindParam('status', $status);
		$stmt->execute();
		$orders = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($orders) > 0){
			$flag	=	'success';
			$result['details']	=	$orders;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No orders found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});



//get details of all orders
$app->post('/admin/exportallorders', function(Request $request, Response $response) {
	
	$inputControl 	= $request->getParsedBody();

	$status		=	0;
	$flag		=	'';
	
	$data_array	=	array();
	
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
	
	
		$stmt = $db->prepare('SELECT rxmo.*,rxps.user_id as patient_user_id,rxps.first_name as patient_name,rxg.id as plan_id,rxg.name as plan_name,rxpc.id as company_id,rxpc.name as company_name from rx_medical_orders rxmo
		LEFT JOIN rx_patients rxps ON rxmo.user_id = rxps.user_id
		LEFT JOIN rx_groups rxg ON rxps.group_id = rxg.id
		LEFT JOIN rx_partner_companies rxpc ON rxg.company_id = rxpc.id
		WHERE rxmo.status!=:status ORDER BY rxmo.id DESC');
		$stmt->bindParam('status', $status);
		
		$stmt->execute();
		$orders = $stmt->fetchAll(PDO::FETCH_OBJ);
		
		
      	
		//$db = null;
		if(count($orders) > 0){
			$i= 0;
			foreach($orders as $order){
				$stmt = $db->prepare('SELECT * from rx_medical_order_items WHERE order_id=:id');
				$stmt->bindParam('id', $order->id);
				$stmt->execute();
				$order_items = $stmt->fetchAll(PDO::FETCH_OBJ);
				
				$stmt = $db->prepare('SELECT * from rx_medication_items WHERE order_id=:id');
				$stmt->bindParam('id', $order->id);
				$stmt->execute();
				$medication_items = $stmt->fetchAll(PDO::FETCH_OBJ);
				
				$j= 0;
				$medication_names	=	$medication_strengths	= $per_day	=	$new_medication	=	$maintenance_drug	=	$auto_refil	=	'';
				foreach($order_items as $items){
					if($j == 0) $del = '';
					else $del = '|';
					$medication_names		.=	$del.$items->medication_name;
					$medication_strengths	.=	$del.$items->medication_strength;
					$per_day	.=	$del.$items->medication_no;
					$new_medication	.=	$del.$items->new_medication;
					$maintenance_drug	.=	$del.$items->maintenance_drug;
					$auto_refil	.=	$del.$items->auto_refil;
					$j++;
				}
				
				$cur_medication_names = $cur_medication_strengths = $cur_per_day =	$cur_long = $illness = '';
				
				$k= 0;
				foreach($medication_items as $med_items){
					if($k == 0) $del = '';
					else $del = '|';
					$cur_medication_names		.=	$del.$med_items->cur_medication_name;
					$cur_medication_strengths	.=	$del.$med_items->cur_medication_strength;
					$cur_per_day	.=	$del.$med_items->cur_medication_count;
					$cur_long	.=	$del.$med_items->cur_medication_long;
					$illness	.=	$del.$med_items->cur_medication_illness;
					$k++;
				}
				
				
				$orderstatus = array(
					'1' => 'Information Needed',
					'2' => 'Submitted by Patient', 
					'3' => 'Processing',
					'4' => 'Missing Script',
					'5' => 'Submitted to Pharmacy',
					'6' => 'Shipped',
					'7' => 'Delivered'
				);
				
				
				$data_array[$i]	=	array(
					//'ID'	=> $order->id,
					'No'				=>	$i+1,
					'Order ID'			=>	$order->id,
					'Order Date'		=>	$order->order_date,
					'Patient User ID'	=>	$order->patient_user_id,
					'Plan ID'			=>	$order->plan_id,
					'Plan Name'			=>	$order->plan_name,
					'Partner Company ID'	=>	$order->company_id,
					'Partner Comapny Name'	=>	$order->company_name,
					'First Name'		=>	$order->first_name,
					'Last Name'			=>	$order->last_name,
					'Home Phone No.'	=>	$order->home_phone_no,
					'Mobile Phone No.'	=>	$order->mobile_phone_no,
					'Email'				=>	$order->email,
					'Shipping Address 1'	=>	$order->shipping_address_1,
					'Shipping Address 1'	=>	$order->shipping_address_2,
					'Shipping City'			=>	$order->shipping_city,
					'Shipping State'		=>	$order->shipping_state,
					'Shipping ZIP'			=>	$order->shipping_zip,
					'Physician Name'		=>	$order->physician_name,
					'Physician Phone'		=>	$order->physician_ph,
					'Physician Fax'			=>	$order->physician_fax,
					'Physician Address'		=>	$order->physician_address,
					'Height'				=>	$order->height_12,
					'Weight'				=>	$order->weight_12,
					'Date of Birth'			=>	$order->birth_month.'-'.$order->birth_day.'-'.$order->birth_year,
					'Are You a Smoker?'			=>	$order->are_smoker,
					'Are You Breastfeeding?'		=>	$order->are_breastfeeding,
					'Are You Pregnant?'			=>	$order->are_pregnant,
					'Due Date'				=>	$order->due_month.'-'.$order->due_day.'-'.$order->due_year,
					'Sex'					=>	$order->sex,
					'Drug Allergies Listed'	=>	$order->have_drug_allergies,
					'Medical History'		=>	$order->medical_history,
					'Name of Employer / Plan'			=>	$order->employer_name,
					'Division'				=>	$order->division,
					'Relationship to employer'	=>	$order->emp_relation,
					'Refill Reminder Preference'	=>	$order->rem_notification,
					'Order- Medication Names' 	=> $medication_names,
					'Order- Medication Strengths' 	=> $medication_strengths,
					'Order-	Frequency'	=>	$per_day,
					'Order- New medication'		=>	$new_medication,
					'Maintenance Drug'			=>	$maintenance_drug,
					'Auto Refill'				=> 	$auto_refil,
					'Prescription Type'			=>	$order->prescription,
					'Current- Medication Names' 	=> $cur_medication_names,
					'Current- Medication Strengths' 	=> $cur_medication_strengths, 
					'Current- Frequency'		=>	$cur_per_day,
					'Current- How long taken for?'		=>	$cur_long,
					'Illness or condition'		=>	$illness,
					'Signature'					=>	$order->signature,
					'Date'			=>	$order->submit_month.'-'.$order->submit_day.'-'.$order->submit_year,
					'Status'		=>	$orderstatus[$order->status]
				);
				
				$i++;
				
			}
			
			$db = null;
			
			
			$flag	=	'success';
			$result['details']	=	$data_array;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No orders found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


//get details of orders of a particular patient by patient's user_id 
$app->post('/admin/exportcurrentpatientallorders', function(Request $request, Response $response) {
	
	$inputControl 	= $request->getParsedBody();
	$patient_user_id	=	$inputControl['user_id'];
	
//	if($type == 'partner_patient'){
//		$partner_id	=	$inputControl['partner_id'];
//	}

	$status		=	0;
	$flag		=	'';
	
	$data_array	=	array();
	
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
	
	
		$stmt = $db->prepare('SELECT rxmo.*,rxps.user_id as patient_user_id,rxps.first_name as patient_name,rxg.id as plan_id,rxg.name as plan_name,rxpc.id as company_id,rxpc.name as company_name from rx_medical_orders rxmo
		LEFT JOIN rx_patients rxps ON rxmo.user_id = rxps.user_id
		LEFT JOIN rx_groups rxg ON rxps.group_id = rxg.id
		LEFT JOIN rx_partner_companies rxpc ON rxg.company_id = rxpc.id
		WHERE rxmo.user_id=:user_id AND rxmo.status!=:status ORDER BY rxmo.id DESC');
		$stmt->bindParam('user_id', $patient_user_id);
		$stmt->bindParam('status', $status);
		
		$stmt->execute();
		$orders = $stmt->fetchAll(PDO::FETCH_OBJ);
		
		
      	
		//$db = null;
		
		 
		if(count($orders) > 0){
			$i= 0;
			foreach($orders as $order){
				$stmt = $db->prepare('SELECT * from rx_medical_order_items WHERE order_id=:id');
				$stmt->bindParam('id', $order->id);
				$stmt->execute();
				$order_items = $stmt->fetchAll(PDO::FETCH_OBJ);
				
				$stmt = $db->prepare('SELECT * from rx_medication_items WHERE order_id=:id');
				$stmt->bindParam('id', $order->id);
				$stmt->execute();
				$medication_items = $stmt->fetchAll(PDO::FETCH_OBJ);
				
				$j= 0;
				$medication_names	=	$medication_strengths	= $per_day	=	$new_medication	=	$maintenance_drug	=	$auto_refil	=	'';
				foreach($order_items as $items){
					if($j == 0) $del = '';
					else $del = '|';
					$medication_names		.=	$del.$items->medication_name;
					$medication_strengths	.=	$del.$items->medication_strength;
					$per_day	.=	$del.$items->medication_no;
					$new_medication	.=	$del.$items->new_medication;
					$maintenance_drug	.=	$del.$items->maintenance_drug;
					$auto_refil	.=	$del.$items->auto_refil;
					$j++;
				}
				
				$cur_medication_names = $cur_medication_strengths = $cur_per_day =	$cur_long = $illness = '';
				
				$k= 0;
				foreach($medication_items as $med_items){
					if($k == 0) $del = '';
					else $del = '|';
					$cur_medication_names		.=	$del.$med_items->cur_medication_name;
					$cur_medication_strengths	.=	$del.$med_items->cur_medication_strength;
					$cur_per_day	.=	$del.$med_items->cur_medication_count;
					$cur_long	.=	$del.$med_items->cur_medication_long;
					$illness	.=	$del.$med_items->cur_medication_illness;
					$k++;
				}
				
				
				$data_array[$i]	=	array(
					//'ID'	=> $order->id,
					'No'				=>	$i+1,
					'Order ID'			=>	$order->id,
					'Order Date'		=>	$order->order_date,
					'Patient User ID'	=>	$order->patient_user_id,
					'Plan ID'			=>	$order->plan_id,
					'Plan Name'			=>	$order->plan_name,
					'Partner Company ID'	=>	$order->company_id,
					'Partner Comapny Name'	=>	$order->company_name,
					'First Name'		=>	$order->first_name,
					'Last Name'			=>	$order->last_name,
					'Home Phone No.'	=>	$order->home_phone_no,
					'Mobile Phone No.'	=>	$order->mobile_phone_no,
					'Email'				=>	$order->email,
					'Shipping Address 1'	=>	$order->shipping_address_1,
					'Shipping Address 1'	=>	$order->shipping_address_2,
					'Shipping City'			=>	$order->shipping_city,
					'Shipping State'		=>	$order->shipping_state,
					'Shipping ZIP'			=>	$order->shipping_zip,
					'Physician Name'		=>	$order->physician_name,
					'Physician Phone'		=>	$order->physician_ph,
					'Physician Fax'			=>	$order->physician_fax,
					'Physician Address'		=>	$order->physician_address,
					'Height'				=>	$order->height_12,
					'Weight'				=>	$order->weight_12,
					'Date of Birth'			=>	$order->birth_month.'-'.$order->birth_day.'-'.$order->birth_year,
					'Are You a Smoker?'			=>	$order->are_smoker,
					'Are You Breastfeeding?'		=>	$order->are_breastfeeding,
					'Are You Pregnant?'			=>	$order->are_pregnant,
					'Due Date'				=>	$order->due_month.'-'.$order->due_day.'-'.$order->due_year,
					'Sex'					=>	$order->sex,
					'Drug Allergies Listed'	=>	$order->have_drug_allergies,
					'Medical History'		=>	$order->medical_history,
					'Name of Employer / Plan'			=>	$order->employer_name,
					'Division'				=>	$order->division,
					'Relationship to employer'	=>	$order->emp_relation,
					'Refill Reminder Preference'	=>	$order->rem_notification,
					'Order- Medication Names' 	=> $medication_names,
					'Order- Medication Strengths' 	=> $medication_strengths,
					'Order-	Frequency'	=>	$per_day,
					'Order- New medication'		=>	$new_medication,
					'Maintenance Drug'			=>	$maintenance_drug,
					'Auto Refill'				=> 	$auto_refil,
					'Prescription Type'			=>	$order->prescription,
					'Current- Medication Names' 	=> $cur_medication_names,
					'Current- Medication Strengths' 	=> $cur_medication_strengths, 
					'Current- Frequency'		=>	$cur_per_day,
					'Current- How long taken for?'		=>	$cur_long,
					'Illness or condition'		=>	$illness,
					'Signature'					=>	$order->signature,
					'Date'			=>	$order->submit_month.'-'.$order->submit_day.'-'.$order->submit_year
					//'Status'		=>	$order->status
				);
				
				$i++;
				
			}
			
			$db = null;
			
			
			$flag	=	'success';
			$result['details']	=	$data_array;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No orders found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});

//call from admin
$app->post('/admin/orderdetails', function(Request $request, Response $response) {
	
	$inputControl 	= $request->getParsedBody();
	$order_id		=	$inputControl['order_id'];
	$order_items	=	$medication_items = array();
	$status		=	1;
	$flag		=	'';
	$partner_id	=	$license_no	=	0;
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT rxmo.*,rxos.status_text from rx_medical_orders rxmo
		LEFT JOIN rx_order_statuses rxos ON (rxmo.status = rxos.id) WHERE rxmo.id=:id ');
		$stmt->bindParam('id', $order_id);
		$stmt->execute();
		$orders = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		if(count($orders) > 0){
			$flag	=	'success';
			$result['msg']	=	'Success.';
			
			$result['type'] = $orders[0]->type;
			
			$stmt = $db->prepare('SELECT * from rx_medical_order_items WHERE order_id=:id ');
			$stmt->bindParam('id', $order_id);
			$stmt->execute();
			$order_items = $stmt->fetchAll(PDO::FETCH_OBJ);
			
			
			$media_type	=	'medication_files';
			$stmt = $db->prepare('SELECT file_name from rx_media_files WHERE media_type=:media_type AND relation_id=:id ');
			$stmt->bindParam('media_type', $media_type);
			$stmt->bindParam('id', $order_id);
			$stmt->execute();
			$media_items = $stmt->fetchAll(PDO::FETCH_OBJ);
			
			if(count($media_items) > 0){
				$result['media_items']	=	$media_items;
			}
			
			$stmt = $db->prepare('SELECT * from rx_medication_items WHERE order_id=:id ');
			$stmt->bindParam('id', $order_id);
			$stmt->execute();
			$medication_items = $stmt->fetchAll(PDO::FETCH_OBJ);
			 
			$db = null;
			
			$result['details']	=	array(
				'id'			=>	$orders[0]->id,
				'first_name'	=>	$orders[0]->first_name,
				'last_name'		=>	$orders[0]->last_name,
				'home_phone_no'	=>	$orders[0]->home_phone_no,
				'mobile_phone_no'	=>	$orders[0]->mobile_phone_no,
				'email'				=>	$orders[0]->email,
				'shipping_address_1'	=>	$orders[0]->shipping_address_1,
				'shipping_address_2'	=>	$orders[0]->shipping_address_2,
				'shipping_city'			=>	$orders[0]->shipping_city,
				'shipping_state'		=>	$orders[0]->shipping_state,
				'shipping_zip'			=>	$orders[0]->shipping_zip,
				'physician_name'		=>	$orders[0]->physician_name,
				'physician_ph'			=>	$orders[0]->physician_ph,
				'physician_fax'			=>	$orders[0]->physician_fax,
				'physician_address'		=>	$orders[0]->physician_address,
				'height_12'				=>	$orders[0]->height_12,
				'weight_12'				=>	$orders[0]->weight_12,
				'birth_month'			=>	$orders[0]->birth_month,
				'birth_day'				=>	$orders[0]->birth_day,
				'birth_year'			=>	$orders[0]->birth_year,
				'are_smoker'			=>	$orders[0]->are_smoker,
				'are_breastfeeding'		=>	$orders[0]->are_breastfeeding,
				'are_pregnant'			=>	$orders[0]->are_pregnant,
				'due_month'				=>	$orders[0]->due_month,
				'due_day'				=>	$orders[0]->due_day,
				'due_year'				=>	$orders[0]->due_year,
				'sex'					=>	$orders[0]->sex,
				'have_drug_allergies'	=>	$orders[0]->have_drug_allergies,
				'medical_history'		=>	$orders[0]->medical_history,
				'employer_name'			=>	$orders[0]->employer_name,
				'division'				=>	$orders[0]->division,
				'emp_relation'			=>	$orders[0]->emp_relation,
				'rem_notification'		=>	$orders[0]->rem_notification,
				'order_items'			=>	$order_items,
				'prescription'			=> 	$orders[0]->prescription,
				'medication_items'		=>	$medication_items,
				'signature'				=> 	$orders[0]->signature,
				'submit_month'			=> 	$orders[0]->submit_month,
				'submit_day'			=> 	$orders[0]->submit_day,
				'submit_year'			=> 	$orders[0]->submit_year,
				'unique_key'			=> 	$orders[0]->unique_key,
				'tracking_no'			=> 	$orders[0]->tracking_no,
				'order_date'			=> 	$orders[0]->order_date,
				'status_text'			=> 	$orders[0]->status_text,
				'status'				=> 	$orders[0]->status,
				'patient_user_id'		=>	$orders[0]->user_id,
			);
			$result['order_status']		=	$orders[0]->status;
			
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No details found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});



//Save new order for patients from admin
$app->post('/admin/makenewOrder', function(Request $request, Response $response) {

    $inputControl = $request->getParsedBody();
   	

	$order_items		=	$inputControl['order_items'];
	$medication_items	=	$inputControl['medication_items'];

	$order_med_name	=	$order_med_strength = $order_med_no = $order_new_med = $order_maintenance_drug = $order_auto_refil = 	'';
	$cur_med_name	= $cur_med_strength	= $cur_med_count	= $cur_med_long	= $cur_illness = '';
	//echo $first_name;
	
	$patient_user_id = $inputControl['patient_user_id'];
	//$user_id = 27;
	
	
	try {
		$db = new db();
		$db = $db->connect();


		$row = [
			'user_id' 	=> $patient_user_id,
			'first_name' 	=> $inputControl['first_name'],
			'last_name' 	=> $inputControl['last_name'],
			'home_phone_no' => $inputControl['home_phone_no'],
			'mobile_phone_no'	=>			$inputControl['mobile_phone_no'],
			'email'				=>	$inputControl['email'],
			'shipping_address_1'		=>	$inputControl['shipping_address_1'],
			'shipping_address_2'		=>	$inputControl['shipping_address_2'],
			'shipping_city'		=>	$inputControl['shipping_city'],
			'shipping_state'	=>	$inputControl['shipping_state'],
			'shipping_zip'		=>	$inputControl['shipping_zip'],
			'physician_name'	=>	$inputControl['physician_name'],
			'physician_ph'		=>	$inputControl['physician_ph'],
			'physician_fax'		=>	$inputControl['physician_fax'],
			'physician_address'	=>	$inputControl['physician_address'],
			'height_12'		=>	$inputControl['height_12'],
			'weight_12'		=>	$inputControl['weight_12'],
			'birth_day'		=>	$inputControl['birth_day'],
			'birth_month'		=>	$inputControl['birth_month'],
			'birth_year'		=>	$inputControl['birth_year'],
			'are_smoker'		=>	$inputControl['are_smoker'],
			'are_breastfeeding'	=>	$inputControl['are_breastfeeding'],
			'are_pregnant'		=>	$inputControl['are_pregnant'],
			'due_day'		=>	$inputControl['due_day'],
			'due_month'		=>	$inputControl['due_month'],
			'due_year'		=>	$inputControl['due_year'],
			'sex'			=>	$inputControl['sex'],
			'have_drug_allergies'	=>	$inputControl['have_drug_allergies'],
			'medical_history'		=>	$inputControl['medical_history'],
			'employer_name'		=>	$inputControl['employer_name'],
			'division'			=>	$inputControl['division'],
			'emp_relation'		=>	$inputControl['emp_relation'],
			'rem_notification'	=>	$inputControl['rem_notification'],
			'prescription'		=>	$inputControl['prescription'],
			'signature'			=>	$inputControl['signature'],
			'submit_day'		=>	$inputControl['submit_day'],
			'submit_month'		=>	$inputControl['submit_month'],
			'submit_year'		=>	$inputControl['submit_year'],
			'type'				=>	'patient',
			'order_date'		=>	$inputControl['order_date'],
			'status'			=>	$inputControl['status']
		];

		$sql = "INSERT INTO rx_medical_orders SET user_id=:user_id,first_name=:first_name, last_name=:last_name, home_phone_no=:home_phone_no,mobile_phone_no=:mobile_phone_no,email=:email,shipping_address_1=:shipping_address_1,shipping_address_2=:shipping_address_2,shipping_city=:shipping_city,shipping_state=:shipping_state,shipping_zip=:shipping_zip,physician_name=:physician_name,physician_ph=:physician_ph,physician_fax=:physician_fax,physician_address=:physician_address,height_12=:height_12,weight_12=:weight_12,birth_day=:birth_day,birth_month=:birth_month,birth_year=:birth_year,are_smoker=:are_smoker,are_breastfeeding=:are_breastfeeding,are_pregnant=:are_pregnant,due_day=:due_day,due_month=:due_month,due_year=:due_year,sex=:sex,have_drug_allergies=:have_drug_allergies,medical_history=:medical_history,employer_name=:employer_name,division=:division,emp_relation=:emp_relation,rem_notification=:rem_notification,prescription=:prescription,signature=:signature,submit_day=:submit_day,submit_month=:submit_month,submit_year=:submit_year,type=:type,order_date=:order_date,created_at=NOW(),status=:status;";

		/** @var PDO $pdo */
		$success 		= 	$db->prepare($sql)->execute($row);
		$order_id 	= 	$db->lastInsertId();
		
		if($order_id){
			
			$pass = substr(str_shuffle("0123456789abcdefghijklmnopqrstvwxyz"), 0, 6);
			$unique_key	=	 base64_encode($inputControl['email'].'&'.$order_id.'&'.$pass);
			
			$updateQuerry = $db->prepare('UPDATE rx_medical_orders SET unique_key=:unique_key WHERE id=:id');
			$updateQuerry->bindParam('unique_key',$unique_key);
			$updateQuerry->bindParam('id',$order_id);
			$updateQuerry->execute();
			
			
			$order_count	=	count($order_items);
			if($order_count > 0){
				$order_loop_count	=	0;
				foreach($order_items as $item){
					$delimiter	=	($order_loop_count > 0)?'|':'';
					$order_med_name	.= $delimiter.$item['medication_name'];
					$order_med_strength	.= $delimiter.$item['medication_strength'];
					$order_med_no	.= $delimiter.$item['medication_no'];
					$order_new_med	.= $delimiter.$item['new_medication'];
					$order_maintenance_drug	.= $delimiter.$item['maintenance_drug'];
					$order_auto_refil	.= $delimiter.$item['auto_refil'];
					$row = [
						'order_id' 	=> 	$order_id,
						'medication_name' 		=> 	$item['medication_name'],
						'medication_strength'	=>	$item['medication_strength'],
						'medication_no'			=>	$item['medication_no'],
						'new_medication'		=>	$item['new_medication'],
						'maintenance_drug'		=>	$item['maintenance_drug'],
						'auto_refil'			=>	$item['auto_refil'],
						'status'				=>	1
					];
					$sql	=	"INSERT INTO rx_medical_order_items SET order_id=:order_id,medication_name=:medication_name,medication_strength=:medication_strength,medication_no=:medication_no,new_medication=:new_medication,maintenance_drug=:maintenance_drug,auto_refil=:auto_refil,status=:status;";
					
					$success_1		= 	$db->prepare($sql)->execute($row);
					$order_loop_count++;
				}
			}
			else{
				$success_1 = true;
			}
			
			$medication_count	=	count($medication_items);
			if($medication_count > 0){
				$medication_loop_count	=	0;
				foreach($medication_items as $medication){
					$delimiter	=	($medication_loop_count > 0)?'|':'';
					$cur_med_name	.= $delimiter.$medication['cur_medication_name'];
					$cur_med_strength	.= $delimiter.$medication['cur_medication_strength'];
					$cur_med_count	.= $delimiter.$medication['cur_medication_count'];
					$cur_med_long	.= $delimiter.$medication['cur_medication_long'];
					$cur_illness	.= $delimiter.$medication['cur_medication_illness']; 
					$row = [
						'order_id' 					=> 	$order_id,
						'cur_medication_name' 		=> 	$medication['cur_medication_name'],
						'cur_medication_strength'	=>	$medication['cur_medication_strength'],
						'cur_medication_count'		=>	$medication['cur_medication_count'],
						'cur_medication_long'		=>	$medication['cur_medication_long'],
						'cur_medication_illness'	=>	$medication['cur_medication_illness'],
						'status'					=>	1
					];
					$sql	=	"INSERT INTO rx_medication_items SET order_id=:order_id,cur_medication_name=:cur_medication_name,cur_medication_strength=:cur_medication_strength,cur_medication_count=:cur_medication_count,cur_medication_long=:cur_medication_long,cur_medication_illness=:cur_medication_illness,status=:status;";
					
					$success_2		= 	$db->prepare($sql)->execute($row);
					$medication_loop_count++;
				}
			}
			else{
				$success_2 = true;
			}
			
			
			
			
			$relationship = array(
				'employee' => 'Employee / Self',
				'spouse' => 'Spouse / Partner', 
				'dependant' => 'Dependant'
			);
			$notification = array(
			  	'home-phone' => 'Home phone',
				'mobile-phone' => 'Mobile phone', 
				'email' => 'Email'
			);
			$prescriptions =	array(
			  	'attached' => 'Upload the script files',
				'fax' => 'I will arrange for my doctor to fax my prescription(s) to (858) 779-2537.', 
				'request' => 'Please fax my doctor to request a copy of my prescription(s)'
			);

			
			
			$stmt = $db->prepare('SELECT rx_partner_companies.name,license_no from rx_partner_companies LEFT JOIN rx_groups ON (rx_groups.company_id = rx_partner_companies.id) LEFT JOIN rx_patients ON (rx_patients.group_id = rx_groups.id) WHERE rx_patients.user_id=:user_id');
			$stmt->bindParam('user_id',$patient_user_id);
			$stmt->execute();
			$company_details = $stmt->fetchAll(PDO::FETCH_OBJ);
			$comapny_name = $license_no ='';
			if(count($company_details) > 0){
				$comapny_name = $company_details[0]->name;
				$license_no = $company_details[0]->license_no;
			}
			
			
			/*.............Active campign Start..................*/
		
			$url = 'https://rxtoyou.api-us1.com';
			$key='d23525f33c29a6eddfe6e38ef4bf1c0bd82fe710de0d40d96115afafe3923f0fc3175c54';

			$params = array(  
				'api_key'      => $key, 
				'api_action'   => 'contact_sync',
				'api_output'   => 'serialize',
			);

			// here we define the data we are posting in order to perform an update
			$post = array(

				'email'                    => $inputControl['email'],
				'first_name'               => $inputControl['first_name'],
				'last_name'                => $inputControl['last_name'],
				'phone'                    => $inputControl['home_phone_no'],


				// 'form'          => $formid, // Subscription Form ID, to inherit those redirection settings

				'field[%MOBILE_PHONE%,0]' 	=> 	$inputControl['mobile_phone_no'],
				'field[%SHIPPING_ADDRESS_LINE_1%,0]' 		=>	$inputControl['shipping_address_1'],
				'field[%SHIPPING_ADDRESS_LINE_2%,0]' 		=>	$inputControl['shipping_address_2'],
				'field[%SHIPPING_ADDRESS_CITY%,0]' 		=>	$inputControl['shipping_city'],
				'field[%SHIPPING_ADDRESS_STATE%,0]' 		=>	$inputControl['shipping_state'],
				'field[%SHIPPING_ADDRESS_ZIP%,0]' 		=>	$inputControl['shipping_zip'],
				'field[%PRESCRIBING_PHYSICIAN_NAME%,0]' 		=>	$inputControl['prescribing_physician_name'],
				'field[%PHYSICIAN_PHONE_NUMBER%,0]' 		=>	$inputControl['physician_ph'],
				'field[%PHYSICIAN_FAX_NUMBER%,0]' 		=>	$inputControl['physician_fax'],
				'field[%PHYSICIAN_ADDRESS%,0]' 		=>	$inputControl['physician_address'],
				'field[%HEIGHT%,0]' 		=>	$inputControl['height_12'],
				'field[%WEIGHT%,0]' 		=>	$inputControl['weight_12'],
				'field[%DATE_OF_BIRTH%,0]' 		=>	$inputControl['birth_month'].'/'.$inputControl['birth_day'].'/'.$inputControl['birth_year'],
				'field[%ARE_A_SMOKER%,0]' 		=>	$inputControl['are_smoker'],
				'field[%ARE_BREASTFEEDING%,0]' 		=>	$inputControl['are_breastfeeding'],
				'field[%ARE_PREGNANT%,0]' 		=>	$inputControl['are_pregnant'],
				'field[%DUE_DATE%,0]' 		=>		$inputControl['due_month'].'/'.$inputControl['due_day'].'/'.$inputControl['due_year'],
				'field[%SEX%,0]' 		=>	$inputControl['sex'],
				'field[%DRUG_ALLERGIES%,0]' 		=>	$inputControl['have_drug_allergies'],
				'field[%MEDICAL_HISTORY%,0]' 		=>	$inputControl['medical_history'],
				'field[%NAME_OF_EMPLOYER_GROUP%,0]' 		=>	$inputControl['employer_name'],
				'field[%DIVISION%,0]' 		=>	$inputControl['division'],
				'field[%RELATIONSHIP_TO_EMPLOYER%,0]' 		=>	$relationship[$inputControl['emp_relation']],
				'field[%REFILL_REMINDER_NOTIFICATION_PREFERENCE%,0]' 	=>	$notification[$inputControl['rem_notification']],
				'field[%ORDER_MEDICATION_NAME%,0]' 		=>	$order_med_name,
				'field[%ORDER_MEDICATION_STRENGTH%,0]' 		=>	$order_med_strength,
				'field[%ORDER_HOW_MANY_PER_DAY%,0]' 		=>	$order_med_no,
				'field[%ORDER_NEW_MEDICATION%,0]' 		=>	$order_new_med,
				'field[%ORDER_MAINTENANCE_DRUG%,0]' 		=>	$order_maintenance_drug,
				'field[%ORDERAUTO_REFILL%,0]' 		=>	$order_auto_refil,
				'field[%CURRENT_MEDICATION_NAME%,0]' 		=>	$cur_med_name,
				'field[%CURRENT_MEDICATION_STRENGTH%,0]' 		=>	$cur_med_strength,
				'field[%CURRENT_MEDICATION_HOW_MANY_PER_DAY%,0]' 		=>	$cur_med_count,
				'field[%CURRENT_MEDICATION_HOW_LONG_TAKEN_FOR%,0]' 		=>	$cur_med_long,
				'field[%ILLNESS_OR_CONDITION%,0]' 		=>	$cur_illness,
				'field[%SIGNATURE%,0]' 		=>	$inputControl['signature'],
				'field[%SIGNATURE_DATE%,0]' 		=>	$inputControl['submit_month'].'/'.$inputControl['submit_day'].'/'.$inputControl['submit_year'],
				'field[%ORDER_TYPE%,0]'	=> 'Web',
				'field[%SUBMISSION_NUMBER%,0]'	=>	$order_id, 
				'field[%SCRIPT_RECEIVED%,0]' =>	'No',
				'field[%PARTNER%,0]' => $comapny_name,
				'field[%PARTNER_LICENSE_NUMBER%,0]' => $license_no,

				'p[4]'                   => 4, // example list ID (REPLACE '123' WITH ACTUAL LIST ID, IE: p[5] = 5)
				'status[4]'              => 1, // 1: active, 2: unsubscribed (REPLACE '123' WITH ACTUAL LIST ID, IE: status[5] = 1)
			);

			// This section takes the input fields and converts them to the proper format

			$query = "";

			foreach( $params as $key => $value ) $query .= urlencode($key) . '=' . urlencode($value) . '&';

			$query = rtrim($query, '& ');

			$data = "";

			foreach( $post as $key => $value ) $data .= urlencode($key) . '=' . urlencode($value) . '&';

			$data = rtrim($data, '& ');


			$url = rtrim($url, '/ ');

			if ( !function_exists('curl_init') ) die('CURL not supported. (introduced in PHP 4.0.2)');


			if ( $params['api_output'] == 'json' && !function_exists('json_decode') ) {

				die('JSON not supported. (introduced in PHP 5.2.0)');

			}

			$api = $url . '/admin/api.php?' . $query;

			$request = curl_init($api); // initiate curl object

			curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response

			curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)

			curl_setopt($request, CURLOPT_POSTFIELDS, $data); // use HTTP POST to send form data

			curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);


			$response = (string)curl_exec($request); 

			curl_close($request); 


			if ( !$response ) {

				die('Nothing was returned. Do you have a connection to Email Marketing server?');

			}

			$result = unserialize($response);


		   /*.............Active campign end..................*/

			
			
			
		}
		
		if($success && $success_1 && $success_2){
			if($inputControl['prescription'] == 'attached'){
				$message = "We have saved this information and you'll be redirected to upload your files.";
			}
			else{
				$message = "Your order has been saved.";
			}
			return $this->response->withJson(array(
				'status' 	=> 'success',
				'message'	=>	$message,
				'details'	=>	array(
					'medication_id'	=>	$order_id,
					'email'			=>	$inputControl['email'],
					'unique_key'	=>	$unique_key
				)
			));
		}
		else if($success){
			return $this->response->withJson(array(
				'status' 	=> 'error',
				'message'	=>	'Your order could not be completed. Please contact the administrator.'
			));
		}
		else{
			return $this->response->withJson(array(
				'status' 	=> 'error',
				'message'	=>	'An error occured. Try again later.'
			));
		}
		

		
    } catch (PDOException $e) {
        return $this->response->withJson($e);
    }
});




$app->post('/admin/updateOrderDetails', function(Request $request, Response $response) {

    $inputControl = $request->getParsedBody();
   	
	$order_id	=	$inputControl['id'];
	
	$order_items		=	$inputControl['order_items'];
	$medication_items	=	$inputControl['medication_items'];

	
	try {
		$db = new db();
		$db = $db->connect();
		
		
		if(checkOrderstatusEditablebyIDforAdmin($order_id)){
		
			$row = [
				'first_name' 	=> $inputControl['first_name'],
				'last_name' 	=> $inputControl['last_name'],
				'home_phone_no' => $inputControl['home_phone_no'],
				'mobile_phone_no'	=>			$inputControl['mobile_phone_no'],
				'email'				=>	$inputControl['email'],
				'shipping_address_1'		=>	$inputControl['shipping_address_1'],
				'shipping_address_2'		=>	$inputControl['shipping_address_2'],
				'shipping_city'		=>	$inputControl['shipping_city'],
				'shipping_state'	=>	$inputControl['shipping_state'],
				'shipping_zip'		=>	$inputControl['shipping_zip'],
				'physician_name'	=>	$inputControl['physician_name'],
				'physician_ph'		=>	$inputControl['physician_ph'],
				'physician_fax'		=>	$inputControl['physician_fax'],
				'physician_address'	=>	$inputControl['physician_address'],
				'height_12'		=>	$inputControl['height_12'],
				'weight_12'		=>	$inputControl['weight_12'],
				'birth_day'		=>	$inputControl['birth_day'],
				'birth_month'		=>	$inputControl['birth_month'],
				'birth_year'		=>	$inputControl['birth_year'],
				'are_smoker'		=>	$inputControl['are_smoker'],
				'are_breastfeeding'	=>	$inputControl['are_breastfeeding'],
				'are_pregnant'		=>	$inputControl['are_pregnant'],
				'due_day'		=>	$inputControl['due_day'],
				'due_month'		=>	$inputControl['due_month'],
				'due_year'		=>	$inputControl['due_year'],
				'sex'			=>	$inputControl['sex'],
				'have_drug_allergies'	=>	$inputControl['have_drug_allergies'],
				'medical_history'		=>	$inputControl['medical_history'],
				'employer_name'		=>	$inputControl['employer_name'],
				'division'			=>	$inputControl['division'],
				'emp_relation'		=>	$inputControl['emp_relation'],
				'rem_notification'	=>	$inputControl['rem_notification'],
				'prescription'		=>	$inputControl['prescription'],
				'signature'			=>	$inputControl['signature'],
				'submit_day'		=>	$inputControl['submit_day'],
				'submit_month'		=>	$inputControl['submit_month'],
				'submit_year'		=>	$inputControl['submit_year'],
				'id'				=>	$order_id,
				'tracking_no'		=>	$inputControl['tracking_no'],
				'order_date'		=>	$inputControl['order_date'],
				'status'			=>	$inputControl['status']
			];


			$sql = "UPDATE rx_medical_orders SET first_name=:first_name, last_name=:last_name, home_phone_no=:home_phone_no,mobile_phone_no=:mobile_phone_no,email=:email,shipping_address_1=:shipping_address_1,shipping_address_2=:shipping_address_2,shipping_city=:shipping_city,shipping_state=:shipping_state,shipping_zip=:shipping_zip,physician_name=:physician_name,physician_ph=:physician_ph,physician_fax=:physician_fax,physician_address=:physician_address,height_12=:height_12,weight_12=:weight_12,birth_day=:birth_day,birth_month=:birth_month,birth_year=:birth_year,are_smoker=:are_smoker,are_breastfeeding=:are_breastfeeding,are_pregnant=:are_pregnant,due_day=:due_day,due_month=:due_month,due_year=:due_year,sex=:sex,have_drug_allergies=:have_drug_allergies,medical_history=:medical_history,employer_name=:employer_name,division=:division,emp_relation=:emp_relation,rem_notification=:rem_notification,prescription=:prescription,signature=:signature,submit_day=:submit_day,submit_month=:submit_month,submit_year=:submit_year,tracking_no=:tracking_no,order_date=:order_date,status=:status WHERE id=:id";

			/** @var PDO $pdo */
			$success 		= 	$db->prepare($sql)->execute($row);

			if($success){

				//delete existing order details
				$stmt = $db->prepare('DELETE from rx_medical_order_items 
				WHERE order_id=:id');
				$stmt->bindParam('id', $order_id);
				$stmt->execute();
				
				$order_count	=	count($order_items);
				if($order_count > 0){
					foreach($order_items as $item){
						
						$row = [
							'order_id' 	=> 	$order_id,
							'medication_name' 		=> 	$item['medication_name'],
							'medication_strength'	=>	$item['medication_strength'],
							'medication_no'			=>	$item['medication_no'],
							'new_medication'		=>	$item['new_medication'],
							'maintenance_drug'		=>	$item['maintenance_drug'],
							'auto_refil'			=>	$item['auto_refil'],
							'status'				=>	1
						];
						$sql	=	"INSERT INTO rx_medical_order_items SET order_id=:order_id,medication_name=:medication_name,medication_strength=:medication_strength,medication_no=:medication_no,new_medication=:new_medication,maintenance_drug=:maintenance_drug,auto_refil=:auto_refil,status=:status;";

						$success_1	= 	$db->prepare($sql)->execute($row);
						
//						if($item['id'] > 0){
//							$row = [
//								'medication_name' 		=> 	$item['medication_name'],
//								'medication_strength'	=>	$item['medication_strength'],
//								'medication_no'			=>	$item['medication_no'],
//								'new_medication'		=>	$item['new_medication'],
//								'maintenance_drug'		=>	$item['maintenance_drug'],
//								'auto_refil'			=>	$item['auto_refil'],
//								'id'					=>	$item['id']
//							];
//							$sql	=	"UPDATE rx_medical_order_items SET medication_name=:medication_name,medication_strength=:medication_strength,medication_no=:medication_no,new_medication=:new_medication,maintenance_drug=:maintenance_drug,auto_refil=:auto_refil WHERE id=:id";
//
//							$success_1		= 	$db->prepare($sql)->execute($row);
//						}
//						else{
//							$row = [
//								'order_id' 	=> 	$order_id,
//								'medication_name' 		=> 	$item['medication_name'],
//								'medication_strength'	=>	$item['medication_strength'],
//								'medication_no'			=>	$item['medication_no'],
//								'new_medication'		=>	$item['new_medication'],
//								'maintenance_drug'		=>	$item['maintenance_drug'],
//								'auto_refil'			=>	$item['auto_refil'],
//								'status'				=>	1
//							];
//							$sql	=	"INSERT INTO rx_medical_order_items SET order_id=:order_id,medication_name=:medication_name,medication_strength=:medication_strength,medication_no=:medication_no,new_medication=:new_medication,maintenance_drug=:maintenance_drug,auto_refil=:auto_refil,status=:status;";
//
//							$success_11		= 	$db->prepare($sql)->execute($row);
//						}
					}
				}
				else{
					$success_1		= true;
				}

				$stmt = $db->prepare('DELETE from rx_medication_items 
				WHERE order_id=:id');
				$stmt->bindParam('id', $order_id);
				$stmt->execute();
				
				$medication_count	=	count($medication_items);
				if($medication_count > 0){
					foreach($medication_items as $medication){
						
						$row = [
							'order_id' 		=> 	$order_id,
							'cur_medication_name' 		=> 	$medication['cur_medication_name'],
							'cur_medication_strength'	=>	$medication['cur_medication_strength'],
							'cur_medication_count'		=>	$medication['cur_medication_count'],
							'cur_medication_long'		=>	$medication['cur_medication_long'],
							'cur_medication_illness'	=>	$medication['cur_medication_illness'],
							'status'					=>	1
						];
						$sql	=	"INSERT INTO rx_medication_items SET order_id=:order_id,cur_medication_name=:cur_medication_name,cur_medication_strength=:cur_medication_strength,cur_medication_count=:cur_medication_count,cur_medication_long=:cur_medication_long,cur_medication_illness=:cur_medication_illness,status=:status;";

						$success_2		= 	$db->prepare($sql)->execute($row);
						
//						if($medication['id'] > 0){
//							$row = [
//								'cur_medication_name' 		=> 	$medication['cur_medication_name'],
//								'cur_medication_strength'	=>	$medication['cur_medication_strength'],
//								'cur_medication_count'		=>	$medication['cur_medication_count'],
//								'cur_medication_long'		=>	$medication['cur_medication_long'],
//								'cur_medication_illness'	=>	$medication['cur_medication_illness'],
//								'id'						=>	$medication['id']
//							];
//							$sql	=	"UPDATE rx_medication_items SET cur_medication_name=:cur_medication_name,cur_medication_strength=:cur_medication_strength,cur_medication_count=:cur_medication_count,cur_medication_long=:cur_medication_long,cur_medication_illness=:cur_medication_illness WHERE id=:id";
//
//							$success_2		= 	$db->prepare($sql)->execute($row);
//						}
//						else{
//							$row = [
//								'order_id' 		=> 	$order_id,
//								'cur_medication_name' 		=> 	$medication['cur_medication_name'],
//								'cur_medication_strength'	=>	$medication['cur_medication_strength'],
//								'cur_medication_count'		=>	$medication['cur_medication_count'],
//								'cur_medication_long'		=>	$medication['cur_medication_long'],
//								'cur_medication_illness'	=>	$medication['cur_medication_illness'],
//								'status'					=>	1
//							];
//							$sql	=	"INSERT INTO rx_medication_items SET order_id=:order_id,cur_medication_name=:cur_medication_name,cur_medication_strength=:cur_medication_strength,cur_medication_count=:cur_medication_count,cur_medication_long=:cur_medication_long,cur_medication_illness=:cur_medication_illness,status=:status;";
//
//							$success_22		= 	$db->prepare($sql)->execute($row);
//						}
					}
				}
				else{
					$success_2		= true;
				}
			}

			if($success && $success_1 && $success_2){



				$order_items		=	$inputControl['order_items'];
				$medication_items	=	$inputControl['medication_items'];

				$order_med_name	=	$order_med_strength = $order_med_no = $order_new_med = $order_maintenance_drug = $order_auto_refil = 	'';
				$cur_med_name	= $cur_med_strength	= $cur_med_count	= $cur_med_long	= $cur_illness = '';

				$order_count	=	count($order_items);
				if($order_count > 0){
					$order_loop_count	=	0;
					foreach($order_items as $item){
						$delimiter	=	($order_loop_count > 0)?'|':'';
						$order_med_name	.= $delimiter.$item['medication_name'];
						$order_med_strength	.= $delimiter.$item['medication_strength'];
						$order_med_no	.= $delimiter.$item['medication_no'];
						$order_new_med	.= $delimiter.$item['new_medication'];
						$order_maintenance_drug	.= $delimiter.$item['maintenance_drug'];
						$order_auto_refil	.= $delimiter.$item['auto_refil'];
						$order_loop_count++;
					}
				}

				$medication_count	=	count($medication_items);
				if($medication_count > 0){
					$medication_loop_count	=	0;
					foreach($medication_items as $medication){
						$delimiter	=	($medication_loop_count > 0)?'|':'';
						$cur_med_name	.= $delimiter.$medication['cur_medication_name'];
						$cur_med_strength	.= $delimiter.$medication['cur_medication_strength'];
						$cur_med_count	.= $delimiter.$medication['cur_medication_count'];
						$cur_med_long	.= $delimiter.$medication['cur_medication_long'];
						$cur_illness	.= $delimiter.$medication['cur_medication_illness']; 
						$medication_loop_count++;
					}
				}




				$relationship = array(
					'employee' => 'Employee / Self',
					'spouse' => 'Spouse / Partner', 
					'dependant' => 'Dependant'
				);
				$notification = array(
					'home-phone' => 'Home phone',
					'mobile-phone' => 'Mobile phone', 
					'email' => 'Email'
				);
				$prescriptions =	array(
					'attached' => 'Upload the script files',
					'fax' => 'I will arrange for my doctor to fax my prescription(s) to (858) 779-2537.', 
					'request' => 'Please fax my doctor to request a copy of my prescription(s)'
				);
				/*.............Active campign Start..................*/

				$url = 'https://rxtoyou.api-us1.com';
				$key='d23525f33c29a6eddfe6e38ef4bf1c0bd82fe710de0d40d96115afafe3923f0fc3175c54';

				$params = array(  
					'api_key'      => $key, 
					'api_action'   => 'contact_sync',
					'api_output'   => 'serialize',
				);

				// here we define the data we are posting in order to perform an update
				$post = array(

					'email'                    => $inputControl['email'],
					'first_name'               => $inputControl['first_name'],
					'last_name'                => $inputControl['last_name'],
					'phone'                    => $inputControl['home_phone_no'],


					// 'form'          => $formid, // Subscription Form ID, to inherit those redirection settings

					'field[%MOBILE_PHONE%,0]' 	=> 	$inputControl['mobile_phone_no'],
					'field[%SHIPPING_ADDRESS_LINE_1%,0]' 		=>	$inputControl['shipping_address_1'],
					'field[%SHIPPING_ADDRESS_LINE_2%,0]' 		=>	$inputControl['shipping_address_2'],
					'field[%SHIPPING_ADDRESS_CITY%,0]' 		=>	$inputControl['shipping_city'],
					'field[%SHIPPING_ADDRESS_STATE%,0]' 		=>	$inputControl['shipping_state'],
					'field[%SHIPPING_ADDRESS_ZIP%,0]' 		=>	$inputControl['shipping_zip'],
					'field[%PRESCRIBING_PHYSICIAN_NAME%,0]' 		=>	$inputControl['physician_name'],
					'field[%PHYSICIAN_PHONE_NUMBER%,0]' 		=>	$inputControl['physician_ph'],
					'field[%PHYSICIAN_FAX_NUMBER%,0]' 		=>	$inputControl['physician_fax'],
					'field[%PHYSICIAN_ADDRESS%,0]' 		=>	$inputControl['physician_address'],
					'field[%HEIGHT%,0]' 		=>	$inputControl['height_12'],
					'field[%WEIGHT%,0]' 		=>	$inputControl['weight_12'],
					'field[%DATE_OF_BIRTH%,0]' 		=>	$inputControl['birth_month'].'/'.$inputControl['birth_day'].'/'.$inputControl['birth_year'],
					'field[%ARE_A_SMOKER%,0]' 		=>	$inputControl['are_smoker'],
					'field[%ARE_BREASTFEEDING%,0]' 		=>	$inputControl['are_breastfeeding'],
					'field[%ARE_PREGNANT%,0]' 		=>	$inputControl['are_pregnant'],
					'field[%DUE_DATE%,0]' 		=>		$inputControl['due_month'].'/'.$inputControl['due_day'].'/'.$inputControl['due_year'],
					'field[%SEX%,0]' 		=>	$inputControl['sex'],
					'field[%DRUG_ALLERGIES%,0]' 		=>	$inputControl['have_drug_allergies'],
					'field[%MEDICAL_HISTORY%,0]' 		=>	$inputControl['medical_history'],
					'field[%NAME_OF_EMPLOYER_GROUP%,0]' 		=>	$inputControl['employer_name'],
					'field[%DIVISION%,0]' 		=>	$inputControl['division'],
					'field[%RELATIONSHIP_TO_EMPLOYER%,0]' 		=>	$relationship[$inputControl['emp_relation']],
					'field[%REFILL_REMINDER_NOTIFICATION_PREFERENCE%,0]' 	=>	$notification[$inputControl['rem_notification']],
					'field[%ORDER_MEDICATION_NAME%,0]' 		=>	$order_med_name,
					'field[%ORDER_MEDICATION_STRENGTH%,0]' 		=>	$order_med_strength,
					'field[%ORDER_HOW_MANY_PER_DAY%,0]' 		=>	$order_med_no,
					'field[%ORDER_NEW_MEDICATION%,0]' 		=>	$order_new_med,
					'field[%ORDER_MAINTENANCE_DRUG%,0]' 		=>	$order_maintenance_drug,
					'field[%ORDERAUTO_REFILL%,0]' 		=>	$order_auto_refil,
					'field[%CURRENT_MEDICATION_NAME%,0]' 		=>	$cur_med_name,
					'field[%CURRENT_MEDICATION_STRENGTH%,0]' 		=>	$cur_med_strength,
					'field[%CURRENT_MEDICATION_HOW_MANY_PER_DAY%,0]' 		=>	$cur_med_count,
					'field[%CURRENT_MEDICATION_HOW_LONG_TAKEN_FOR%,0]' 		=>	$cur_med_long,
					'field[%ILLNESS_OR_CONDITION%,0]' 		=>	$cur_illness,
					'field[%SIGNATURE%,0]' 		=>	$inputControl['signature'],
					'field[%SIGNATURE_DATE%,0]' 		=>	$inputControl['submit_month'].'/'.$inputControl['submit_day'].'/'.$inputControl['submit_year'],
					'field[%TRACKING_NUMBERS%,0]'	=> $inputControl['tracking_no'],
					'field[%SUBMISSION_NUMBER%,0]'	=>	$order_id, 
					'field[%SCRIPT_RECEIVED%,0]' =>	'No',


					'p[4]'                   => 4, // example list ID (REPLACE '123' WITH ACTUAL LIST ID, IE: p[5] = 5)
					'status[4]'              => 1, // 1: active, 2: unsubscribed (REPLACE '123' WITH ACTUAL LIST ID, IE: status[5] = 1)
				);

				// This section takes the input fields and converts them to the proper format

				$query = "";

				foreach( $params as $key => $value ) $query .= urlencode($key) . '=' . urlencode($value) . '&';

				$query = rtrim($query, '& ');

				$data = "";

				foreach( $post as $key => $value ) $data .= urlencode($key) . '=' . urlencode($value) . '&';

				$data = rtrim($data, '& ');


				$url = rtrim($url, '/ ');

				if ( !function_exists('curl_init') ) die('CURL not supported. (introduced in PHP 4.0.2)');


				if ( $params['api_output'] == 'json' && !function_exists('json_decode') ) {

					die('JSON not supported. (introduced in PHP 5.2.0)');

				}

				$api = $url . '/admin/api.php?' . $query;

				$request = curl_init($api); // initiate curl object

				curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response

				curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)

				curl_setopt($request, CURLOPT_POSTFIELDS, $data); // use HTTP POST to send form data

				curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);


				$response = (string)curl_exec($request); 

				curl_close($request); 


				if ( !$response ) {

					die('Nothing was returned. Do you have a connection to Email Marketing server?');

				}

				$result = unserialize($response);


			   /*.............Active campign end..................*/



				return $this->response->withJson(array(
					'status' 	=> 'success',
					'message'	=>	'Order details updated successfully.'
				));
			}
			else if($success){
				return $this->response->withJson(array(
					'status' 	=> 'error',
					'message'	=>	'Order details updation could not be completed. Please contact the service provider.'
				));
			}
			else{
				return $this->response->withJson(array(
					'status' 	=> 'error',
					'message'	=>	'An error occured. Try again later.'
				));
			}
		}
		else{
			return $this->response->withJson(array(
				'status' 	=> 'error',
				'message'	=>	'This order cannot be edit.'
			));
		}
		
    } catch (PDOException $e) {
        return $this->response->withJson($e);
    }
});


//upload order files
$app->post('/admin/orderFiles', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$medication_id	=	$inputControl['order_id'];
	$upload_flag	=	false;
	$files = $request->getUploadedFiles();
	
	$patient_files	=	'';
   	$directory	=	'../../hw-uploads/medication-files';
	
	if($files){
		foreach ($files['file'] as $uploadedFile) {
			if ($uploadedFile->getError() === UPLOAD_ERR_OK) {
				$filename = moveUploadedFiles($directory, $uploadedFile,$medication_id);
				if($filename != ''){
					try {
						$db = new db();
						$db = $db->connect();

						$db->query("SET  CHARACTER SET utf8;");

						$row = [
							'media_type' 	=> 	'medication_files',
							'relation_id'	=>	$medication_id,
							'file_name'		=>	$filename,
							'status'		=>	1
						];

						$media_query	=	'INSERT INTO rx_media_files SET media_type=:media_type, relation_id=:relation_id, file_name=:file_name, status=:status';

						$success		= 	$db->prepare($media_query)->execute($row);
					
						if($success){
							$upload_flag	= true;
						}

					} 
					catch (PDOException $e) {
						return $this->response->withJson($e);
					}
				}
			}
		}
	
		if($upload_flag){
			
			try {
				$db = new db();
				$db = $db->connect();

				$db->query("SET  CHARACTER SET utf8;");

				$dataQuerry = $db->prepare('SELECT email from rx_medical_orders WHERE id=:id'); 
				$dataQuerry->bindParam('id',$medication_id);
				$dataQuerry->execute();
				$email = $dataQuerry->fetch(PDO::FETCH_OBJ);
				
				
				$media_type	=	'medication_files';
				$stmt = $db->prepare('SELECT file_name from media_files WHERE media_type=:media_type AND relation_id=:id ');
				$stmt->bindParam('media_type', $media_type);
				$stmt->bindParam('id', $medication_id);
				$stmt->execute();
				$media_items = $stmt->fetchAll(PDO::FETCH_OBJ);
				foreach($media_items as $media){
					$patient_files .= 'https://www.rxtoyou.com/hw-uploads/medication-files/'.$media->file_name.', ';
				}

			} 
			catch (PDOException $e) {
				//return $this->response->withJson($e);
			}
			
			
			
			/*.............Active campign Start..................*/
		
			$url = 'https://rxtoyou.api-us1.com';
			$key='d23525f33c29a6eddfe6e38ef4bf1c0bd82fe710de0d40d96115afafe3923f0fc3175c54';

			$params = array(  
				'api_key'      => $key, 
				'api_action'   => 'contact_sync',
				'api_output'   => 'serialize',
			);

			// here we define the data we are posting in order to perform an update
			$post = array(

				'email'                    		=> $email->email,
				'field[%SCRIPT_RECEIVED%,0]' 	=>	'Yes',
				'field[%UPLOADED_FILES%,0]' 	=> $patient_files,
				'p[4]'                   => 4, // example list ID (REPLACE '123' WITH ACTUAL LIST ID, IE: p[5] = 5)
				'status[4]'              => 1, // 1: active, 2: unsubscribed (REPLACE '123' WITH ACTUAL LIST ID, IE: status[5] = 1)
			);

			// This section takes the input fields and converts them to the proper format

			$query = "";

			foreach( $params as $key => $value ) $query .= urlencode($key) . '=' . urlencode($value) . '&';

			$query = rtrim($query, '& ');

			$data = "";

			foreach( $post as $key => $value ) $data .= urlencode($key) . '=' . urlencode($value) . '&';

			$data = rtrim($data, '& ');


			$url = rtrim($url, '/ ');

			if ( !function_exists('curl_init') ) die('CURL not supported. (introduced in PHP 4.0.2)');


			if ( $params['api_output'] == 'json' && !function_exists('json_decode') ) {

				die('JSON not supported. (introduced in PHP 5.2.0)');

			}

			$api = $url . '/admin/api.php?' . $query;

			$request = curl_init($api); // initiate curl object

			curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response

			curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)

			curl_setopt($request, CURLOPT_POSTFIELDS, $data); // use HTTP POST to send form data

			curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);


			$response = (string)curl_exec($request); 

			curl_close($request); 


			if ( !$response ) {

				die('Nothing was returned. Do you have a connection to Email Marketing server?');

			}

			$result = unserialize($response);


		   /*.............Active campign end..................*/
			

			return $this->response->withJson(array(
				'status' 	=> 'success',
				'message'	=>	'Your files has been saved.'
			));
		}
		else{
			return $this->response->withJson(array(
				'status' 	=> 'error',
				'message'	=>	'An error occured. Try again later.'
			));
		}
	}
	else{
		return $this->response->withJson(array(
			'status' 	=> 'error',
			'message'	=>	'You need to select atleast one file to upload.'
		));
	}
	
});


$app->post('/admin/exportorder', function(Request $request, Response $response) {

	
	$inputControl 	= 	$request->getParsedBody();
	$order_id		=	$inputControl['order_id'];
	
	$status		=	1;
	$flag		=	'';
	
	$data_array	=	array();
	
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT rxmo.*,rxps.user_id as patient_user_id,rxps.first_name as patient_name,rxg.id as plan_id,rxg.name as plan_name,rxpc.id as company_id,rxpc.name as company_name from rx_medical_orders rxmo
		LEFT JOIN rx_patients rxps ON rxmo.user_id = rxps.user_id
		LEFT JOIN rx_groups rxg ON rxps.group_id = rxg.id
		LEFT JOIN rx_partner_companies rxpc ON rxg.company_id = rxpc.id
		WHERE rxmo.id=:id');
		$stmt->bindParam('id', $order_id);
		$stmt->execute();
		$orders = $stmt->fetchAll(PDO::FETCH_OBJ);
		 
		if(count($orders) > 0){
			$i= 0;
			foreach($orders as $order){
				$stmt = $db->prepare('SELECT * from rx_medical_order_items WHERE order_id=:id');
				$stmt->bindParam('id', $order->id);
				$stmt->execute();
				$order_items = $stmt->fetchAll(PDO::FETCH_OBJ);
				
				$stmt = $db->prepare('SELECT * from rx_medication_items WHERE order_id=:id');
				$stmt->bindParam('id', $order->id);
				$stmt->execute();
				$medication_items = $stmt->fetchAll(PDO::FETCH_OBJ);
				
				$j= 0;
				$medication_names	=	$medication_strengths	= $per_day	=	$new_medication	=	$maintenance_drug	=	$auto_refil	=	'';
				foreach($order_items as $items){
					if($j == 0) $del = '';
					else $del = '|';
					$medication_names		.=	$del.$items->medication_name;
					$medication_strengths	.=	$del.$items->medication_strength;
					$per_day	.=	$del.$items->medication_no;
					$new_medication	.=	$del.$items->new_medication;
					$maintenance_drug	.=	$del.$items->maintenance_drug;
					$auto_refil	.=	$del.$items->auto_refil;
					$j++;
				}
				
				$cur_medication_names = $cur_medication_strengths = $cur_per_day =	$cur_long = $illness = '';
				
				$k= 0;
				foreach($medication_items as $med_items){
					if($k == 0) $del = '';
					else $del = '|';
					$cur_medication_names		.=	$del.$med_items->cur_medication_name;
					$cur_medication_strengths	.=	$del.$med_items->cur_medication_strength;
					$cur_per_day	.=	$del.$med_items->cur_medication_count;
					$cur_long	.=	$del.$med_items->cur_medication_long;
					$illness	.=	$del.$med_items->cur_medication_illness;
					$k++;
				}
				
				
				$data_array[$i]	=	array(
					//'ID'	=> $order->id,
					'No'				=>	$i+1,
					'Order ID'			=>	$order->id,
					'Order Date'		=>	$order->order_date,
					'Patient User ID'	=>	$order->patient_user_id,
					'Plan ID'			=>	$order->plan_id,
					'Plan Name'			=>	$order->plan_name,
					'Partner Company ID'	=>	$order->company_id,
					'Partner Comapny Name'	=>	$order->company_name,
					'First Name'		=>	$order->first_name,
					'Last Name'			=>	$order->last_name,
					'Home Phone No.'	=>	$order->home_phone_no,
					'Mobile Phone No.'	=>	$order->mobile_phone_no,
					'Email'				=>	$order->email,
					'Shipping Address 1'	=>	$order->shipping_address_1,
					'Shipping Address 1'	=>	$order->shipping_address_2,
					'Shipping City'			=>	$order->shipping_city,
					'Shipping State'		=>	$order->shipping_state,
					'Shipping ZIP'			=>	$order->shipping_zip,
					'Physician Name'		=>	$order->physician_name,
					'Physician Phone'		=>	$order->physician_ph,
					'Physician Fax'			=>	$order->physician_fax,
					'Physician Address'		=>	$order->physician_address,
					'Height'				=>	$order->height_12,
					'Weight'				=>	$order->weight_12,
					'Date of Birth'			=>	$order->birth_day.'-'.$order->birth_month.'-'.$order->birth_year,
					'Are You a Smoker?'			=>	$order->are_smoker,
					'Are You Breastfeeding?'		=>	$order->are_breastfeeding,
					'Are You Pregnant?'			=>	$order->are_pregnant,
					'Due Date'				=>	$order->due_day.'-'.$order->due_month.'-'.$order->due_year,
					'Sex'					=>	$order->sex,
					'Drug Allergies Listed'	=>	$order->have_drug_allergies,
					'Medical History'		=>	$order->medical_history,
					'Name of Employer / Plan'			=>	$order->employer_name,
					'Division'				=>	$order->division,
					'Relationship to employer'	=>	$order->emp_relation,
					'Refill Reminder Preference'	=>	$order->rem_notification,
					'Order- Medication Names' 	=> $medication_names,
					'Order- Medication Strengths' 	=> $medication_strengths,
					'Order-	Frequency'	=>	$per_day,
					'Order- New medication'		=>	$new_medication,
					'Maintenance Drug'			=>	$maintenance_drug,
					'Auto Refill'				=> 	$auto_refil,
					'Prescription Type'			=>	$order->prescription,
					'Current- Medication Names' 	=> $cur_medication_names,
					'Current- Medication Strengths' 	=> $cur_medication_strengths,
					'Current- Frequency'		=>	$cur_per_day,
					'Current- How long taken for'		=>	$cur_long,
					'Illness or condition'		=>	$illness,
					'Signature'					=>	$order->signature,
					'Date'			=>	$order->submit_day.'-'.$order->submit_month.'-'.$order->submit_year
					//'Status'		=>	$order->status
				);
				
				$i++;
				
			}
			
			$db = null;
			
			$flag	=	'success';
			$result['details']	=	$data_array;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No orders found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


//delete order 
$app->post('/admin/updateOrderStatus', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$id				=	$inputControl['order_id'];
	$action			=	$inputControl['action'];
	$status			=	1;
	$req_status	=	0;
	$message	='';
	switch($action){
		case 1	:	$req_status	=	0;
					$message	=	'Order status changed.';
					break;
		case 3	:	$status	=	0;
					$message	=	'Order have successfully removed.';
					break;
		default	:	$status		=	1;
	}
	
	$flag		=	'';
    try {
		$db = new db();
		$db = $db->connect();
		$db->query("SET  CHARACTER SET utf8;");
		
		if($action==3){
			$row1 = [
				'id'			=>	$id
			];
			
			$sql1 = "DELETE FROM rx_medical_order_items WHERE order_id=:id ";
			$delete1 	= 	$db->prepare($sql1)->execute($row1);
			
			$sql2 = "DELETE FROM rx_medication_items WHERE order_id=:id ";
			$delete2 	= 	$db->prepare($sql2)->execute($row1);
			
			
			$stmt = $db->prepare('SELECT file_name from rx_media_files WHERE relation_id=:id');
			$stmt->bindParam('id',$id);
			$stmt->execute();
			$file_array = $stmt->fetchAll(PDO::FETCH_OBJ);
			if(count($file_array) > 0){
				foreach($file_array as $file){
					unlink('../../hw-uploads/medication-files/'.$file->file_name);
				}
			}
			
			$sql3 = "DELETE FROM rx_media_files WHERE relation_id=:id ";
			$delete3 	= 	$db->prepare($sql3)->execute($row1);
			
			$sql4 = "DELETE FROM rx_medical_orders WHERE id=:id ";
			$delete4 	= 	$db->prepare($sql4)->execute($row1);
			
			$flag	=	'success';
			$result['msg']	=	$message;
		}
		else{
			$row = [
				'status'		=>	$status,
				'id'			=>	$id
			];
			$sql = "UPDATE rx_medical_orders SET status=:status WHERE id=:id ";
			$success 	= 	$db->prepare($sql)->execute($row);
			
			if($success){
				$flag	=	'success';
				$result['msg']	=	$message;

				if($action==1){
					$row1 = [
						'req_status'	=>	$req_status,
						'id'			=>	$id
					];
					$sql1 = "UPDATE rx_medical_orders SET req_status=:req_status WHERE id=:id ";
					$success1 	= 	$db->prepare($sql1)->execute($row1);
					
					

					$emailQuerry = $db->prepare('SELECT email from rx_medical_orders WHERE id=:id'); 
					$emailQuerry->bindParam('id',$id);
					$emailQuerry->execute();
					$email_array = $emailQuerry->fetch(PDO::FETCH_OBJ);
					
					
					
					$curl = curl_init();

					curl_setopt_array($curl, array(
					  CURLOPT_URL => "https://api.sendgrid.com/v3/mail/send",
					  CURLOPT_RETURNTRANSFER => true,
					  CURLOPT_ENCODING => "",
					  CURLOPT_MAXREDIRS => 10,
					  CURLOPT_TIMEOUT => 30,
					  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
					  CURLOPT_CUSTOMREQUEST => "POST",
					  CURLOPT_POSTFIELDS => "{\n  \"personalizations\": [\n    {\n      \"to\": [\n        {\n          \"email\": \"$email_array->email\"\n        }\n      ],\n      \"subject\": \"Request Approved\"\n    }\n  ],\n  \"from\": {\n    \"email\": \"info@rxtoyou.com\"\n  },\n  \"content\": [\n    {\n      \"type\": \"text/html\",\n      \"value\": \"<p>Your order edit request for id-$id has been approved by admin.</p>\"\n    }\n  ]\n}",
					  CURLOPT_HTTPHEADER => array(
						"authorization: Bearer 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",
						"cache-control: no-cache",
						"content-type: application/json"
					  ),
					));

					$response = curl_exec($curl);
					$err = curl_error($curl);

					curl_close($curl);
					//header('Location: thanks.html');

					if ($err) {
					  echo "cURL Error #:" . $err;
					} else {
					  //echo $response;
					}

					
					
					
					
				}

			}
			else{
				$flag	=	'error';
				$result['msg']	=	'An error occured. Try again later.' ;
			}
		}
		
		
		$db	=	null;	
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});



//list edit request orders in admin 
$app->get('/admin/listallrequests', function(Request $request, Response $response) {
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson(array(
			'status' 	=>  'error',
			'message'	=>	'Invalid Request'
		));
	} 
	
	$status		=	2;
	$req_status		=	1;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT rxmo.id,rxmo.first_name,rxmo.email,rxmo.home_phone_no,physician_name,rxpt.first_name as name,rxmo.status,rxmo.req_status,rxos.status_text from rx_medical_orders rxmo 
		LEFT JOIN rx_patients rxpt ON(rxpt.user_id = rxmo.user_id) 
		LEFT JOIN rx_order_statuses rxos ON(rxos.id = rxmo.status)
		WHERE rxmo.status=:status AND rxmo.REQ_status=:req_status ORDER BY rxmo.id DESC');
		$stmt->bindParam('status', $status);
		$stmt->bindParam('req_status', $req_status);
		$stmt->execute();
		$orders = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($orders) > 0){
			$flag	=	'success';
			$result['details']	=	$orders;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No orders found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});



//count of edit request orders in admin 
$app->post('/admin/getEditRequestCount', function(Request $request, Response $response) {
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson(array(
			'status' 	=>  'error',
			'message'	=>	'Invalid Request'
		));
	} 
	
	$status		=	2;
	$req_status		=	1;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT count(rxmo.id) as request from rx_medical_orders rxmo 
		LEFT JOIN rx_patients rxpt ON(rxpt.user_id = rxmo.user_id) 
		LEFT JOIN rx_order_statuses rxos ON(rxos.id = rxmo.status)
		WHERE rxmo.status=:status AND rxmo.REQ_status=:req_status ORDER BY rxmo.id DESC');
		$stmt->bindParam('status', $status);
		$stmt->bindParam('req_status', $req_status);
		$stmt->execute();
		$orders = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($orders) > 0){
			$flag	=	'success';
			$result['details']	=	$orders[0];
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No orders found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


$app->post('/admin/getPartnerGroups', function(Request $request, Response $response) {
	
	$inputControl	= 	$request->getParsedBody();
	$company_slug		=	$inputControl['company_slug'];
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson('Invalid Request');
	}
	
	$status			=	1;
	$status_2		=	2;
	$flag		=	'';
	try {

		$db = new db();
		$db = $db->connect();

		$db->query("SET  CHARACTER SET utf8;");

		$stmt = $db->prepare('SELECT rx_groups.id,
		rx_groups.name,
		rx_partner_companies.name as partner_name,
		rx_partner_companies.status as partner_status,
		rx_groups.status
		FROM rx_groups 
		LEFT JOIN rx_partner_companies ON (rx_partner_companies.id = rx_groups.company_id)
		WHERE rx_groups.company_id=(SELECT id FROM rx_partner_companies WHERE slug=:slug) AND (rx_groups.status=:status OR rx_groups.status=:status_2) ORDER BY rx_groups.id DESC ');
		$stmt->bindParam('slug', $company_slug);
		$stmt->bindParam('status', $status);
		$stmt->bindParam('status_2', $status_2);
		$stmt->execute();
		$groups = $stmt->fetchAll(PDO::FETCH_OBJ); 

		$db = null; 

		if(count($groups) > 0){
			$flag	=	'success';
			$result['details']	=	$groups;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No groups/plans found.';
		}

		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));


	} catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
	}
}); 


//admin - get active partner plans
$app->post('/admin/getActivePartnerGroups', function(Request $request, Response $response) {
	
	$inputControl	= 	$request->getParsedBody();
	$group_id	=	$inputControl['group_id'];
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson('Invalid Request');
	}
	
	$status			=	1;
	$flag		=	'';
	try {

		$db = new db();
		$db = $db->connect();

		$db->query("SET  CHARACTER SET utf8;");

		$stmt = $db->prepare('SELECT rx_groups.id,
		rx_groups.name,
		rx_partner_companies.name as partner_name,
		rx_partner_companies.status as partner_status,
		rx_groups.status
		FROM rx_groups 
		LEFT JOIN rx_partner_companies ON (rx_partner_companies.id = rx_groups.company_id)
		WHERE rx_groups.company_id=(SELECT company_id FROM rx_groups WHERE id=:plan_id) AND rx_groups.status=:status ORDER BY rx_groups.id DESC ');
		$stmt->bindParam('plan_id', $group_id);
		$stmt->bindParam('status', $status);
		$stmt->execute();
		$groups = $stmt->fetchAll(PDO::FETCH_OBJ); 

		$db = null; 

		if(count($groups) > 0){
			$flag	=	'success';
			$result['details']	=	$groups;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No groups/plans found.';
		}

		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));


	} catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
	}
}); 


//admin - get active partner plans
$app->post('/admin/getActivePartnerGroupsbyPatient', function(Request $request, Response $response) {
	
	$inputControl	= 	$request->getParsedBody();
	$patient_user_id	=	$inputControl['patient_user_id'];
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson('Invalid Request');
	}
	
	$status1			=	1;
	$flag		=	'';
	$company_id = getCompanyIdbyPatient($patient_user_id);
	try {

		$db = new db();
		$db = $db->connect();

		$db->query("SET  CHARACTER SET utf8;");

		$stmt = $db->prepare('SELECT rx_groups.id,
		rx_groups.name,
		rx_groups.status
		FROM rx_groups 
		WHERE rx_groups.company_id=:company_id AND rx_groups.status=:status1 GROUP BY rx_groups.id ORDER BY rx_groups.id DESC');
		$stmt->bindParam('company_id', $company_id);
		$stmt->bindParam('status1', $status1);
		$stmt->execute();
		$groups = $stmt->fetchAll(PDO::FETCH_OBJ); 

		$db = null; 

		if(count($groups) > 0){
			$flag	=	'success';
			$result['details']	=	$groups;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No groups/plans found.';
		}

		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));


	} catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
	}
}); 



//assign orders to a patient ----- Authenticate 
$app->post('/admin/assignOrdertoPatient', function(Request $request, Response $response) {
	
	$inputControl 		= $request->getParsedBody();
	$patient_user_id	=	$inputControl['patient_user_id'];
	$order_id			=	$inputControl['order_id'];
	
	$status		=	$message = '';
	
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
	
	
		$stmt = $db->prepare('SELECT rxps.email,rxg.name as plan_name
		from rx_patients rxps
		LEFT JOIN rx_groups rxg ON rxps.group_id = rxg.id
		WHERE rxps.user_id=:user_id');
		$stmt->bindParam('user_id', $patient_user_id);
		$stmt->execute();
		$patient_data = $stmt->fetch(PDO::FETCH_OBJ);
		
		if(isset($patient_data)){
			$row = [
				'user_id'		=>	$patient_user_id,
				'email'			=>	$patient_data->email,
				'employer_name'	=>	$patient_data->plan_name,
				'id'			=>	$order_id
			];
			$sql = "UPDATE rx_medical_orders SET user_id=:user_id,email=:email,employer_name=:employer_name WHERE id=:id ";
			$success 	= 	$db->prepare($sql)->execute($row);
			if($success){
				$status = 'success';
				$message = 'Order has been successfully assigned to '.$patient_data->email.'.';
			}
			else{
				$status = 'error';
				$message = 'An error occured. Please try again';
			}
			
		}
		else{
			$status = 'error';
			$message = 'An error occured. Please try again';
		}
		return $this->response->withJson(array(
			'status' 	=> 	$status,
			'message'	=>	$message
		));
		
	}
	catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
	}
});
?>
