<?php

use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use \Firebase\JWT\JWT;
use Slim\Http\UploadedFile;

//Save order for patients
$app->post('/patient/saveorder', function(Request $request, Response $response) {

    $inputControl = $request->getParsedBody();
   	

	$order_items		=	$inputControl['order_items'];
	$medication_items	=	$inputControl['medication_items'];

	$order_med_name	=	$order_med_strength = $order_med_no = $order_new_med = $order_maintenance_drug = $order_auto_refil = 	'';
	$cur_med_name	= $cur_med_strength	= $cur_med_count	= $cur_med_long	= $cur_illness = '';
	//echo $first_name;
	
	$user_id = $inputControl['user_id'];
	//$user_id = 27;
	
	
	try {
		$db = new db();
		$db = $db->connect();


		$row = [
			'user_id' 	=> $user_id,
			'first_name' 	=> $inputControl['first_name'],
			'last_name' 	=> $inputControl['last_name'],
			'home_phone_no' => $inputControl['home_phone_no'],
			'mobile_phone_no'	=>			$inputControl['mobile_phone_no'],
			'email'				=>	$inputControl['email'],
			'shipping_address_1'		=>	$inputControl['shipping_address_1'],
			'shipping_address_2'		=>	$inputControl['shipping_address_2'],
			'shipping_city'		=>	$inputControl['shipping_city'],
			'shipping_state'	=>	$inputControl['shipping_state'],
			'shipping_zip'		=>	$inputControl['shipping_zip'],
			'physician_name'	=>	$inputControl['physician_name'],
			'physician_ph'		=>	$inputControl['physician_ph'],
			'physician_fax'		=>	$inputControl['physician_fax'],
			'physician_address'	=>	$inputControl['physician_address'],
			'height_12'		=>	$inputControl['height_12'],
			'weight_12'		=>	$inputControl['weight_12'],
			'birth_day'		=>	$inputControl['birth_day'],
			'birth_month'		=>	$inputControl['birth_month'],
			'birth_year'		=>	$inputControl['birth_year'],
			'are_smoker'		=>	$inputControl['are_smoker'],
			'are_breastfeeding'	=>	$inputControl['are_breastfeeding'],
			'are_pregnant'		=>	$inputControl['are_pregnant'],
			'due_day'		=>	$inputControl['due_day'],
			'due_month'		=>	$inputControl['due_month'],
			'due_year'		=>	$inputControl['due_year'],
			'sex'			=>	$inputControl['sex'],
			'have_drug_allergies'	=>	$inputControl['have_drug_allergies'],
			'medical_history'		=>	$inputControl['medical_history'],
			'employer_name'		=>	$inputControl['employer_name'],
			'division'			=>	$inputControl['division'],
			'emp_relation'		=>	$inputControl['emp_relation'],
			'rem_notification'	=>	$inputControl['rem_notification'],
			'prescription'		=>	$inputControl['prescription'],
			'signature'			=>	$inputControl['signature'],
			'submit_day'		=>	$inputControl['submit_day'],
			'submit_month'		=>	$inputControl['submit_month'],
			'submit_year'		=>	$inputControl['submit_year'],
			'type'				=>	'patient',
			'order_date' 		=>	date('Y-m-d'),
			'status'			=>	$inputControl['status']
		];

		$sql = "INSERT INTO rx_medical_orders SET user_id=:user_id,first_name=:first_name, last_name=:last_name, home_phone_no=:home_phone_no,mobile_phone_no=:mobile_phone_no,email=:email,shipping_address_1=:shipping_address_1,shipping_address_2=:shipping_address_2,shipping_city=:shipping_city,shipping_state=:shipping_state,shipping_zip=:shipping_zip,physician_name=:physician_name,physician_ph=:physician_ph,physician_fax=:physician_fax,physician_address=:physician_address,height_12=:height_12,weight_12=:weight_12,birth_day=:birth_day,birth_month=:birth_month,birth_year=:birth_year,are_smoker=:are_smoker,are_breastfeeding=:are_breastfeeding,are_pregnant=:are_pregnant,due_day=:due_day,due_month=:due_month,due_year=:due_year,sex=:sex,have_drug_allergies=:have_drug_allergies,medical_history=:medical_history,employer_name=:employer_name,division=:division,emp_relation=:emp_relation,rem_notification=:rem_notification,prescription=:prescription,signature=:signature,submit_day=:submit_day,submit_month=:submit_month,submit_year=:submit_year,type=:type,order_date=:order_date,status=:status;";

		/** @var PDO $pdo */
		$success 		= 	$db->prepare($sql)->execute($row);
		$order_id 	= 	$db->lastInsertId();
		
		if($order_id){
			
			$pass = substr(str_shuffle("0123456789abcdefghijklmnopqrstvwxyz"), 0, 6);
			$unique_key	=	 base64_encode($inputControl['email'].'&'.$order_id.'&'.$pass);
			
			$updateQuerry = $db->prepare('UPDATE rx_medical_orders SET unique_key=:unique_key WHERE id=:id');
			$updateQuerry->bindParam('unique_key',$unique_key);
			$updateQuerry->bindParam('id',$order_id);
			$updateQuerry->execute();
			
			
			$order_count	=	count($order_items);
			if($order_count > 0){
				$order_loop_count	=	0;
				foreach($order_items as $item){
					$delimiter	=	($order_loop_count > 0)?'|':'';
					$order_med_name	.= $delimiter.$item['medication_name'];
					$order_med_strength	.= $delimiter.$item['medication_strength'];
					$order_med_no	.= $delimiter.$item['medication_no'];
					$order_new_med	.= $delimiter.$item['new_medication'];
					$order_maintenance_drug	.= $delimiter.$item['maintenance_drug'];
					$order_auto_refil	.= $delimiter.$item['auto_refil'];
					$row = [
						'order_id' 	=> 	$order_id,
						'medication_name' 		=> 	$item['medication_name'],
						'medication_strength'	=>	$item['medication_strength'],
						'medication_no'			=>	$item['medication_no'],
						'new_medication'		=>	$item['new_medication'],
						'maintenance_drug'		=>	$item['maintenance_drug'],
						'auto_refil'			=>	$item['auto_refil'],
						'status'				=>	1
					];
					$sql	=	"INSERT INTO rx_medical_order_items SET order_id=:order_id,medication_name=:medication_name,medication_strength=:medication_strength,medication_no=:medication_no,new_medication=:new_medication,maintenance_drug=:maintenance_drug,auto_refil=:auto_refil,status=:status;";
					
					$success_1		= 	$db->prepare($sql)->execute($row);
					$order_loop_count++;
				}
			}
			else{
			    $success_1 = true;
			}
			
			$medication_count	=	count($medication_items);
			if($medication_count > 0){
				$medication_loop_count	=	0;
				foreach($medication_items as $medication){
					$delimiter	=	($medication_loop_count > 0)?'|':'';
					$cur_med_name	.= $delimiter.$medication['cur_medication_name'];
					$cur_med_strength	.= $delimiter.$medication['cur_medication_strength'];
					$cur_med_count	.= $delimiter.$medication['cur_medication_count'];
					$cur_med_long	.= $delimiter.$medication['cur_medication_long'];
					$cur_illness	.= $delimiter.$medication['cur_medication_illness']; 
					$row = [
						'order_id' 					=> 	$order_id,
						'cur_medication_name' 		=> 	$medication['cur_medication_name'],
						'cur_medication_strength'	=>	$medication['cur_medication_strength'],
						'cur_medication_count'		=>	$medication['cur_medication_count'],
						'cur_medication_long'		=>	$medication['cur_medication_long'],
						'cur_medication_illness'	=>	$medication['cur_medication_illness'],
						'status'					=>	1
					];
					$sql	=	"INSERT INTO rx_medication_items SET order_id=:order_id,cur_medication_name=:cur_medication_name,cur_medication_strength=:cur_medication_strength,cur_medication_count=:cur_medication_count,cur_medication_long=:cur_medication_long,cur_medication_illness=:cur_medication_illness,status=:status;";
					
					$success_2		= 	$db->prepare($sql)->execute($row);
					$medication_loop_count++;
				}
			}
			else{
			    $success_2 = true;
			}
			
			
			
			
			$relationship = array(
				'employee' => 'Employee / Self',
				'spouse' => 'Spouse / Partner', 
				'dependant' => 'Dependant'
			);
			$notification = array(
			  	'home-phone' => 'Home phone',
				'mobile-phone' => 'Mobile phone', 
				'email' => 'Email'
			);
			$prescriptions =	array(
			  	'attached' => 'Upload the script files',
				'fax' => 'I will arrange for my doctor to fax my prescription(s) to (858) 779-2537.', 
				'request' => 'Please fax my doctor to request a copy of my prescription(s)'
			);

			
			
			$stmt = $db->prepare('SELECT rx_partner_companies.name,license_no from rx_partner_companies LEFT JOIN rx_groups ON (rx_groups.company_id = rx_partner_companies.id) LEFT JOIN rx_patients ON (rx_patients.group_id = rx_groups.id) WHERE rx_patients.user_id=:user_id');
			$stmt->bindParam('user_id',$user_id);
			$stmt->execute();
			$company_details = $stmt->fetchAll(PDO::FETCH_OBJ);
			$comapny_name = $license_no ='';
			if(count($company_details) > 0){
				$comapny_name = $company_details[0]->name;
				$license_no = $company_details[0]->license_no;
			}
			
			
			/*.............Active campign Start..................*/
		
			$url = 'https://rxtoyou.api-us1.com';
			$key='d23525f33c29a6eddfe6e38ef4bf1c0bd82fe710de0d40d96115afafe3923f0fc3175c54';

			$params = array(  
				'api_key'      => $key, 
				'api_action'   => 'contact_sync',
				'api_output'   => 'serialize',
			);

			// here we define the data we are posting in order to perform an update
			$post = array(

				'email'                    => $inputControl['email'],
				'first_name'               => $inputControl['first_name'],
				'last_name'                => $inputControl['last_name'],
				'phone'                    => $inputControl['home_phone_no'],


				// 'form'          => $formid, // Subscription Form ID, to inherit those redirection settings

				'field[%MOBILE_PHONE%,0]' 	=> 	$inputControl['mobile_phone_no'],
				'field[%SHIPPING_ADDRESS_LINE_1%,0]' 		=>	$inputControl['shipping_address_1'],
				'field[%SHIPPING_ADDRESS_LINE_2%,0]' 		=>	$inputControl['shipping_address_2'],
				'field[%SHIPPING_ADDRESS_CITY%,0]' 		=>	$inputControl['shipping_city'],
				'field[%SHIPPING_ADDRESS_STATE%,0]' 		=>	$inputControl['shipping_state'],
				'field[%SHIPPING_ADDRESS_ZIP%,0]' 		=>	$inputControl['shipping_zip'],
				'field[%PRESCRIBING_PHYSICIAN_NAME%,0]' 		=>	$inputControl['prescribing_physician_name'],
				'field[%PHYSICIAN_PHONE_NUMBER%,0]' 		=>	$inputControl['physician_ph'],
				'field[%PHYSICIAN_FAX_NUMBER%,0]' 		=>	$inputControl['physician_fax'],
				'field[%PHYSICIAN_ADDRESS%,0]' 		=>	$inputControl['physician_address'],
				'field[%HEIGHT%,0]' 		=>	$inputControl['height_12'],
				'field[%WEIGHT%,0]' 		=>	$inputControl['weight_12'],
				'field[%DATE_OF_BIRTH%,0]' 		=>	$inputControl['birth_month'].'/'.$inputControl['birth_day'].'/'.$inputControl['birth_year'],
				'field[%ARE_A_SMOKER%,0]' 		=>	$inputControl['are_smoker'],
				'field[%ARE_BREASTFEEDING%,0]' 		=>	$inputControl['are_breastfeeding'],
				'field[%ARE_PREGNANT%,0]' 		=>	$inputControl['are_pregnant'],
				'field[%DUE_DATE%,0]' 		=>		$inputControl['due_month'].'/'.$inputControl['due_day'].'/'.$inputControl['due_year'],
				'field[%SEX%,0]' 		=>	$inputControl['sex'],
				'field[%DRUG_ALLERGIES%,0]' 		=>	$inputControl['have_drug_allergies'],
				'field[%MEDICAL_HISTORY%,0]' 		=>	$inputControl['medical_history'],
				'field[%NAME_OF_EMPLOYER_GROUP%,0]' 		=>	$inputControl['employer_name'],
				'field[%DIVISION%,0]' 		=>	$inputControl['division'],
				'field[%RELATIONSHIP_TO_EMPLOYER%,0]' 		=>	$relationship[$inputControl['emp_relation']],
				'field[%REFILL_REMINDER_NOTIFICATION_PREFERENCE%,0]' 	=>	$notification[$inputControl['rem_notification']],
				'field[%ORDER_MEDICATION_NAME%,0]' 		=>	$order_med_name,
				'field[%ORDER_MEDICATION_STRENGTH%,0]' 		=>	$order_med_strength,
				'field[%ORDER_HOW_MANY_PER_DAY%,0]' 		=>	$order_med_no,
				'field[%ORDER_NEW_MEDICATION%,0]' 		=>	$order_new_med,
				'field[%ORDER_MAINTENANCE_DRUG%,0]' 		=>	$order_maintenance_drug,
				'field[%ORDERAUTO_REFILL%,0]' 		=>	$order_auto_refil,
				'field[%CURRENT_MEDICATION_NAME%,0]' 		=>	$cur_med_name,
				'field[%CURRENT_MEDICATION_STRENGTH%,0]' 		=>	$cur_med_strength,
				'field[%CURRENT_MEDICATION_HOW_MANY_PER_DAY%,0]' 		=>	$cur_med_count,
				'field[%CURRENT_MEDICATION_HOW_LONG_TAKEN_FOR%,0]' 		=>	$cur_med_long,
				'field[%ILLNESS_OR_CONDITION%,0]' 		=>	$cur_illness,
				'field[%SIGNATURE%,0]' 		=>	$inputControl['signature'],
				'field[%SIGNATURE_DATE%,0]' 		=>	$inputControl['submit_month'].'/'.$inputControl['submit_day'].'/'.$inputControl['submit_year'],
				'field[%ORDER_TYPE%,0]'	=> 'Web',
				'field[%SUBMISSION_NUMBER%,0]'	=>	$order_id, 
				'field[%SCRIPT_RECEIVED%,0]' =>	'No',
				'field[%PARTNER%,0]' => $comapny_name,
				'field[%PARTNER_LICENSE_NUMBER%,0]' => $license_no,

				'p[4]'                   => 4, // example list ID (REPLACE '123' WITH ACTUAL LIST ID, IE: p[5] = 5)
				'status[4]'              => 1, // 1: active, 2: unsubscribed (REPLACE '123' WITH ACTUAL LIST ID, IE: status[5] = 1)
			);

			// This section takes the input fields and converts them to the proper format

			$query = "";

			foreach( $params as $key => $value ) $query .= urlencode($key) . '=' . urlencode($value) . '&';

			$query = rtrim($query, '& ');

			$data = "";

			foreach( $post as $key => $value ) $data .= urlencode($key) . '=' . urlencode($value) . '&';

			$data = rtrim($data, '& ');


			$url = rtrim($url, '/ ');

			if ( !function_exists('curl_init') ) die('CURL not supported. (introduced in PHP 4.0.2)');


			if ( $params['api_output'] == 'json' && !function_exists('json_decode') ) {

				die('JSON not supported. (introduced in PHP 5.2.0)');

			}

			$api = $url . '/admin/api.php?' . $query;

			$request = curl_init($api); // initiate curl object

			curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response

			curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)

			curl_setopt($request, CURLOPT_POSTFIELDS, $data); // use HTTP POST to send form data

			curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);


			$response = (string)curl_exec($request); 

			curl_close($request); 


			if ( !$response ) {

				die('Nothing was returned. Do you have a connection to Email Marketing server?');

			}

			$result = unserialize($response);


		   /*.............Active campign end..................*/

			
			
			
		}
		
		if($success && $success_1 && $success_2){
			if($inputControl['prescription'] == 'attached'){
				$message = "We have saved this information and you'll be redirected to upload your files.";
			}
			else{
				$message = "Your order has been saved.";
			}
			return $this->response->withJson(array(
				'status' 	=> 'success',
				'message'	=>	$message,
				'details'	=>	array(
					'medication_id'	=>	$order_id,
					'email'			=>	$inputControl['email'],
					'unique_key'	=>	$unique_key
				)
			));
		}
		else if($success){
			return $this->response->withJson(array(
				'status' 	=> 'error',
				'message'	=>	'Your order could not be completed. Please contact the administrator.'
			));
		}
		else{
			return $this->response->withJson(array(
				'status' 	=> 'error',
				'message'	=>	'An error occured. Try again later.'
			));
		}
		

		
    } catch (PDOException $e) {
        return $this->response->withJson($e);
    }
});


$app->post('/patient/orderFiles', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$medication_id	=	$inputControl['order_id'];
	$upload_flag	=	false;
	$files = $request->getUploadedFiles();
	
	
	$patient_files	=	'';
   	$directory	=	'../../hw-uploads/medication-files';
	
	if($files){
		foreach ($files['file'] as $uploadedFile) {
			if ($uploadedFile->getError() === UPLOAD_ERR_OK) {
				$filename = moveUploadedFiles($directory, $uploadedFile,$medication_id);
				if($filename != ''){
					try {
						$db = new db();
						$db = $db->connect();

						$db->query("SET  CHARACTER SET utf8;");

						$row = [
							'media_type' 	=> 	'medication_files',
							'relation_id'	=>	$medication_id,
							'file_name'		=>	$filename,
							'status'		=>	1
						];

						$media_query	=	'INSERT INTO rx_media_files SET media_type=:media_type, relation_id=:relation_id, file_name=:file_name, status=:status';

						$success		= 	$db->prepare($media_query)->execute($row);
					
						if($success){
							$upload_flag	= true;
						}

					} 
					catch (PDOException $e) {
						return $this->response->withJson($e);
					}
				}
			}
		}
	
		if($upload_flag){
			
			try {
				$db = new db();
				$db = $db->connect();

				$db->query("SET  CHARACTER SET utf8;");

				$dataQuerry = $db->prepare('SELECT email from rx_medical_orders WHERE id=:id'); 
				$dataQuerry->bindParam('id',$medication_id);
				$dataQuerry->execute();
				$email = $dataQuerry->fetch(PDO::FETCH_OBJ);
				
				
				$media_type	=	'medication_files';
				$stmt = $db->prepare('SELECT file_name from rx_media_files WHERE media_type=:media_type AND relation_id=:id ');
				$stmt->bindParam('media_type', $media_type);
				$stmt->bindParam('id', $medication_id);
				$stmt->execute();
				$media_items = $stmt->fetchAll(PDO::FETCH_OBJ);
				foreach($media_items as $media){
					$patient_files .= 'https://www.rxtoyou.com/hw-uploads/medication-files/'.$media->file_name.', ';
				}

			} 
			catch (PDOException $e) {
				//return $this->response->withJson($e);
			}
			
			
			
			/*.............Active campign Start..................*/
		
			$url = 'https://rxtoyou.api-us1.com';
			$key='d23525f33c29a6eddfe6e38ef4bf1c0bd82fe710de0d40d96115afafe3923f0fc3175c54';

			$params = array(  
				'api_key'      => $key, 
				'api_action'   => 'contact_sync',
				'api_output'   => 'serialize',
			);

			// here we define the data we are posting in order to perform an update
			$post = array(

				'email'                    		=> $email->email,
				'field[%SCRIPT_RECEIVED%,0]' 	=>	'Yes',
				'field[%UPLOADED_FILES%,0]' 	=> $patient_files,
				'p[4]'                   => 4, // example list ID (REPLACE '123' WITH ACTUAL LIST ID, IE: p[5] = 5)
				'status[4]'              => 1, // 1: active, 2: unsubscribed (REPLACE '123' WITH ACTUAL LIST ID, IE: status[5] = 1)
			);

			// This section takes the input fields and converts them to the proper format

			$query = "";

			foreach( $params as $key => $value ) $query .= urlencode($key) . '=' . urlencode($value) . '&';

			$query = rtrim($query, '& ');

			$data = "";

			foreach( $post as $key => $value ) $data .= urlencode($key) . '=' . urlencode($value) . '&';

			$data = rtrim($data, '& ');


			$url = rtrim($url, '/ ');

			if ( !function_exists('curl_init') ) die('CURL not supported. (introduced in PHP 4.0.2)');


			if ( $params['api_output'] == 'json' && !function_exists('json_decode') ) {

				die('JSON not supported. (introduced in PHP 5.2.0)');

			}

			$api = $url . '/admin/api.php?' . $query;

			$request = curl_init($api); // initiate curl object

			curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response

			curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)

			curl_setopt($request, CURLOPT_POSTFIELDS, $data); // use HTTP POST to send form data

			curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);


			$response = (string)curl_exec($request); 

			curl_close($request); 


			if ( !$response ) {

				die('Nothing was returned. Do you have a connection to Email Marketing server?');

			}

			$result = unserialize($response);


		   /*.............Active campign end..................*/
			

			return $this->response->withJson(array(
				'status' 	=> 'success',
				'message'	=>	'Your files has been saved.'
			));
		}
		else{
			return $this->response->withJson(array(
				'status' 	=> 'error',
				'message'	=>	'An error occured. Try again later.'
			));
		}
	}
	else{
		return $this->response->withJson(array(
			'status' 	=> 'error',
			'message'	=>	'You need to select atleast one file to upload.'
		));
	}
	
});

//list patient orders
$app->post('/patient/listpatientorders', function(Request $request, Response $response) {
	
	if(!isset($_SERVER['HTTP_REFERER'])){
		return $this->response->withJson(array(
			'status' 	=>  'error',
			'message'	=>	'Invalid Request'
		));
	}
	$inputControl	= 	$request->getParsedBody();
	$user_id	=	$inputControl['user_id'];
	
	$status		=	0;
	$flag		=	'';
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT rxmo.id,
		first_name,
		email,
		home_phone_no,
		physician_name,
		type,
		rxmo.order_date,
		rxmo.status,
		rxmo.req_status,
		rxos.status_text,
		GROUP_CONCAT(medication_name) medication_name
		from rx_medical_orders rxmo
		LEFT JOIN rx_order_statuses rxos ON (rxos.id = rxmo.status)
		LEFT JOIN rx_medical_order_items rxmoi ON (rxmo.id = rxmoi.order_id)
		WHERE user_id=:user_id AND rxmo.status!=:status GROUP BY rxmo.id ORDER BY rxmo.id DESC');
		$stmt->bindParam('user_id', $user_id);
		$stmt->bindParam('status', $status);
		$stmt->execute();
		$orders = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		$db = null;
		 
		if(count($orders) > 0){
			$flag	=	'success';
			$result['details']	=	$orders;
			$result['msg']	=	'Success.';
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No orders found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});

//get order details of patient
$app->post('/patient/getorderdetails', function(Request $request, Response $response) {
	
	$inputControl 	= $request->getParsedBody();
	$order_id		=	$inputControl['order_id'];
	$user_id		=	$inputControl['user_id'];
	
	$order_items	=	$medication_items = array();
	$status		=	1;
	$flag		=	'';
	$partner_id	=	$license_no	=	0;
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT rxmo.*,rxos.status_text from rx_medical_orders rxmo
		LEFT JOIN rx_order_statuses rxos ON (rxmo.status = rxos.id) WHERE rxmo.id=:id AND rxmo.user_id=:user_id ');
		$stmt->bindParam('id', $order_id);
		$stmt->bindParam('user_id', $user_id);
		$stmt->execute();
		$orders = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		if(count($orders) > 0){
			$flag	=	'success';
			$result['msg']	=	'Success.';
			
			$result['type'] = $orders[0]->type;
	
			$stmt = $db->prepare('SELECT * from rx_medical_order_items WHERE order_id=:id ');
			$stmt->bindParam('id', $order_id);
			$stmt->execute();
			$order_items = $stmt->fetchAll(PDO::FETCH_OBJ);
			
			
			$media_type	=	'medication_files';
			$stmt = $db->prepare('SELECT file_name from rx_media_files WHERE media_type=:media_type AND relation_id=:id ');
			$stmt->bindParam('media_type', $media_type);
			$stmt->bindParam('id', $order_id);
			$stmt->execute();
			$media_items = $stmt->fetchAll(PDO::FETCH_OBJ);
			
			if(count($media_items) > 0){
				$result['media_items']	=	$media_items;
			}
			
			$stmt = $db->prepare('SELECT * from rx_medication_items WHERE order_id=:id ');
			$stmt->bindParam('id', $order_id);
			$stmt->execute();
			$medication_items = $stmt->fetchAll(PDO::FETCH_OBJ);
			 
			$db = null;
			
			$result['details']	=	array(
				'id'			=>	$orders[0]->id,
				'first_name'	=>	$orders[0]->first_name,
				'last_name'		=>	$orders[0]->last_name,
				'home_phone_no'	=>	$orders[0]->home_phone_no,
				'mobile_phone_no'	=>	$orders[0]->mobile_phone_no,
				'email'				=>	$orders[0]->email,
				'shipping_address_1'	=>	$orders[0]->shipping_address_1,
				'shipping_address_2'	=>	$orders[0]->shipping_address_2,
				'shipping_city'			=>	$orders[0]->shipping_city,
				'shipping_state'		=>	$orders[0]->shipping_state,
				'shipping_zip'			=>	$orders[0]->shipping_zip,
				'physician_name'		=>	$orders[0]->physician_name,
				'physician_ph'			=>	$orders[0]->physician_ph,
				'physician_fax'			=>	$orders[0]->physician_fax,
				'physician_address'		=>	$orders[0]->physician_address,
				'height_12'				=>	$orders[0]->height_12,
				'weight_12'				=>	$orders[0]->weight_12,
				'birth_month'			=>	$orders[0]->birth_month,
				'birth_day'				=>	$orders[0]->birth_day,
				'birth_year'			=>	$orders[0]->birth_year,
				'are_smoker'			=>	$orders[0]->are_smoker,
				'are_breastfeeding'		=>	$orders[0]->are_breastfeeding,
				'are_pregnant'			=>	$orders[0]->are_pregnant,
				'due_month'				=>	$orders[0]->due_month,
				'due_day'				=>	$orders[0]->due_day,
				'due_year'				=>	$orders[0]->due_year,
				'sex'					=>	$orders[0]->sex,
				'have_drug_allergies'	=>	$orders[0]->have_drug_allergies,
				'medical_history'		=>	$orders[0]->medical_history,
				'employer_name'			=>	$orders[0]->employer_name,
				'division'				=>	$orders[0]->division,
				'emp_relation'			=>	$orders[0]->emp_relation,
				'rem_notification'		=>	$orders[0]->rem_notification,
				'order_items'			=>	$order_items,
				'prescription'			=> 	$orders[0]->prescription,
				'medication_items'		=>	$medication_items,
				'signature'				=> 	$orders[0]->signature,
				'submit_month'			=> 	$orders[0]->submit_month,
				'submit_day'			=> 	$orders[0]->submit_day,
				'submit_year'			=> 	$orders[0]->submit_year,
				'unique_key'			=> 	$orders[0]->unique_key,
				'tracking_no'			=> 	$orders[0]->tracking_no,
				'status_text'			=> 	$orders[0]->status_text
			);
			$result['order_status']		=	$orders[0]->status;
			
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No details found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {

		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});

//submitting orders
$app->post('/patient/updateOrderStatus', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$id				=	$inputControl['order_id'];
	$action				=	$inputControl['action'];
	$status		=	1;
	$message	='';
	switch($action){
		case 2	:	$status	=	2;
							$message	=	'Order has been successfully submitted.';
							break;
		case 3	:	$status	=	0;
							$message	=	'Order have successfully removed.';
							break;
		default			:	$status		=	1;
	}
	
	$flag		=	'';
    try {
		$db = new db();
		$db = $db->connect();
		$db->query("SET  CHARACTER SET utf8;");
		$row = [
			'status'		=>	$status,
			'id'			=>	$id
		];
		$sql = "UPDATE rx_medical_orders SET status=:status WHERE id=:id ";
		/** @var PDO $pdo */
		$success 	= 	$db->prepare($sql)->execute($row);
		$db	=	null;	
	
		if($success){
			$flag	=	'success';
			$result['msg']	=	$message;
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'An error occured. Try again later.' ;
		}
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
    } catch (PDOException $e) {
		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


//get patient details for order
$app->post('/patient/getPatientDetailsforOrder', function(Request $request, Response $response) {
	
	$inputControl 	= $request->getParsedBody();
	$user_id		=	$inputControl['user_id'];
	
	$order_items	=	$medication_items = array();
	$status		=	1;
	$flag		=	'';
	$partner_id	=	$license_no	=	0;
    try {

		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$stmt = $db->prepare('SELECT rxus.username as email,rxgp.name from rx_users rxus
		LEFT JOIN rx_patients rxps ON (rxus.id = rxps.user_id)
		LEFT JOIN rx_groups rxgp ON (rxgp.id = rxps.group_id)
		WHERE rxus.id=:user_id ');
		$stmt->bindParam('user_id', $user_id);
		$stmt->execute();
		$details = $stmt->fetchAll(PDO::FETCH_OBJ);
      	
		if(count($details) > 0){
			$flag	=	'success';
			$result['msg']	=	'Success.';
			$result['details']	=	array(
				'email'		=>	$details[0]->email,
				'group_name'		=>	$details[0]->name,
			);
			
		}
		else{
			$flag	=	'error';
			$result['msg']	=	'No details found.';
		}
		
		return $this->response->withJson(array(
			'status' 	=> 	$flag,
			'message'	=>	$result 
		));
		
		
    } catch (PDOException $e) {

		return $this->response->withJson(array(
			'status' 	=> 	'error',
			'message'	=>	$e
		));
    }
});


function moveUploadedFiles($directory, Slim\Http\UploadedFile $uploadedFile, $medication_id){
	$extension = pathinfo($uploadedFile->getClientFilename(), PATHINFO_EXTENSION);
	$basename = $medication_id.time(); // see http://php.net/manual/en/function.random-bytes.php
	$filename = sprintf('%s.%0.8s', $basename, $extension);
	$uploadedFile->moveTo($directory . DIRECTORY_SEPARATOR . $filename);
	return $filename;
}
?>