<?php

use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use \Firebase\JWT\JWT;


$app->post('/guest/contact', function(Request $request, Response $response) {

    $inputControl = $request->getParsedBody();
   	$first_name	=	$inputControl['first_name'];
	$last_name	=	$inputControl['last_name'];
	$company_name	=	$inputControl['company_name'];
	$job_title	=	$inputControl['job_title'];
	$email	=	$inputControl['email'];
	$phone	=	$inputControl['phone'];
	$message	=	$inputControl['message'];
    try {
		
		
		/*.............Active campign Start..................*/
		
		$url = 'https://rxtoyou.api-us1.com';
		$key='d23525f33c29a6eddfe6e38ef4bf1c0bd82fe710de0d40d96115afafe3923f0fc3175c54';

  		$params = array(  
			'api_key'      => $key, 
			'api_action'   => 'contact_sync',
			'api_output'   => 'serialize',
		);

		// here we define the data we are posting in order to perform an update
		$post = array(

			'email'                    => $email,
			'first_name'               => $first_name,
			'last_name'                => $last_name,
			'phone'                    => $phone,


   			// 'form'          => $formid, // Subscription Form ID, to inherit those redirection settings

			'field[%COMPANY_NAME%,0]' 	=> 	$company_name,

			'field[%JOB_TITLE%,0]' 		=>	$job_title,
			'field[%MESSAGE%,0]' 		=>	$message,

			//	'field[%REFERRER%,0]' =>	$param['referer'],


			'p[2]'                   => 2, // example list ID (REPLACE '123' WITH ACTUAL LIST ID, IE: p[5] = 5)
    		'status[2]'              => 1, // 1: active, 2: unsubscribed (REPLACE '123' WITH ACTUAL LIST ID, IE: status[5] = 1)

			//'noresponders[123]'      => 1, // uncomment to set "do not send any future responders"

			//'sdate[123]'             => '2009-12-07 06:00:00', // Subscribe date for particular list - leave out to use current date/time

			// use the folowing only if status=1

			//'instantresponders[123]' => 1, // set to 0 to if you don't want to sent instant autoresponders

			//'lastmessage[123]'       => 1, // uncomment to set "send the last broadcast campaign"
			//'p[]'                    => 345, // some additional lists?
			//'status[345]'            => 1, // some additional lists?
		);

		// This section takes the input fields and converts them to the proper format

		$query = "";

		foreach( $params as $key => $value ) $query .= urlencode($key) . '=' . urlencode($value) . '&';

		$query = rtrim($query, '& ');



		// This section takes the input data and converts it to the proper format

		$data = "";

		foreach( $post as $key => $value ) $data .= urlencode($key) . '=' . urlencode($value) . '&';

		$data = rtrim($data, '& ');



		// clean up the url

		$url = rtrim($url, '/ ');



		// This sample code uses the CURL library for php to establish a connection,

		// submit your request, and show (print out) the response.

		if ( !function_exists('curl_init') ) die('CURL not supported. (introduced in PHP 4.0.2)');



		// If JSON is used, check if json_decode is present (PHP 5.2.0+)

		if ( $params['api_output'] == 'json' && !function_exists('json_decode') ) {

			die('JSON not supported. (introduced in PHP 5.2.0)');

		}



		// define a final API request - GET

		$api = $url . '/admin/api.php?' . $query;



		$request = curl_init($api); // initiate curl object

		curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response

		curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)

		curl_setopt($request, CURLOPT_POSTFIELDS, $data); // use HTTP POST to send form data

		//curl_setopt($request, CURLOPT_SSL_VERIFYPEER, FALSE); // uncomment if you get no gateway response and are using HTTPS

		curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);



		$response = (string)curl_exec($request); // execute curl post and store results in $response



		// additional options may be required depending upon your server configuration

		// you can find documentation on curl options at http://www.php.net/curl_setopt

		curl_close($request); // close curl object



		if ( !$response ) {

			die('Nothing was returned. Do you have a connection to Email Marketing server?');

		}



		// This line takes the response and breaks it into an array using:

		// JSON decoder

		//$result = json_decode($response);

		// unserializer

		$result = unserialize($response);


	   /*.............Active campign end..................*/


		
		$to = "info@hwbazaar.com";
		//$to = "jibinpd@webeteer.com";
		$subject = "Get in Touch";

		$message = "
			<html>
				<head>
					<title>Get in Touch</title>
				</head>
				<body>
					<div style='max-width:550px; margin:auto;border:1px solid #b6cace;'>
						<div style='background-color:#ffffff;text-align: center; background-color:#b6cace; padding:30px;'>
							<img width='255' src='http://hwx.hwbazaar.com/assets/images/header-logo.png' >
						</div>
						<div style='padding:50px;'>
							<p>Dear admin,</p>
							<p>     You have a message from ".$first_name." ".$last_name."</p>
							<div>
								<p>
									<span style='padding:10px;'><b>First Name :</b></span>
									<span style='padding:10px;'><b>".$first_name."</b></span>
								</p>
								<p>
									<span style='padding:10px;'><b>Last Name :</b></span>
									<span style='padding:10px;'><b>".$last_name."</b></span>
								</p>
								
								<p>
									<span style='padding:10px;'><b>Company Name :</b></span>
									<span style='padding:10px;'><b>".$company_name."</b></span>
								</p>
				
								<p>
									<span style='padding:10px;'><b>Job Title :</b></span>
									<span style='padding:10px;'><b>".$job_title."</b></span>
								</p>
								<p>
									<span style='padding:10px;'><b>Email :</b></span>
									<span style='padding:10px;'><b>".$email."</b></span>
								</p>
								<p>
									<span style='padding:10px;'><b>Phone :</b></span>
									<span style='padding:10px;'><b>".$phone."</b></span>
								</p>
								<p>
									<span style='padding:10px;'><b>Message :</b></span>
									<span style='padding:10px;'><b>".$message."</b></span>
								</p>
							</div>
						</div>
					</div>
				</body>
			</html> 
		";

		// Always set content-type when sending HTML email
		$headers = "MIME-Version: 1.0" . "\r\n";
		$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

		// More headers
		$headers .= 'From: <no-reply@rxtoyou.com>' . "\r\n";
		//$headers .= 'Cc: myboss@example.com' . "\r\n";

		
		mail($to,$subject,$message,$headers);
		
//		if(mail($to,$subject,$message,$headers)){
//			return $this->response->withJson(array(
//				'status' 	=> 'success',
//				'message'	=>	$result 
//			));
//		}
		
		if($result['result_code'] == 1){
			return $this->response->withJson(array(
				'status' 	=> 'success',
				'message'	=>	$result 
			));
		}
		
		
    } catch (PDOException $e) {
        return $this->response->withJson($e);
    }
    return $this->response->withJson(array('status' => 'error'));
});

$app->get('/guest/blo', function(Request $request, Response $response) {
	echo "HERE";
   	
	
    //return $this->response->withJson($ouput);
});
$app->post('/guest/blog', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
   	
	if($inputControl['limit']){
		$limit	=	"LIMIT ".$inputControl['limit'];
	}
	else{
		$limit = '';
	}
	try {
		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$blogQuerry = $db->prepare('SELECT blog_id, blog_title, blog_short_desc, blog_image, blog_thumb, updated_date from blog WHERE status=1 '.$limit);
		$blogQuerry->execute();
		$blogList = $blogQuerry->fetchAll(PDO::FETCH_OBJ);
		return $this->response->withJson($blogList);
		
    } catch (PDOException $e) {
        return $this->response->withJson($e);
    }
    //return $this->response->withJson($ouput);
});
$app->post('/guest/blog-read', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
   	$blog_id	=	$inputControl['blog_id'];
	try {
		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$blogQuerry = $db->prepare('SELECT blog_title, blog_content, blog_image, updated_date from blog WHERE blog_id=:var_blogid');
		$blogQuerry->bindParam('var_blogid',$blog_id);
		$blogQuerry->execute();
		$blogList = $blogQuerry->fetch(PDO::FETCH_OBJ);
		return $this->response->withJson($blogList);
		
    } catch (PDOException $e) {
        return $this->response->withJson($e);
    }
    //return $this->response->withJson($ouput);
});

$app->post('/guest/news', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
   	
	if($inputControl['limit']){
		$limit	=	"LIMIT ".$inputControl['limit'];
	}
	else{
		$limit = '';
	}
	try {
		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$blogQuerry = $db->prepare('SELECT news_id, news_title, news_short_desc, news_image, news_thumb, updated_date from news WHERE status=1 '.$limit);
		$blogQuerry->execute();
		$blogList = $blogQuerry->fetchAll(PDO::FETCH_OBJ);
		return $this->response->withJson($blogList);
		
    } catch (PDOException $e) {
        return $this->response->withJson($e);
    }
    //return $this->response->withJson($ouput);
});
$app->post('/guest/news-read', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
   	$news_id	=	$inputControl['news_id'];
	try {
		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$newsQuerry = $db->prepare('SELECT news_title, news_content, news_image, updated_date from news WHERE news_id=:var_newsid');
		$newsQuerry->bindParam('var_newsid',$news_id);
		$newsQuerry->execute();
		$newsList = $newsQuerry->fetch(PDO::FETCH_OBJ);
		return $this->response->withJson($newsList);
		
    } catch (PDOException $e) {
        return $this->response->withJson($e);
    }
    //return $this->response->withJson($ouput);
});


$app->post('/guest/order', function(Request $request, Response $response) {

    $inputControl = $request->getParsedBody();
   	

	$order_items		=	$inputControl['order_items'];
	$medication_items	=	$inputControl['medication_items'];

	$order_med_name	=	$order_med_strength = $order_med_no = $order_new_med = $order_maintenance_drug = $order_auto_refil = 	'';
	$cur_med_name	= $cur_med_strength	= $cur_med_count	= $cur_med_long	= $cur_illness = '';
	//echo $first_name;
	
	
	
	try {
		$db = new db();
		$db = $db->connect();
		
//		$db->query("SET  CHARACTER SET utf8;");
		
		$row = [
			'first_name' 	=> $inputControl['first_name'],
			'last_name' 	=> $inputControl['last_name'],
			'home_phone_no' => $inputControl['home_phone_no'],
			'mobile_phone_no'	=>			$inputControl['mobile_phone_no'],
			'email'				=>	$inputControl['email'],
			'shipping_address_1'		=>	$inputControl['shipping_address_1'],
			'shipping_address_2'		=>	$inputControl['shipping_address_2'],
			'shipping_city'		=>	$inputControl['shipping_city'],
			'shipping_state'	=>	$inputControl['shipping_state'],
			'shipping_zip'		=>	$inputControl['shipping_zip'],
			'physician_name'	=>	$inputControl['prescribing_physician_name'],
			'physician_ph'		=>	$inputControl['physician_ph'],
			'physician_fax'		=>	$inputControl['physician_fax'],
			'physician_address'	=>	$inputControl['physician_address'],
			'height_12'		=>	$inputControl['height_12'],
			'weight_12'		=>	$inputControl['weight_12'],
			'birth_day'		=>	$inputControl['birth_day'],
			'birth_month'		=>	$inputControl['birth_month'],
			'birth_year'		=>	$inputControl['birth_year'],
			'are_smoker'		=>	$inputControl['are_smoker'],
			'are_breastfeeding'	=>	$inputControl['are_breastfeeding'],
			'are_pregnant'		=>	$inputControl['are_pregnant'],
			'due_day'		=>	$inputControl['due_day'],
			'due_month'		=>	$inputControl['due_month'],
			'due_year'		=>	$inputControl['due_year'],
			'sex'			=>	$inputControl['sex'],
			'have_drug_allergies'	=>	$inputControl['have_drug_allergies'],
			'medical_history'		=>	$inputControl['medical_history'],
			'employer_name'		=>	$inputControl['employer_name'],
			'division'			=>	$inputControl['division'],
			'emp_relation'		=>	$inputControl['emp_relation'],
			'rem_notification'	=>	$inputControl['rem_notification'],
			'prescription'		=>	$inputControl['prescription'],
			'signature'			=>	$inputControl['signature'],
			'submit_day'		=>	$inputControl['submit_day'],
			'submit_month'		=>	$inputControl['submit_month'],
			'submit_year'		=>	$inputControl['submit_year'],
			'type'				=>	'patient',
			'status'			=>	1
		];

		$sql = "INSERT INTO medical_condition SET first_name=:first_name, last_name=:last_name, home_phone_no=:home_phone_no,mobile_phone_no=:mobile_phone_no,email=:email,shipping_address_1=:shipping_address_1,shipping_address_2=:shipping_address_2,shipping_city=:shipping_city,shipping_state=:shipping_state,shipping_zip=:shipping_zip,physician_name=:physician_name,physician_ph=:physician_ph,physician_fax=:physician_fax,physician_address=:physician_address,height_12=:height_12,weight_12=:weight_12,birth_day=:birth_day,birth_month=:birth_month,birth_year=:birth_year,are_smoker=:are_smoker,are_breastfeeding=:are_breastfeeding,are_pregnant=:are_pregnant,due_day=:due_day,due_month=:due_month,due_year=:due_year,sex=:sex,have_drug_allergies=:have_drug_allergies,medical_history=:medical_history,employer_name=:employer_name,division=:division,emp_relation=:emp_relation,rem_notification=:rem_notification,prescription=:prescription,signature=:signature,submit_day=:submit_day,submit_month=:submit_month,submit_year=:submit_year,type=:type,created_at=NOW(),status=:status;";

		/** @var PDO $pdo */
		$success 		= 	$db->prepare($sql)->execute($row);
		$medical_condition_id 	= 	$db->lastInsertId();
		
		if($medical_condition_id){
			
			$pass = substr(str_shuffle("0123456789abcdefghijklmnopqrstvwxyz"), 0, 6);
			$unique_key	=	 base64_encode($inputControl['email'].'&'.$medical_condition_id.'&'.$pass);
			
			$updateQuerry = $db->prepare('UPDATE medical_condition SET unique_key=:unique_key WHERE id=:id');
			$updateQuerry->bindParam('unique_key',$unique_key);
			$updateQuerry->bindParam('id',$medical_condition_id);
			$updateQuerry->execute();
			
			
			$order_count	=	count($order_items);
			if($order_count > 0){
				$order_loop_count	=	0;
				foreach($order_items as $item){
					$delimiter	=	($order_loop_count > 0)?'|':'';
					$order_med_name	.= $delimiter.$item['medication_name'];
					$order_med_strength	.= $delimiter.$item['medication_strength'];
					$order_med_no	.= $delimiter.$item['medication_no'];
					$order_new_med	.= $delimiter.$item['new_medication'];
					$order_maintenance_drug	.= $delimiter.$item['maintenance_drug'];
					$order_auto_refil	.= $delimiter.$item['auto_refil'];
					$row = [
						'medical_condition_id' 	=> 	$medical_condition_id,
						'medication_name' 		=> 	$item['medication_name'],
						'medication_strength'	=>	$item['medication_strength'],
						'medication_no'			=>	$item['medication_no'],
						'new_medication'		=>	$item['new_medication'],
						'maintenance_drug'		=>	$item['maintenance_drug'],
						'auto_refil'			=>	$item['auto_refil'],
						'status'				=>	1
					];
					$sql	=	"INSERT INTO medical_order_items SET medical_condition_id=:medical_condition_id,medication_name=:medication_name,medication_strength=:medication_strength,medication_no=:medication_no,new_medication=:new_medication,maintenance_drug=:maintenance_drug,auto_refil=:auto_refil,status=:status;";
					
					$success_1		= 	$db->prepare($sql)->execute($row);
					$order_loop_count++;
				}
			}
			
			$medication_count	=	count($medication_items);
			if($medication_count > 0){
				$medication_loop_count	=	0;
				foreach($medication_items as $medication){
					$delimiter	=	($medication_loop_count > 0)?'|':'';
					$cur_med_name	.= $delimiter.$medication['cur_medication_name'];
					$cur_med_strength	.= $delimiter.$medication['cur_medication_strength'];
					$cur_med_count	.= $delimiter.$medication['cur_medication_count'];
					$cur_med_long	.= $delimiter.$medication['cur_medication_long'];
					$cur_illness	.= $delimiter.$medication['cur_medication_illness']; 
					$row = [
						'medical_condition_id' 		=> 	$medical_condition_id,
						'cur_medication_name' 		=> 	$medication['cur_medication_name'],
						'cur_medication_strength'	=>	$medication['cur_medication_strength'],
						'cur_medication_count'		=>	$medication['cur_medication_count'],
						'cur_medication_long'		=>	$medication['cur_medication_long'],
						'cur_medication_illness'	=>	$medication['cur_medication_illness'],
						'status'					=>	1
					];
					$sql	=	"INSERT INTO medication_items SET medical_condition_id=:medical_condition_id,cur_medication_name=:cur_medication_name,cur_medication_strength=:cur_medication_strength,cur_medication_count=:cur_medication_count,cur_medication_long=:cur_medication_long,cur_medication_illness=:cur_medication_illness,status=:status;";
					
					$success_2		= 	$db->prepare($sql)->execute($row);
					$medication_loop_count++;
				}
			}
			
			
			
			
			$relationship = array(
				'employee' => 'Employee / Self',
				'spouse' => 'Spouse / Partner', 
				'dependant' => 'Dependant'
			);
			$notification = array(
			  	'home-phone' => 'Home phone',
				'mobile-phone' => 'Mobile phone', 
				'email' => 'Email'
			);
			$prescriptions =	array(
			  	'attached' => 'Upload the script files',
				'fax' => 'I will arrange for my doctor to fax my prescription(s) to (858) 779-2537.', 
				'request' => 'Please fax my doctor to request a copy of my prescription(s)'
			);
			
			
			
			/*.............Active campign Start..................*/
		
			$url = 'https://rxtoyou.api-us1.com';
			$key='d23525f33c29a6eddfe6e38ef4bf1c0bd82fe710de0d40d96115afafe3923f0fc3175c54';

			$params = array(  
				'api_key'      => $key, 
				'api_action'   => 'contact_sync',
				'api_output'   => 'serialize',
			);

			// here we define the data we are posting in order to perform an update
			$post = array(

				'email'                    => $inputControl['email'],
				'first_name'               => $inputControl['first_name'],
				'last_name'                => $inputControl['last_name'],
				'phone'                    => $inputControl['home_phone_no'],


				// 'form'          => $formid, // Subscription Form ID, to inherit those redirection settings

				'field[%MOBILE_PHONE%,0]' 	=> 	$inputControl['mobile_phone_no'],
				'field[%SHIPPING_ADDRESS_LINE_1%,0]' 		=>	$inputControl['shipping_address_1'],
				'field[%SHIPPING_ADDRESS_LINE_2%,0]' 		=>	$inputControl['shipping_address_2'],
				'field[%SHIPPING_ADDRESS_CITY%,0]' 		=>	$inputControl['shipping_city'],
				'field[%SHIPPING_ADDRESS_STATE%,0]' 		=>	$inputControl['shipping_state'],
				'field[%SHIPPING_ADDRESS_ZIP%,0]' 		=>	$inputControl['shipping_zip'],
				'field[%PRESCRIBING_PHYSICIAN_NAME%,0]' 		=>	$inputControl['prescribing_physician_name'],
				'field[%PHYSICIAN_PHONE_NUMBER%,0]' 		=>	$inputControl['physician_ph'],
				'field[%PHYSICIAN_FAX_NUMBER%,0]' 		=>	$inputControl['physician_fax'],
				'field[%PHYSICIAN_ADDRESS%,0]' 		=>	$inputControl['physician_address'],
				'field[%HEIGHT%,0]' 		=>	$inputControl['height_12'],
				'field[%WEIGHT%,0]' 		=>	$inputControl['weight_12'],
				'field[%DATE_OF_BIRTH%,0]' 		=>	$inputControl['birth_month'].'/'.$inputControl['birth_day'].'/'.$inputControl['birth_year'],
				'field[%ARE_A_SMOKER%,0]' 		=>	$inputControl['are_smoker'],
				'field[%ARE_BREASTFEEDING%,0]' 		=>	$inputControl['are_breastfeeding'],
				'field[%ARE_PREGNANT%,0]' 		=>	$inputControl['are_pregnant'],
				'field[%DUE_DATE%,0]' 		=>		$inputControl['due_month'].'/'.$inputControl['due_day'].'/'.$inputControl['due_year'],
				'field[%SEX%,0]' 		=>	$inputControl['sex'],
				'field[%DRUG_ALLERGIES%,0]' 		=>	$inputControl['have_drug_allergies'],
				'field[%MEDICAL_HISTORY%,0]' 		=>	$inputControl['medical_history'],
				'field[%NAME_OF_EMPLOYER_GROUP%,0]' 		=>	$inputControl['employer_name'],
				'field[%DIVISION%,0]' 		=>	$inputControl['division'],
				'field[%RELATIONSHIP_TO_EMPLOYER%,0]' 		=>	$relationship[$inputControl['emp_relation']],
				'field[%REFILL_REMINDER_NOTIFICATION_PREFERENCE%,0]' 	=>	$notification[$inputControl['rem_notification']],
				'field[%ORDER_MEDICATION_NAME%,0]' 		=>	$order_med_name,
				'field[%ORDER_MEDICATION_STRENGTH%,0]' 		=>	$order_med_strength,
				'field[%ORDER_HOW_MANY_PER_DAY%,0]' 		=>	$order_med_no,
				'field[%ORDER_NEW_MEDICATION%,0]' 		=>	$order_new_med,
				'field[%ORDER_MAINTENANCE_DRUG%,0]' 		=>	$order_maintenance_drug,
				'field[%ORDERAUTO_REFILL%,0]' 		=>	$order_auto_refil,
				'field[%CURRENT_MEDICATION_NAME%,0]' 		=>	$cur_med_name,
				'field[%CURRENT_MEDICATION_STRENGTH%,0]' 		=>	$cur_med_strength,
				'field[%CURRENT_MEDICATION_HOW_MANY_PER_DAY%,0]' 		=>	$cur_med_count,
				'field[%CURRENT_MEDICATION_HOW_LONG_TAKEN_FOR%,0]' 		=>	$cur_med_long,
				'field[%ILLNESS_OR_CONDITION%,0]' 		=>	$cur_illness,
				'field[%SIGNATURE%,0]' 		=>	$inputControl['signature'],
				'field[%SIGNATURE_DATE%,0]' 		=>	$inputControl['submit_month'].'/'.$inputControl['submit_day'].'/'.$inputControl['submit_year'],
				'field[%ORDER_TYPE%,0]'	=> 'Web',
				'field[%SUBMISSION_NUMBER%,0]'	=>	$medical_condition_id, 
				'field[%SCRIPT_RECEIVED%,0]' =>	'No',


				'p[4]'                   => 4, // example list ID (REPLACE '123' WITH ACTUAL LIST ID, IE: p[5] = 5)
				'status[4]'              => 1, // 1: active, 2: unsubscribed (REPLACE '123' WITH ACTUAL LIST ID, IE: status[5] = 1)
			);

			// This section takes the input fields and converts them to the proper format

			$query = "";

			foreach( $params as $key => $value ) $query .= urlencode($key) . '=' . urlencode($value) . '&';

			$query = rtrim($query, '& ');

			$data = "";

			foreach( $post as $key => $value ) $data .= urlencode($key) . '=' . urlencode($value) . '&';

			$data = rtrim($data, '& ');


			$url = rtrim($url, '/ ');

			if ( !function_exists('curl_init') ) die('CURL not supported. (introduced in PHP 4.0.2)');


			if ( $params['api_output'] == 'json' && !function_exists('json_decode') ) {

				die('JSON not supported. (introduced in PHP 5.2.0)');

			}

			$api = $url . '/admin/api.php?' . $query;

			$request = curl_init($api); // initiate curl object

			curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response

			curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)

			curl_setopt($request, CURLOPT_POSTFIELDS, $data); // use HTTP POST to send form data

			curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);


			$response = (string)curl_exec($request); 

			curl_close($request); 


			if ( !$response ) {

				die('Nothing was returned. Do you have a connection to Email Marketing server?');

			}

			$result = unserialize($response);


		   /*.............Active campign end..................*/

			
			
			
		}
		
		if($success && $success_1 && $success_2){
			if($inputControl['prescription'] == 'attached'){
				$message = "We have saved this information and you'll be redirected to upload your files.";
			}
			else{
				$message = "Your order has been submitted.";
			}
			return $this->response->withJson(array(
				'status' 	=> 'success',
				'message'	=>	$message,
				'details'	=>	array(
					'medication_id'	=>	$medical_condition_id,
					'email'			=>	$inputControl['email'],
					'unique_key'	=>	$unique_key
				)
			));
		}
		else if($success){
			return $this->response->withJson(array(
				'status' 	=> 'error',
				'message'	=>	'Your order could not be completed. Please contact the administrator.'
			));
		}
		else{
			return $this->response->withJson(array(
				'status' 	=> 'error',
				'message'	=>	'An error occured. Try again later.'
			));
		}
		

		
    } catch (PDOException $e) {
        return $this->response->withJson($e);
    }
});

$app->post('/guest/checkKey', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
   	$key	=	$inputControl['unique_key'];
	try {
		$db = new db();
		$db = $db->connect();
		
		$db->query("SET  CHARACTER SET utf8;");
		
		$keyQuerry = $db->prepare('SELECT id from medical_condition WHERE unique_key=:unique_key');
		$keyQuerry->bindParam('unique_key',$key);
		$keyQuerry->execute();
		$keyList = $keyQuerry->fetchAll(PDO::FETCH_OBJ);
		
		if(count($keyList) > 0){
			return $this->response->withJson(array(
				'status' 	=> 'success',
				'message'	=>	'Valid Key'
			));
		}
		else{
			return $this->response->withJson(array(
				'status' 	=> 'error',
				'message'	=>	'Sorry, your request cannot be processed due to invalid url.'
			));
		}
		
    } catch (PDOException $e) {
        return $this->response->withJson($e);
    }
    //return $this->response->withJson($ouput);
});


$app->post('/guest/orderFiles', function(Request $request, Response $response) {
	$inputControl = $request->getParsedBody();
	$medication_id	=	$inputControl['medication_id'];
	$upload_flag	=	false;
	$files = $request->getUploadedFiles();
	
	$patient_files	=	'';
   	$directory	=	'../../hw-uploads/medication-files';
	
	if($files){
		foreach ($files['file'] as $uploadedFile) {
			if ($uploadedFile->getError() === UPLOAD_ERR_OK) {
				$filename = moveUploadedFile($directory, $uploadedFile,$medication_id);
				if($filename != ''){
					try {
						$db = new db();
						$db = $db->connect();

						$db->query("SET  CHARACTER SET utf8;");

						$row = [
							'media_type' 	=> 	'medication_files',
							'relation_id'	=>	$medication_id,
							'file_name'		=>	$filename,
							'status'		=>	1
						];

						$media_query	=	'INSERT INTO media_files SET media_type=:media_type, relation_id=:relation_id, file_name=:file_name, status=:status';

						$success		= 	$db->prepare($media_query)->execute($row);
					
						if($success){
							$upload_flag	= true;
						}

					} 
					catch (PDOException $e) {
						return $this->response->withJson($e);
					}
				}
			}
		}
	
		if($upload_flag){
			
			try {
				$db = new db();
				$db = $db->connect();

				$db->query("SET  CHARACTER SET utf8;");

				$dataQuerry = $db->prepare('SELECT email from medical_condition WHERE id=:id');
				$dataQuerry->bindParam('id',$medication_id);
				$dataQuerry->execute();
				$email = $dataQuerry->fetch(PDO::FETCH_OBJ);
				
				
				$media_type	=	'medication_files';
				$stmt = $db->prepare('SELECT file_name from media_files WHERE media_type=:media_type AND relation_id=:id ');
				$stmt->bindParam('media_type', $media_type);
				$stmt->bindParam('id', $medication_id);
				$stmt->execute();
				$media_items = $stmt->fetchAll(PDO::FETCH_OBJ);
				foreach($media_items as $media){
					$patient_files .= 'https://www.rxtoyou.com/hw-uploads/medication-files/'.$media->file_name.', ';
				}

			} 
			catch (PDOException $e) {
				//return $this->response->withJson($e);
			}
			
			
			
			/*.............Active campign Start..................*/
		
			$url = 'https://rxtoyou.api-us1.com';
			$key='d23525f33c29a6eddfe6e38ef4bf1c0bd82fe710de0d40d96115afafe3923f0fc3175c54';

			$params = array(  
				'api_key'      => $key, 
				'api_action'   => 'contact_sync',
				'api_output'   => 'serialize',
			);

			// here we define the data we are posting in order to perform an update
			$post = array(

				'email'                    		=> $email->email,
				'field[%SCRIPT_RECEIVED%,0]' 	=>	'Yes',
				'field[%UPLOADED_FILES%,0]' 	=> $patient_files,
				'p[4]'                   => 4, // example list ID (REPLACE '123' WITH ACTUAL LIST ID, IE: p[5] = 5)
				'status[4]'              => 1, // 1: active, 2: unsubscribed (REPLACE '123' WITH ACTUAL LIST ID, IE: status[5] = 1)
			);

			// This section takes the input fields and converts them to the proper format

			$query = "";

			foreach( $params as $key => $value ) $query .= urlencode($key) . '=' . urlencode($value) . '&';

			$query = rtrim($query, '& ');

			$data = "";

			foreach( $post as $key => $value ) $data .= urlencode($key) . '=' . urlencode($value) . '&';

			$data = rtrim($data, '& ');


			$url = rtrim($url, '/ ');

			if ( !function_exists('curl_init') ) die('CURL not supported. (introduced in PHP 4.0.2)');


			if ( $params['api_output'] == 'json' && !function_exists('json_decode') ) {

				die('JSON not supported. (introduced in PHP 5.2.0)');

			}

			$api = $url . '/admin/api.php?' . $query;

			$request = curl_init($api); // initiate curl object

			curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response

			curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)

			curl_setopt($request, CURLOPT_POSTFIELDS, $data); // use HTTP POST to send form data

			curl_setopt($request, CURLOPT_FOLLOWLOCATION, true);


			$response = (string)curl_exec($request); 

			curl_close($request); 


			if ( !$response ) {

				die('Nothing was returned. Do you have a connection to Email Marketing server?');

			}

			$result = unserialize($response);


		   /*.............Active campign end..................*/
			

			return $this->response->withJson(array(
				'status' 	=> 'success',
				'message'	=>	'Your order has been submitted.'
			));
		}
		else{
			return $this->response->withJson(array(
				'status' 	=> 'error',
				'message'	=>	'An error occured. Try again later.'
			));
		}
	}
	else{
		return $this->response->withJson(array(
			'status' 	=> 'error',
			'message'	=>	'You need to select atleast one file to upload.'
		));
	}
	
});


function moveUploadedFile($directory, Slim\Http\UploadedFile $uploadedFile, $medication_id){
	$extension = pathinfo($uploadedFile->getClientFilename(), PATHINFO_EXTENSION);
	$basename = $medication_id.time(); // see http://php.net/manual/en/function.random-bytes.php
	$filename = sprintf('%s.%0.8s', $basename, $extension);
	$uploadedFile->moveTo($directory . DIRECTORY_SEPARATOR . $filename);
	return $filename;
}

?>
